# 画面設計書 138-顧客製品一覧

## 概要

本ドキュメントは、QuickerSite CMSにおける顧客製品一覧画面（ad_clientproducts.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システム管理者（Admin）が登録されている全クライアント製品（サービス契約）の一覧を表示・管理するための画面である。製品の契約状況、更新期限、料金などを一覧で確認できる。

**業務上の目的・背景**：QuickerSiteはホスティングサービスとして複数のクライアントにサービスを提供している。本画面は、全クライアントの契約製品を俯瞰し、更新期限が近い契約の把握、年間売上の概算などを行うための管理ツールとして機能する。契約管理、請求業務、サポート対応などで活用される。

**画面へのアクセス方法**：管理者メニュー（ad_adminMenu.asp）から製品一覧を選択してアクセスする。

**主要な操作・処理内容**：
1. 全クライアント製品の一覧表示
2. 更新期限に応じた視覚的な警告表示（色分け）
3. 年間売上合計の算出
4. 製品詳細画面へのリンク
5. テーブルソート機能

**画面遷移**：
- 遷移元：ad_adminMenu.asp（管理者メニュー）
- 遷移先：ad_clientproduct.asp（製品詳細）、ad_client.asp（クライアント詳細）

**権限による表示制御**：管理者認証（ad_security.asp）を通過したシステム管理者のみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 77 | ショッピングカート管理 | 主機能 | 顧客製品の一覧表示 |

## 画面種別

一覧（顧客製品一覧画面）

## URL/ルーティング

`asp/ad_clientproducts.asp`

## 入出力項目

本画面は一覧表示専用であり、入力項目はない。

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Nr | Integer | 連番 |
| Id | Integer | 製品ID |
| Name | String | 製品名（詳細へのリンク） |
| クライアント名 | String | 所属クライアント名（サブ表示） |
| Renew every | Integer | 更新周期（月数） |
| Last renewal | Date | 最終更新日 |
| End service | Date | サービス終了日 |
| Fee | Decimal | 料金 |
| Total | Decimal | 年間売上合計（フッター） |

### 行の色分け表示

| 条件 | 背景色 | 説明 |
|------|--------|------|
| iPrice <= 0 | なし | 無料サービス |
| dEndService設定済み | なし | 終了済みサービス |
| dLastRenewalDate未設定 | 黄色 | 更新日未設定（要確認） |
| 更新期限14日以内 | オレンジ | 更新期限間近（要対応） |
| その他 | なし | 通常状態 |

## イベント仕様

### 1-製品名クリック

製品名をクリックすると、製品詳細画面に遷移する。

1. 暗号化された製品ID・クライアントIDをパラメータとして渡す
2. ad_clientproduct.aspに遷移

### 2-テーブルソート

テーブルヘッダーをクリックすると、該当列でソートする。

1. JavaScriptのsortable機能でクライアントサイドソート

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblClientProduct | SELECT | 製品一覧を取得 |
| 画面表示 | tblClient | SELECT | クライアント名を取得 |

### テーブル別更新項目詳細

#### tblClientProduct（SELECT）

| 項目（カラム名） | 取得条件 | 備考 |
|-----------------|---------|------|
| iId | 全件 | 製品ID |
| sName | 全件 | 製品名 |
| iRenewal | 全件 | 更新周期（月） |
| iPrice | 全件 | 料金 |
| iClientID | 全件 | クライアントID |
| dLastRenewalDate | 全件 | 最終更新日 |
| dEndService | 全件 | サービス終了日 |

## メッセージ仕様

本画面にはメッセージ表示機能はない。

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 製品未登録 | テーブルが表示されない（空の状態） |
| 認証失敗 | ad_security.aspにより管理者ログイン画面にリダイレクト |

## 備考

- sortableクラスでソート可能なテーブルを実現
- sNameでASC順にソート（初期表示）
- 年間売上計算：月額料金 × (12 / 更新月数)
- 終了済みまたは無料サービスは年間計算から除外
- クライアント名をDictionaryにキャッシュして効率化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | clientproduct.asp | `asp/includes/clientproduct.asp` | cls_clientproductクラスのlist()メソッドを理解 |
| 1-2 | client.asp | `asp/includes/client.asp` | cls_clientクラスのlistAll()メソッドを理解 |

**読解のコツ**: list()メソッドはgetRows()で2次元配列を返す。クライアント名はDictionaryで別途取得してマッピングする。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_clientproducts.asp | `asp/ad_clientproducts.asp` | 一覧表示のメイン処理 |

**主要処理フロー**:
1. **行4-5**: cls_clientproductインスタンス作成とlist()呼び出し
2. **行8-14**: クライアント名をDictionaryにキャッシュ
3. **行15-33**: ループで製品一覧を出力、条件に応じて色分け
4. **行27-31**: 年間売上計算ロジック

### プログラム呼び出し階層図

```
ad_clientproducts.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ beginClient.asp (クライアント初期化)
    │
    ├─ ad_security.asp (管理者認証)
    │
    ├─ ad_adminMenu.asp (管理者メニュー)
    │
    ├─ cls_clientproduct
    │      └─ list() (製品一覧取得)
    │
    └─ cls_client
           └─ listAll() (クライアント一覧取得)
                  └─ Dictionary (名前マッピング)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

なし                ┌─────────────────┐
       ───────────▶ │ clientproduct   │
                    │ list()          │
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ tblClientProduct│
                    │ SELECT          │
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ client.listAll()│ ───▶ Dictionary
                    │ クライアント名   │       (ID→名前)
                    └─────────────────┘
                           │
                           ▼
                    ┌─────────────────┐
                    │ 表示処理         │
                    │ ・色分け判定    │
                    │ ・年間計算      │
                    │ ・合計算出      │
                    └─────────────────┘
                           │
                           ▼
                    [画面表示]
                    ・製品一覧テーブル
                    ・年間合計
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_clientproducts.asp | `asp/ad_clientproducts.asp` | ソース | 製品一覧画面 |
| ad_clientproduct.asp | `asp/ad_clientproduct.asp` | ソース | 製品詳細画面（遷移先） |
| ad_client.asp | `asp/ad_client.asp` | ソース | クライアント詳細（遷移先） |
| clientproduct.asp | `asp/includes/clientproduct.asp` | インクルード | 製品クラス定義 |
| client.asp | `asp/includes/client.asp` | インクルード | クライアントクラス定義 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証 |
| ad_adminMenu.asp | `asp/ad_adminMenu.asp` | インクルード | 管理者メニュー |
