# 画面設計書 140-ページ一覧

## 概要

本ドキュメントは、QuickerSite CMSにおけるページ一覧画面（ad_pageList.asp）の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、システム管理者（Admin）が全顧客サイトのページを横断的に一覧表示するための画面である。ページのタイトル、所属アカウント、作成日時、更新日時、訪問者数/日を確認できる。

**業務上の目的・背景**：QuickerSiteはマルチテナント型CMSであり、複数のサイト（顧客）を管理している。本画面は、全サイトのページを俯瞰し、最近更新されたページや訪問者数の多いページを把握するための管理ツールである。システム全体の利用状況監視、コンテンツ管理、運用監視などで活用される。

**画面へのアクセス方法**：管理者バックエンド画面（ad_back.asp）からアクセスする。

**主要な操作・処理内容**：
1. 全顧客サイトのページ一覧表示
2. 更新日時降順でのソート（デフォルト）
3. テーブルヘッダーによるソート機能
4. ページ詳細へのリンク
5. 全件表示/上位250件表示の切り替え

**画面遷移**：
- 遷移元：ad_back.asp（管理者バックエンド）
- 遷移先：default.asp（ページ詳細）

**権限による表示制御**：管理者認証（ad_security.asp）を通過したシステム管理者のみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | ページ一覧表示 |

## 画面種別

一覧（ページ一覧画面）

## URL/ルーティング

`asp/ad_pageList.asp?showAll={true/false}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|-----------|----------|------|------|
| 全件表示フラグ | showAll | 入力 | Boolean | - | true: 全件表示、false: 上位250件 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 総ページ数 | Integer | ページ総数（全件表示時のみ） |
| Title | String | ページタイトル（30文字超は省略表示） |
| Account | String | 所属顧客名 |
| Created on | DateTime | 作成日時 |
| Updated on | DateTime | 更新日時 |
| Visits/day | Integer | 1日あたり訪問者数 |
| Show all リンク | Link | 全件表示切り替え |

### テーブル列詳細

| 列番号 | 列名 | データソース | 備考 |
|-------|------|-------------|------|
| 1 | Title | tblPage.sTitle | 先頭30文字、リンク付き |
| 2 | Account | tblCustomer.sName | 顧客名 |
| 3 | Created on | tblPage.createdTS | formatTimeStamp()で整形 |
| 4 | Updated on | tblPage.updatedTS | formatTimeStamp()で整形 |
| 5 | Visits/day | 計算値 | iVisitors / 経過日数 |

## イベント仕様

### 1-ページタイトルクリック

ページタイトルをクリックすると、該当ページの詳細画面に遷移する。

1. 暗号化されたページIDをパラメータとして渡す
2. 該当顧客サイトのdefault.aspに遷移
3. 新しいウィンドウ（タブ）で開く（target属性）

### 2-テーブルソート

テーブルヘッダーをクリックすると、該当列でソートする。

1. sortableクラスでクライアントサイドソート
2. 全列でソート可能

### 3-Show allリンククリック

「Show all」リンクをクリックすると、全ページを表示する。

1. showAll=trueでページ再読み込み
2. 250件制限を解除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblPage | SELECT | ページ一覧を取得 |
| 画面表示 | tblCustomer | SELECT | 顧客名を取得（JOIN） |

### テーブル別更新項目詳細

#### tblPage / tblCustomer（SELECT・JOIN）

| 項目（カラム名） | 取得条件 | 備考 |
|-----------------|---------|------|
| tblPage.iId | bOnline=true | ページID |
| tblPage.sTitle | bOnline=true | ページタイトル |
| tblCustomer.sName | JOIN | 顧客名 |
| tblPage.createdTS | bOnline=true | 作成日時 |
| tblPage.updatedTS | bOnline=true | 更新日時 |
| tblCustomer.sUrl | JOIN | サイトURL |
| tblPage.iVisitors | bOnline=true | 訪問者数 |
| tblCustomer.dResetStats | JOIN | 統計リセット日 |

**SQL概要**:
```sql
SELECT [TOP 250]
  tblPage.iId, tblPage.sTitle, tblCustomer.sName,
  tblPage.createdTS, tblPage.updatedTS,
  tblCustomer.sUrl, tblPage.iVisitors, tblCustomer.dResetStats
FROM tblPage
INNER JOIN tblCustomer ON tblCustomer.iID = tblPage.iCustomerID
WHERE tblPage.bOnline = true
ORDER BY tblPage.updatedTS DESC
```

## メッセージ仕様

| 種別 | メッセージキー | 説明 |
|------|--------------|------|
| ラベル | totalnumberofpages | 総ページ数ラベル |
| ラベル | title | タイトル列ヘッダー |
| ラベル | account | アカウント列ヘッダー |
| ラベル | createdon | 作成日時列ヘッダー |
| ラベル | updatedon | 更新日時列ヘッダー |
| ラベル | visits/day | 訪問数/日列ヘッダー |
| リンク | showall | 全件表示リンク |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| ページ未登録 | テーブルが表示されない（空の状態） |
| 認証失敗 | ad_security.aspにより管理者ログイン画面にリダイレクト |

## 備考

- デフォルト表示は上位250件（showAll=falseまたは未指定時）
- 更新日時（updatedTS）の降順でソート
- 訪問者数/日 = iVisitors / aantalDagenWithDate(dResetStats)
- ページタイトルは30文字を超えると「...」で省略
- 「&」文字は「&amp;」にエスケープして表示
- オンライン（bOnline=true）のページのみ表示
- 全顧客サイトを横断して表示（マルチテナント対応）
- sortableクラスでソート可能なテーブル

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | search.asp | `asp/includes/search.asp` | cls_searchクラスのallPages()メソッドを理解 |

**読解のコツ**: cls_searchクラスは検索機能を提供するクラスだが、allPages()メソッドは管理者向けに全ページ一覧を取得する機能。showAllプロパティでTOP 250の制限を制御。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_pageList.asp | `asp/ad_pageList.asp` | メイン処理フロー |

**主要処理フロー**:
1. **行5**: cls_searchインスタンス作成
2. **行6**: showAllパラメータ取得
3. **行7-8**: allPages()呼び出しで2次元配列取得
4. **行8-9**: ループで一覧表示、訪問数/日計算

#### Step 3: 各処理層の詳細

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | search.asp | `asp/includes/search.asp` | allPages()メソッド（行155-170） |
| 3-2 | search.asp | `asp/includes/search.asp` | showAllによるTOP 250制御（行158-160） |

### プログラム呼び出し階層図

```
ad_pageList.asp
    │
    ├─ begin.asp (共通初期化)
    │
    ├─ ad_security.asp (管理者認証)
    │
    ├─ cls_search
    │      ├─ class_initialize() (初期化)
    │      └─ allPages() (ページ一覧取得)
    │            ├─ showAll判定
    │            │     ├─ true: 全件取得
    │            │     └─ false: TOP 250
    │            └─ getRows() (2次元配列)
    │
    ├─ formatTimeStamp() (日時整形)
    │
    ├─ aantalDagenWithDate() (経過日数計算)
    │
    ├─ encrypt() (ID暗号化)
    │
    └─ ad_back.asp (管理者ナビゲーション)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

showAll              ┌─────────────────┐
       ───────────▶  │ cls_search      │
                     │ allPages()      │
                     └─────────────────┘
                           │
                           ▼
                     ┌─────────────────┐
                     │ tblPage         │
                     │ tblCustomer     │
                     │ INNER JOIN      │
                     └─────────────────┘
                           │
                           ▼
                     ┌─────────────────┐
                     │ getRows()       │
                     │ 2次元配列       │
                     └─────────────────┘
                           │
                           ▼
                     ┌─────────────────┐
                     │ 表示処理         │
                     │ ・タイトル省略   │
                     │ ・日時整形       │
                     │ ・訪問数/日計算  │
                     │ ・ID暗号化      │
                     └─────────────────┘
                           │
                           ▼
                     [画面表示]
                     ・ページ一覧テーブル
                     ・総ページ数
                     ・Show allリンク
```

### 配列インデックス対応表

allPages()が返す2次元配列の構造：

| インデックス | カラム | 説明 |
|------------|--------|------|
| 0 | tblPage.iId | ページID |
| 1 | tblPage.sTitle | ページタイトル |
| 2 | tblCustomer.sName | 顧客名 |
| 3 | tblPage.createdTS | 作成日時 |
| 4 | tblPage.updatedTS | 更新日時 |
| 5 | tblCustomer.sUrl | サイトURL |
| 6 | tblPage.iVisitors | 訪問者数 |
| 7 | tblCustomer.dResetStats | 統計リセット日 |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_pageList.asp | `asp/ad_pageList.asp` | ソース | ページ一覧画面 |
| search.asp | `asp/includes/search.asp` | インクルード | 検索・一覧クラス定義 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証 |
| ad_back.asp | `asp/ad_back.asp` | インクルード | 管理者ナビゲーション |
| default.asp | `asp/default.asp` | ソース | ページ詳細（遷移先） |
