# 画面設計書 141-フォームエントリー

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けフォームエントリー画面（ad_formentries.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、QuickerSite CMSに登録されているすべての顧客サイトから送信されたフォームデータを一元的に閲覧・管理するために設計されている。システム管理者は、複数のサイトにまたがるフォーム送信データを横断的に確認でき、サイトごとの送信状況やフォームの利用状況を把握することができる。これにより、顧客サポートやデータ分析に活用することが可能となる。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. 全サイトのフォーム送信データを新着順に最大250件まで一覧表示
2. 各送信データをクリックすることでポップアップウィンドウに詳細情報を表示
3. 送信データの詳細画面では、フォームフィールドとその入力値を表示
4. 該当フォームおよびサイト全体の送信件数を統計情報として表示

**画面遷移**：管理者ダッシュボード（ad_default.asp）から本画面に遷移する。詳細表示はポップアップウィンドウで表示されるため、一覧画面からの遷移はない。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 42 | フォーム送信データ表示 | 主機能 | フォーム送信データの一覧表示および詳細表示 |

## 画面種別

一覧 / 詳細（ポップアップ）

## URL/ルーティング

```
asp/ad_formentries.asp
asp/ad_formentries.asp?iSubmissionID={送信ID}
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| iSubmissionID | 数値 | 入力 | 任意 | 詳細表示する送信データのID |

## 表示項目

### 一覧表示

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 連番 | 数値 | 1から250までの行番号 |
| Date | 日付 | 送信日時（ヨーロッパ形式） |
| Message | 文字列 | フォーム名（リンク） |
| Site | 文字列 | サイト名 |

### 詳細表示（ポップアップ）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| フィールド名 | 文字列 | フォームフィールドの名前 |
| 入力値 | 文字列 | ユーザーが入力した値 |
| 同一フォーム送信件数 | 数値 | 同じフォームへの総送信件数 |
| サイト全体送信件数 | 数値 | サイト全体のフォーム送信件数 |

## イベント仕様

### 1-フォーム名リンククリック

フォーム名のリンクをクリックすると、新しいウィンドウで該当する送信データの詳細情報が表示される。

**処理フロー**：
1. iSubmissionIDパラメータ付きで同画面を新規ウィンドウで開く
2. cls_submissionクラスをインスタンス化し、送信データを取得
3. 関連するフォームとフィールド情報を取得
4. フィールドごとの入力値をリスト形式で表示
5. 統計情報（同一フォーム送信件数、サイト全体送信件数）を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | tblFormSubmission, tblForm, tblCustomer | SELECT | 送信データ一覧の取得 |
| 詳細表示 | tblFormSubmission, tblForm, tblFormField, tblFormFieldValue | SELECT | 送信データ詳細の取得 |

### テーブル別更新項目詳細

#### tblFormSubmission（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | dCreatedTS | 送信日時 | 降順でソート |
| SELECT | iId | 送信データID | 詳細表示用 |
| SELECT | iFormID | フォームID | フォーム情報取得用 |

#### tblForm（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sName | フォーム名 | 表示用 |
| SELECT | iCustomerID | 顧客ID | サイト情報取得用 |

#### tblCustomer（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sName | サイト名 | 表示用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | There are {n} similar submissions | 同一フォームへの送信件数 |
| 情報 | There are {n} submissions for this total website | サイト全体の送信件数 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| 無効な送信ID | 詳細データが取得できず空の表示 |

## 備考

- 一覧表示は最大250件までに制限されている
- 詳細表示はポップアップウィンドウ（target="_new"）で開かれる
- 日付表示はヨーロッパ形式（convertEurodate関数）が使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | submission.asp | `asp/includes/submission.asp` | cls_submissionクラスの構造、フォーム送信データの取得方法 |

**読解のコツ**: cls_submissionクラスはフォーム送信データを管理し、関連するフォームとフィールド値へのアクセスを提供する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_formentries.asp | `asp/ad_formentries.asp` | 画面のメインロジック、一覧表示と詳細表示の分岐 |

**主要処理フロー**:
1. **4行目**: iSubmissionIDパラメータの存在チェック
2. **7-8行目**: cls_submissionのインスタンス化とデータ取得
3. **25-38行目**: 一覧表示用のSQLクエリ実行とループ処理

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_formentries.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ [詳細表示モード]
    │      ├─ cls_submission.pick()
    │      │      └─ tblFormSubmission（SELECT）
    │      ├─ cls_form.pick()
    │      │      └─ tblForm（SELECT）
    │      └─ cls_submission.values()
    │             └─ tblFormFieldValue（SELECT）
    │
    └─ [一覧表示モード]
           └─ db.execute()（結合クエリ）
                  └─ tblFormSubmission + tblForm + tblCustomer
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iSubmissionID ───▶ cls_submission.pick() ───▶ 詳細HTML（ポップアップ）
     （任意）              │
                          ▼
                   cls_form.pick()
                          │
                          ▼
                   values取得
                          │
                          ▼
                   統計カウント

(パラメータなし) ───▶ SQL結合クエリ ───▶ 一覧テーブル
                          │
                          ▼
                   最大250件ループ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_formentries.asp | `asp/ad_formentries.asp` | ソース | メイン画面ファイル |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| submission.asp | `asp/includes/submission.asp` | ソース | フォーム送信データクラス |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| ad_back.asp | `asp/ad_back.asp` | テンプレート | 管理者画面戻るリンク |
