# 画面設計書 142-ゲストブックエントリー

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けゲストブックエントリー画面（ad_gbentries.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、QuickerSite CMSに登録されているすべての顧客サイトのゲストブック投稿を一元的に閲覧・監視するために設計されている。システム管理者は、複数サイトにまたがるゲストブック投稿を横断的に確認でき、スパム投稿の監視やサイト利用状況の把握に活用できる。ゲストブックは訪問者がサイトにコメントを残す機能であり、その投稿内容を一括で確認できることは運用管理上重要である。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. 全サイトのゲストブック投稿を新着順に最大50件まで一覧表示
2. 各投稿の日時、内容（最初の400文字）、投稿先サイト名を表示
3. サイト名をクリックすることで該当サイトを新しいウィンドウで開く

**画面遷移**：管理者ダッシュボード（ad_default.asp）から本画面に遷移する。サイト名リンクをクリックすると該当サイトが新規ウィンドウで開かれる。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | ゲストブック投稿管理 | 主機能 | ゲストブック投稿の一覧表示 |

## 画面種別

一覧

## URL/ルーティング

```
asp/ad_gbentries.asp
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| - | - | - | - | 入力パラメータなし |

## 表示項目

### 一覧表示

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Date | 日付 | 投稿日時（ヨーロッパ形式） |
| Message | 文字列 | 投稿内容（最初の400文字 + "..."） |
| Site | 文字列 | サイト名（リンク） |

## イベント仕様

### 1-サイト名リンククリック

サイト名のリンクをクリックすると、該当するサイトのURLが新しいウィンドウで開かれる。

**処理フロー**：
1. tblCustomerテーブルのsUrlカラムに格納されているURLを取得
2. target="_new"属性により新規ウィンドウで該当サイトを開く

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | tblGuestBookItem, tblGuestBook, tblCustomer | SELECT | ゲストブック投稿一覧の取得 |

### テーブル別更新項目詳細

#### tblGuestBookItem（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | dCreatedTS | 投稿日時 | 降順でソート |
| SELECT | sValue | 投稿内容 | 最初の400文字を表示 |
| SELECT | iGuestBookID | ゲストブックID | 紐付け用 |

#### tblGuestBook（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iCustomerID | 顧客ID | サイト情報取得用 |

#### tblCustomer（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sName | サイト名 | 表示用 |
| SELECT | sUrl | サイトURL | リンク用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 特別なメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| ゲストブック未存在 | 該当行をスキップして表示しない |

## 備考

- 一覧表示は最大50件までに制限されている（TOP 50）
- 投稿内容は400文字で切り捨て、"..."が付加される
- 日付表示はヨーロッパ形式（convertEurodate関数）が使用される
- 投稿内容はquotRep関数でHTMLエスケープ処理される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ad_gbentries.asp | `asp/ad_gbentries.asp` | tblGuestBookItem, tblGuestBook, tblCustomerの関係性 |

**読解のコツ**: ゲストブック投稿（tblGuestBookItem）はゲストブック（tblGuestBook）に紐付き、ゲストブックは顧客（tblCustomer）に紐付く3層構造になっている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_gbentries.asp | `asp/ad_gbentries.asp` | 画面のメインロジック、一覧表示処理 |

**主要処理フロー**:
1. **6-7行目**: cls_customerListのインスタンス化
2. **9行目**: TOP 50で投稿データを取得
3. **10-24行目**: ループ処理で各投稿を表示

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_gbentries.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ cls_customerList.getAll()
    │      └─ tblCustomer（SELECT）
    │
    └─ メインループ
           ├─ db.execute()（TOP 50クエリ）
           │      └─ tblGuestBookItem
           │
           └─ db.execute()（サイト情報取得）
                  └─ tblCustomer + tblGuestBook（INNER JOIN）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(なし) ───────────▶ TOP 50クエリ実行 ───▶ 一覧テーブル
                          │
                          ▼
                   ループ処理（各投稿）
                          │
                          ▼
                   サイト情報取得（結合クエリ）
                          │
                          ▼
                   HTML行生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_gbentries.asp | `asp/ad_gbentries.asp` | ソース | メイン画面ファイル |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| customerList.asp | `asp/includes/customerList.asp` | ソース | 顧客リストクラス |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| ad_back.asp | `asp/ad_back.asp` | テンプレート | 管理者画面戻るリンク |
