# 画面設計書 143-リファラー一覧

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けリファラー一覧画面（ad_refererList.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、QuickerSite CMSに登録されているすべての顧客サイトへの外部参照元（リファラー）情報を一元的に閲覧・分析するために設計されている。システム管理者は、どのサイトにどこから流入があるかを横断的に確認でき、マーケティング分析やトラフィック監視に活用できる。リファラー情報はSEO対策やアクセス解析において重要な指標であり、複数サイトの流入元を一括で把握できることは運用管理上有益である。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. 全サイトのリファラー情報を集計し、サイト別のリファラー件数を一覧表示（デフォルト表示）
2. 特定サイトを選択すると、そのサイトへのリファラー詳細一覧を表示
3. 最大15,000件のセッションデータから集計
4. ソート可能なテーブル形式で表示

**画面遷移**：管理者ダッシュボード（ad_default.asp）から本画面に遷移する。サイト名をクリックすると同画面にselectedname付きでリロードされ、詳細一覧が表示される。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 92 | 参照元サイト一覧 | 主機能 | 参照元サイトの一覧表示・集計 |

## 画面種別

一覧（集計表示 / 詳細表示）

## URL/ルーティング

```
asp/ad_refererList.asp
asp/ad_refererList.asp?selectedname={サイト名}
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| selectedname | 文字列 | 入力 | 任意 | 詳細表示するサイト名（最大100文字） |

## 表示項目

### 集計表示（selectedname未指定時）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Account | 文字列 | サイト名（リンク） |
| Referers | 数値 | リファラー件数 |

### 詳細表示（selectedname指定時）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Referrer | 文字列 | 参照元URL（最初の60文字、リンク） |
| Date | 日付 | アクセス日時 |

## イベント仕様

### 1-サイト名リンククリック（集計画面）

サイト名のリンクをクリックすると、同画面にselectednameパラメータ付きでリロードされ、該当サイトのリファラー詳細一覧が表示される。

**処理フロー**：
1. selectednameパラメータにサイト名をURLエンコードして設定
2. 同画面をリロード
3. 詳細表示モードで処理

### 2-リファラーURLリンククリック（詳細画面）

リファラーURLのリンクをクリックすると、該当URLが新しいウィンドウで開かれる。

**処理フロー**：
1. target="_blank"属性により新規ウィンドウで該当URLを開く

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示（集計） | tblSession, tblCustomer | SELECT | セッション情報とサイト情報の取得・集計 |
| 一覧表示（詳細） | tblSession, tblCustomer | SELECT | 特定サイトのセッション情報取得 |

### テーブル別更新項目詳細

#### tblSession（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | Referer | 参照元URL | 表示用 |
| SELECT | dTS | アクセス日時 | 降順でソート |
| SELECT | iCustomerID | 顧客ID | 紐付け用 |

#### tblCustomer（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sName | サイト名 | フィルタリング・表示用 |
| SELECT | sUrl | サイトURL | 表示用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | Referers for {サイト名}: | 詳細表示時のタイトル |
| 情報 | {n} results | 詳細表示時の結果件数 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| サイト名不正 | SQLインジェクション対策としてシングルクォートをエスケープ |

## 備考

- 最大15,000件のセッションデータを取得対象とする
- 集計表示ではDictionary オブジェクトを使用してサイト別にカウント
- SortDictionary2関数で件数順にソート
- テーブルにはsortableクラスが適用され、JavaScriptによるソートが可能
- リファラーURLは60文字で切り捨てて表示（ツールチップに全文表示）
- SQLインジェクション対策として入力値のエスケープ処理を実施

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ad_refererList.asp | `asp/ad_refererList.asp` | tblSession, tblCustomerの関係性と集計ロジック |

**読解のコツ**: セッション情報（tblSession）には顧客ID（iCustomerID）とリファラー（Referer）が格納されており、顧客テーブルと結合して集計を行う。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_refererList.asp | `asp/ad_refererList.asp` | 画面のメインロジック、表示モードの分岐 |

**主要処理フロー**:
1. **5行目**: selectednameパラメータの取得
2. **6-11行目**: SQLクエリの構築（フィルタリング条件追加）
3. **13-28行目**: 集計モードの処理（Dictionary使用）
4. **29-35行目**: 詳細モードの処理

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_refererList.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ [集計モード: selectedname未指定]
    │      ├─ db.execute()（TOP 15000クエリ）
    │      │      └─ tblSession + tblCustomer（INNER JOIN）
    │      │
    │      ├─ Dictionary集計処理
    │      │
    │      └─ SortDictionary2()（件数順ソート）
    │
    └─ [詳細モード: selectedname指定]
           └─ db.execute()（フィルタリングクエリ）
                  └─ tblSession + tblCustomer（WHERE条件付き）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

selectedname ───▶ SQL構築（条件分岐） ───▶ 詳細テーブル
  （任意）              │                      + 件数表示
                       │
                       ▼
                  [未指定の場合]
                       │
                       ▼
                  Dictionary集計
                       │
                       ▼
                  SortDictionary2 ───▶ 集計テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_refererList.asp | `asp/ad_refererList.asp` | ソース | メイン画面ファイル |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理・共通関数 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| ad_back.asp | `asp/ad_back.asp` | テンプレート | 管理者画面戻るリンク |
