# 画面設計書 144-モニター

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けモニター画面（ad_monitor.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、QuickerSite CMSに登録されているすべての顧客サイトのアクセスログを一元的に監視・管理するために設計されている。システム管理者は、すべてのサイトへのアクセス状況をリアルタイムで確認でき、サーバーの負荷状況やアクセスパターンを分析することができる。また、モニタリング機能の全サイト一括ON/OFF切り替えや、ログの削除・クリーンアップ機能も提供する。これにより、システム全体のパフォーマンス監視や問題発生時の原因調査に活用できる。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. モニターログを新着順に最大1,000件（または5,000件）まで一覧表示
2. 全サイトのモニター機能を一括でON/OFFに切り替え
3. すべてのモニターログを一括削除
4. 特定の文字列を含むログを部分一致で削除
5. 統計情報（開始日時、終了日時、経過時間、ヒット/秒）の表示

**画面遷移**：管理者ダッシュボード（ad_default.asp）から本画面に遷移する。本画面での操作は同画面にリダイレクトされる形で処理される。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | アクセス統計表示 | 主機能 | サイトモニタリング・監視機能 |

## 画面種別

一覧 / 操作

## URL/ルーティング

```
asp/ad_monitor.asp
asp/ad_monitor.asp?turn=off
asp/ad_monitor.asp?turn=on
asp/ad_monitor.asp?turn=remove
asp/ad_monitor.asp?show5000=on
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| turn | 文字列 | 入力 | 任意 | 操作種別（off/on/remove） |
| show5000 | 文字列 | 入力 | 任意 | 5,000件表示フラグ（on） |
| sDelete | 文字列 | 入力 | 任意 | 削除対象の検索文字列（最大30文字） |

## 表示項目

### 一覧表示

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Date | 日時 | ログ記録日時（ヨーロッパ形式） |
| Details | 文字列 | アクセス詳細情報 |

### 統計情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Started on | 日時 | 最も古いログの日時 |
| Ended on | 日時 | 最も新しいログの日時 |
| Time elapsed | 秒/時間 | 経過時間 |
| Total | 数値 | 総ログ件数 |
| Hits/second | 数値 | 1秒あたりのヒット数 |

## イベント仕様

### 1-Turn OFF monitor for all sites

すべてのサイトのモニター機能をOFFにする。

**処理フロー**：
1. turn=offパラメータで画面にアクセス
2. tblCustomerテーブルのbMonitorカラムをFALSEに一括更新
3. 画面を再表示

### 2-Turn ON monitor for all sites

すべてのサイトのモニター機能をONにする。

**処理フロー**：
1. turn=onパラメータで画面にアクセス
2. tblCustomerテーブルのbMonitorカラムをTRUEに一括更新
3. 画面を再表示

### 3-Remove all logs

すべてのモニターログを削除する。確認ダイアログが表示される。

**処理フロー**：
1. JavaScript confirmによる確認
2. turn=removeパラメータで画面にアクセス
3. tblMonitorテーブルから全レコードを削除
4. 画面を再表示

### 4-部分一致削除

指定した文字列を含むログを削除する。

**処理フロー**：
1. sDeleteに検索文字列を入力してフォーム送信
2. tblMonitorテーブルからsDetailカラムにLIKE検索で一致するレコードを削除
3. 画面を再表示

### 5-Show 5000 logs

表示件数を5,000件に拡大する。

**処理フロー**：
1. show5000=onパラメータで画面にアクセス
2. 表示件数上限を1,001から5,001に変更
3. 画面を再表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | tblMonitor | SELECT | モニターログの取得 |
| Turn OFF | tblCustomer | UPDATE | bMonitorをFALSEに一括更新 |
| Turn ON | tblCustomer | UPDATE | bMonitorをTRUEに一括更新 |
| Remove all | tblMonitor | DELETE | 全レコード削除 |
| 部分一致削除 | tblMonitor | DELETE | 条件一致レコード削除 |

### テーブル別更新項目詳細

#### tblMonitor

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | dts | ログ記録日時 | 降順でソート |
| SELECT | sDetail | アクセス詳細情報 | 表示用 |
| DELETE | - | 全レコードまたはsDetail LIKE '%検索文字列%' | 削除処理 |

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bMonitor | TRUE または FALSE | 一括更新 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 確認 | Are you sure to remove all logs? | Remove all logs リンククリック時 |
| 情報 | Started on: {日時} | 統計情報表示 |
| 情報 | Ended on: {日時} | 統計情報表示 |
| 情報 | Time elapsed: {秒} seconds / {時間} hours | 統計情報表示 |
| 情報 | Total: {件数} | 統計情報表示 |
| 情報 | Hits/second: {数値} hits/second | 統計情報表示 |
| 表示 | Please wait... | 初期表示時（JavaScriptで置換） |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| ログが2件未満 | 統計情報を表示しない |

## 備考

- デフォルトでは最大1,000件、show5000=onで最大5,000件表示
- 日時表示はヨーロッパ形式（convertEuroDateTime関数）が使用される
- 詳細情報は横スクロール可能なdiv（幅590px）で表示される
- 統計情報はJavaScriptで動的に表示される
- 部分一致削除では入力値がcleanup関数でサニタイズされる
- ソート可能なテーブル形式（sortableクラス）で表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ad_monitor.asp | `asp/ad_monitor.asp` | tblMonitor, tblCustomerの構造と操作 |

**読解のコツ**: tblMonitorテーブルにはアクセスログが格納され、tblCustomerテーブルのbMonitorフラグでモニタリング有効/無効を制御する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_monitor.asp | `asp/ad_monitor.asp` | 画面のメインロジック、操作の分岐処理 |

**主要処理フロー**:
1. **4-11行目**: turnパラメータによる操作分岐（off/on/remove）
2. **12-13行目**: sDeleteによる部分一致削除
3. **17-22行目**: 表示件数の決定
4. **25-36行目**: ログ一覧の取得とループ表示
5. **37-38行目**: 統計情報の計算とJavaScript出力

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_monitor.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ [操作処理: turnパラメータ]
    │      ├─ turn=off → UPDATE tblCustomer SET bMonitor=FALSE
    │      ├─ turn=on  → UPDATE tblCustomer SET bMonitor=TRUE
    │      └─ turn=remove → DELETE FROM tblMonitor
    │
    ├─ [部分一致削除: sDelete]
    │      └─ DELETE FROM tblMonitor WHERE sDetail LIKE '%...%'
    │
    └─ [一覧表示]
           ├─ db.execute()（SELECT * FROM tblMonitor）
           │
           └─ 統計情報計算
                  └─ JavaScript出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

turn=off ────────▶ UPDATE bMonitor=FALSE ───▶ 画面リダイレクト
turn=on  ────────▶ UPDATE bMonitor=TRUE  ───▶ 画面リダイレクト
turn=remove ─────▶ DELETE全件 ──────────────▶ 画面リダイレクト

sDelete ─────────▶ DELETE LIKE検索 ─────────▶ 画面リダイレクト

show5000 ────────▶ 表示件数変更 ────────────▶ 一覧テーブル
                                              + 統計情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_monitor.asp | `asp/ad_monitor.asp` | ソース | メイン画面ファイル |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理・共通関数 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| ad_back.asp | `asp/ad_back.asp` | テンプレート | 管理者画面戻るリンク |
