# 画面設計書 145-ラベル一覧

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けラベル一覧画面（ad_labels.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、QuickerSite CMSで使用される多言語ラベル（UI文言）を一覧表示・管理するために設計されている。CMSは多言語対応しており、ボタンラベルやメッセージなどのUI文言を各言語ごとに管理する必要がある。システム管理者は本画面を通じて、登録済みのすべてのラベルとその各言語での翻訳を確認し、新規ラベルの追加や既存ラベルの編集画面へのアクセスが可能である。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. 登録済みラベルの一覧表示（ラベルコードと各言語の翻訳値）
2. 新規ラベル作成画面（ad_label.asp）へのリンク
3. 既存ラベルの編集画面へのリンク
4. ソート可能なテーブル形式で表示

**画面遷移**：管理者ダッシュボード（ad_default.asp）から本画面に遷移する。ラベル編集リンクをクリックするとad_label.aspに遷移する。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 120 | 多言語対応 | 主機能 | 多言語ラベルの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

```
asp/ad_labels.asp
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| - | - | - | - | 入力パラメータなし |

## 表示項目

### 一覧表示

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ID | 数値 | ラベルID |
| Code | 文字列 | ラベルコード（識別子） |
| {言語名} | 文字列 | 各言語での翻訳値（動的に列が生成される） |
| 編集リンク | リンク | ラベル編集画面へのリンク |

## イベント仕様

### 1-新規ラベル作成リンク

「新規ラベル」リンクをクリックすると、ラベル編集画面（ad_label.asp）に遷移する。

**処理フロー**：
1. ad_label.aspにパラメータなしで遷移
2. 新規作成モードでラベル編集画面が表示される

### 2-ラベル編集リンク

「修正」リンクをクリックすると、該当ラベルの編集画面に遷移する。

**処理フロー**：
1. ad_label.asp?iId={ラベルID}に遷移
2. 編集モードでラベル編集画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | tblLabel, tblLabelValue, tblLanguage | SELECT | ラベルと翻訳値の取得 |

### テーブル別更新項目詳細

#### tblLabel（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | ラベルID | 主キー |
| SELECT | sCode | ラベルコード | 識別子 |

#### tblLabelValue（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iLabelId | ラベルID | 外部キー |
| SELECT | iLanguageId | 言語ID | 外部キー |
| SELECT | sValue | 翻訳値 | 各言語の翻訳 |

#### tblLanguage（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | 言語ID | 主キー |
| SELECT | sLanguage | 言語名 | 列ヘッダー表示用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | {n} labels | ラベル件数の表示 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| ラベルが0件 | 一覧テーブルを表示しない |

## 備考

- テーブルにはsortableクラスが適用され、JavaScriptによるソートが可能
- 言語の列は動的に生成され、登録されている言語の数に応じて変化する
- ラベルIDはアンカー（name属性）として使用され、直接リンクが可能
- ラベルデータは専用のラベルデータベース（db.executeLabels）から取得される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.asp | `asp/includes/label.asp` | cls_labelクラスの構造、ラベルと翻訳値の関係 |
| 1-2 | labelList.asp | `asp/includes/labelList.asp` | cls_labelListクラス、ラベル一覧取得ロジック |

**読解のコツ**: ラベル（tblLabel）と翻訳値（tblLabelValue）は1対多の関係にあり、言語（tblLanguage）と組み合わせて多言語対応を実現している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_labels.asp | `asp/ad_labels.asp` | 画面のメインロジック、一覧表示処理 |

**主要処理フロー**:
1. **4-6行目**: cls_languageListNewとcls_labelListのインスタンス化
2. **9行目**: ラベル件数の確認とテーブル表示
3. **9-10行目**: ループ処理で各ラベルと各言語の翻訳値を表示

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_labels.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ cls_languageListNew.table
    │      └─ tblLanguage（SELECT）
    │
    └─ cls_labelList.table
           └─ cls_label.pick()（各ラベル）
                  ├─ tblLabel（SELECT）
                  └─ tblLabelValue（SELECT）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(なし) ───────────▶ 言語リスト取得 ───▶ 動的列ヘッダー
                          │
                          ▼
                   ラベルリスト取得
                          │
                          ▼
                   ループ処理（各ラベル）
                          │
                          ▼
                   各言語の翻訳値取得 ───▶ 一覧テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_labels.asp | `asp/ad_labels.asp` | ソース | メイン画面ファイル |
| ad_label.asp | `asp/ad_label.asp` | ソース | ラベル編集画面 |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| label.asp | `asp/includes/label.asp` | ソース | ラベルクラス |
| labelList.asp | `asp/includes/labelList.asp` | ソース | ラベルリストクラス |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| commonheader.asp | `asp/includes/commonheader.asp` | テンプレート | 共通ヘッダー |
| ad_back.asp | `asp/ad_back.asp` | テンプレート | 管理者画面戻るリンク |
