# 画面設計書 146-ラベル編集

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けラベル編集画面（ad_label.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、QuickerSite CMSで使用される多言語ラベル（UI文言）を新規作成・編集・削除するために設計されている。CMSは多言語対応しており、ボタンラベルやメッセージなどのUI文言を各言語ごとに管理する必要がある。システム管理者は本画面を通じて、ラベルコードを定義し、各言語での翻訳値を設定することができる。また、「Copy to all」機能により、1つの言語で入力した値を他のすべての言語にコピーすることも可能である。

**画面へのアクセス方法**：システム管理者としてログイン後、ラベル一覧画面（ad_labels.asp）から「新規ラベル」リンクまたは「修正」リンクをクリックしてアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. 新規ラベルの作成（ラベルコードと各言語の翻訳値を登録）
2. 既存ラベルの編集（翻訳値の変更）
3. ラベルの削除（確認ダイアログ付き）
4. Copy to all機能（最初の言語の値を全言語にコピー）

**画面遷移**：ラベル一覧画面（ad_labels.asp）から本画面に遷移する。保存成功後は同画面にリダイレクト、削除後はラベル一覧画面にリダイレクトされる。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 120 | 多言語対応 | 主機能 | 多言語ラベルの編集 |

## 画面種別

登録 / 編集

## URL/ルーティング

```
asp/ad_label.asp
asp/ad_label.asp?iId={ラベルID}
asp/ad_label.asp?iId={ラベルID}&fbMessage=fb_saveOK
asp/ad_label.asp?btnaction={アクション}&iId={ラベルID}
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| iId | 数値 | 入力/出力 | 任意 | ラベルID（編集時） |
| sCode | 文字列 | 入力 | 必須 | ラベルコード |
| lk_{言語ID} | 文字列 | 入力 | 必須 | 各言語の翻訳値 |
| btnaction | 文字列 | 入力 | 必須 | 操作種別（保存/削除） |

## 表示項目

### 入力フォーム

| 項目名 | データ型 | 説明 | 入力制御 |
|--------|----------|------|----------|
| ラベルコード | 文字列 | ラベルの識別子（新規作成時のみ編集可） | テキストボックス |
| {言語名}翻訳値 | 文字列 | 各言語での翻訳テキスト | テキストエリア（cols=90, rows=2） |

## イベント仕様

### 1-保存ボタン押下

ラベル情報を保存する。

**処理フロー**：
1. CSRFトークン検証（checkCSRF()）
2. リクエストからラベルコードと翻訳値を取得
3. cls_label.save()でデータベースに保存
4. 全言語のラベルキャッシュを更新（labellist.refresh）
5. 同画面にfbMessage=fb_saveOK付きでリダイレクト

### 2-削除リンク押下

ラベルを削除する。確認ダイアログが表示される。

**処理フロー**：
1. JavaScript confirmによる確認ダイアログ
2. CSRFトークン検証（checkCSRF()）
3. cls_label.remove()でデータベースから削除
4. ラベル一覧画面（ad_labels.asp）にリダイレクト

### 3-Copy to all リンク押下

最初の言語の翻訳値を他のすべての言語にコピーする。

**処理フロー**：
1. JavaScriptのcopyToAll関数が呼び出される
2. 最初の言語のテキストエリアの値を取得
3. 他のすべての言語のテキストエリアに値をコピー

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblLabel, tblLabelValue, tblLanguage | SELECT | ラベルと翻訳値の取得 |
| 保存 | tblLabel | INSERT/UPDATE | ラベル情報の保存 |
| 保存 | tblLabelValue | DELETE, INSERT | 翻訳値の再作成 |
| 削除 | tblLabel, tblLabelValue | DELETE | ラベルと翻訳値の削除 |

### テーブル別更新項目詳細

#### tblLabel

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sCode | ユーザー入力値（小文字、スペース除去） | 識別子 |
| DELETE | iId | 指定されたラベルID | 削除条件 |

#### tblLabelValue

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | iLabelId | ラベルID | 保存時に既存値を削除 |
| INSERT | iLabelId | ラベルID | 外部キー |
| INSERT | iLanguageId | 言語ID | 外部キー |
| INSERT | sValue | ユーザー入力の翻訳値 | 翻訳テキスト |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | fb_saveOK | 保存成功時 |
| 確認 | areyousure | 削除確認時 |
| エラー | err_mandatory | 必須項目未入力時 |
| エラー | err_labelCode | ラベルコード重複時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| ラベルコード未入力 | err_mandatoryエラーを表示 |
| 翻訳値未入力 | err_mandatoryエラーを表示 |
| ラベルコード重複 | err_labelCodeエラーを表示 |

## 備考

- ラベルコードは自動的に小文字に変換され、スペースは削除される
- 保存時は既存の翻訳値をすべて削除してから再作成される（DELETE-INSERT方式）
- 保存後はApplicationキャッシュが更新される（labellist.refresh）
- 新規作成時はラベルコードの入力が可能、編集時はラベルコードは読み取り専用
- CSRFトークンによる保護が実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.asp | `asp/includes/label.asp` | cls_labelクラスの構造、save/remove メソッド |
| 1-2 | labelList.asp | `asp/includes/labelList.asp` | refreshメソッドによるキャッシュ更新 |

**読解のコツ**: cls_label.saveメソッドはDELETE-INSERT方式で翻訳値を再作成する。valuesプロパティはDictionaryオブジェクトで言語IDをキーとして翻訳値を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_label.asp | `asp/ad_label.asp` | 画面のメインロジック、保存/削除処理 |

**主要処理フロー**:
1. **10-11行目**: cls_labelのインスタンス化とpick
2. **13-20行目**: 保存処理（btnaction=save）
3. **23-26行目**: 削除処理（btnaction=delete）
4. **27-31行目**: フォーム表示と入力フィールド生成

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_label.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ cls_label.pick()（編集時）
    │      ├─ tblLabel（SELECT）
    │      └─ tblLabelValue（SELECT）
    │
    ├─ [保存処理]
    │      ├─ checkCSRF()
    │      ├─ cls_label.getRequestValues()
    │      ├─ cls_label.save()
    │      │      ├─ cls_label.check()（バリデーション）
    │      │      ├─ tblLabel（INSERT/UPDATE）
    │      │      ├─ tblLabelValue（DELETE）
    │      │      └─ tblLabelValue（INSERT）
    │      │
    │      └─ labellist.refresh()（各言語）
    │
    └─ [削除処理]
           ├─ checkCSRF()
           └─ cls_label.remove()
                  ├─ tblLabelValue（DELETE）
                  └─ tblLabel（DELETE）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

sCode ───────────▶ 小文字変換・スペース除去 ─▶ tblLabel.sCode
lk_{言語ID} ─────▶ cls_label.values ────────▶ tblLabelValue.sValue

                   ┌─ check()バリデーション
btnaction=save ───▶│  ・必須チェック
                   │  ・重複チェック
                   └─ save()
                          │
                          ▼
                   refresh()キャッシュ更新 ───▶ リダイレクト

btnaction=delete ─▶ remove() ─────────────────▶ ラベル一覧へ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_label.asp | `asp/ad_label.asp` | ソース | メイン画面ファイル |
| ad_labels.asp | `asp/ad_labels.asp` | ソース | ラベル一覧画面（遷移先） |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| label.asp | `asp/includes/label.asp` | ソース | ラベルクラス |
| labelList.asp | `asp/includes/labelList.asp` | ソース | ラベルリストクラス |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理・CSRF関連 |
| commonheader.asp | `asp/includes/commonheader.asp` | テンプレート | 共通ヘッダー |
