# 画面設計書 147-IIS管理

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けIIS管理画面（ad_iis.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、Windows Server上のIIS（Internet Information Services）に登録されているWebサイト情報を一覧表示・管理するために設計されている。QuickerSiteはマルチテナント型CMSであり、複数の顧客サイトが同一サーバー上でホストされている。システム管理者は本画面を通じて、IISに登録されているすべてのサイト情報（バインディング、パス、状態など）を確認し、必要に応じてIIS情報のリロードやドメインバインディングの編集が可能である。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. IISに登録されているサイト情報の一覧表示
2. サイト情報の検索（バインディング、パス、コメント等で検索）
3. IIS情報のリロード（最新情報に更新）
4. 各サイトのドメインバインディング編集画面へのリンク
5. 全バインディングの一覧表示（テキストエリア）

**画面遷移**：管理者ダッシュボード（ad_default.asp）から本画面に遷移する。「Modify Bindings」リンクをクリックするとバインディング編集画面（ad_editbindings.asp）に遷移する。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | IISサーバー設定の管理 |

## 画面種別

一覧 / 検索

## URL/ルーティング

```
asp/ad_iis.asp
asp/ad_iis.asp?reload=1
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| sValue | 文字列 | 入力 | 任意 | 検索文字列（最大150文字） |
| reload | 数値 | 入力 | 任意 | IISリロードフラグ |

## 表示項目

### 一覧表示

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Comments | 文字列 | サイトコメント（サイト名） |
| Path | 文字列 | サイトのパス |
| State | 文字列 | サイトの状態（Started/Stopped等） |
| QS Path | 文字列 | QuickerSiteパス |
| QS Dir | 文字列 | 仮想ディレクトリ |
| Bindings | リスト | ドメインバインディング一覧（リンク付き） |

### 統計情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| サイト数 | 数値 | 表示されているサイトの総数 |
| バインディング数 | 数値 | 表示されているバインディングの総数 |

## イベント仕様

### 1-Reload IIS ボタン押下

IIS情報をリロードし、最新の状態に更新する。

**処理フロー**：
1. JavaScript confirmによる確認ダイアログ
2. reload=1パラメータで画面にアクセス
3. loadIIS()関数を実行してIISから最新情報を取得
4. sitesテーブルを更新
5. 画面をリダイレクト

### 2-Search ボタン押下

入力された文字列でサイト情報を検索する。

**処理フロー**：
1. フォームをPOST送信
2. sValueの値でLIKE検索を実行
3. 一致するサイトのみを一覧表示

### 3-Modify Bindings リンク押下

該当サイトのドメインバインディング編集画面に遷移する。

**処理フロー**：
1. ad_editbindings.asp?name={サイト名}に遷移
2. バインディング編集画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | sites（iis.resx） | SELECT | サイト情報の取得 |
| IISリロード | sites（iis.resx） | DELETE, INSERT | IISからの再取得 |

### テーブル別更新項目詳細

#### sites（iis.rexsローカルデータベース）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | name | サイト名 | IISサイト識別子 |
| SELECT | servercomment | サイトコメント | 表示用 |
| SELECT | serverbindings | バインディング一覧 | ":80:"区切り |
| SELECT | path | サイトパス | ルートパス |
| SELECT | ServerState | サイト状態 | Started/Stopped等 |
| SELECT | QSPath | QuickerSiteパス | CMS関連パス |
| SELECT | QSVD | 仮想ディレクトリ | VD名 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 確認 | Are you sure to reload IIS? This can take a while. | IISリロード時 |
| 表示 | Please wait... | 初期表示時（JavaScriptで置換） |
| 情報 | {n} sites / {n} bindings | 統計情報表示 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| IIS接続エラー | 処理をスキップ（on error resume next） |

## 備考

- IIS情報はローカルのAccessデータベース（iis.resx）にキャッシュされる
- バインディングは":80:"で区切られた形式で格納されている
- 検索はバインディング、パス、コメント、QSVD、状態、QSPathを対象とする
- 全バインディングはDictionaryオブジェクトで重複を排除してテキストエリアに表示
- サイト名順（servercomment asc）でソートされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | includes.asp | `asp/iismanager/includes.asp` | IIS接続とデータ取得の仕組み |

**読解のコツ**: loadIIS()関数がIISからサイト情報を取得してローカルデータベースに保存する。GetObject("IIS://localhost/w3svc/")でIISにアクセスする。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_iis.asp | `asp/ad_iis.asp` | 画面のメインロジック、検索・表示処理 |

**主要処理フロー**:
1. **5-18行目**: SQL構築（検索条件追加）
2. **20-22行目**: IISリロード処理
3. **24-42行目**: サイト一覧のループ表示
4. **40-42行目**: 統計情報のJavaScript出力

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_iis.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ iismanager/includes.asp
    │      ├─ getConn()（Accessデータベース接続）
    │      └─ loadIIS()（IISリロード時）
    │             ├─ GetObject("IIS://LOCALHOST/W3SVC")
    │             ├─ sites（DELETE）
    │             └─ sites（INSERT）
    │
    └─ [一覧表示]
           ├─ getConn.execute()（SELECT）
           └─ バインディング分解・表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

reload=1 ───────▶ loadIIS() ───────────────▶ sites更新
                        │                        │
                        ▼                        ▼
                  IIS ───▶ sitesテーブル ───▶ 画面リダイレクト

sValue ─────────▶ SQL LIKE検索 ────────────▶ 一覧テーブル
                        │
                        ▼
                  バインディング分解
                        │
                        ▼
                  Dictionary重複排除 ───────▶ 全バインディング
                                              テキストエリア
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_iis.asp | `asp/ad_iis.asp` | ソース | メイン画面ファイル |
| ad_editbindings.asp | `asp/ad_editbindings.asp` | ソース | バインディング編集画面 |
| includes.asp | `asp/iismanager/includes.asp` | ソース | IIS接続・データ取得関数 |
| iis.resx | `asp/iismanager/iis.resx` | データベース | IIS情報キャッシュ |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
