# 画面設計書 148-バインディング編集

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けバインディング編集画面（ad_editbindings.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、IIS（Internet Information Services）に登録されているWebサイトのドメインバインディング（ホスト名）を編集するために設計されている。QuickerSiteはマルチテナント型CMSであり、1つのIISサイトに複数のドメインをバインドすることで、同一サイトを複数のドメインでアクセス可能にする。システム管理者は本画面を通じて、サイトにバインドされているドメイン一覧を編集し、ドメインの追加・削除を行うことができる。

**画面へのアクセス方法**：システム管理者としてログイン後、IIS管理画面（ad_iis.asp）から「Modify Bindings」リンクをクリックしてアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. 現在のドメインバインディング一覧を表示
2. テキストエリアでバインディングの編集（改行区切り）
3. 保存ボタンでIISに反映

**画面遷移**：IIS管理画面（ad_iis.asp）から本画面に遷移する。保存成功後は同画面にfbMessage=fb_saveOK付きでリダイレクトされる。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | ドメインバインディングの編集 |

## 画面種別

編集

## URL/ルーティング

```
asp/ad_editbindings.asp?name={IISサイト名}
asp/ad_editbindings.asp?name={IISサイト名}&fbMessage=fb_saveOK
asp/ad_editbindings.asp?name={IISサイト名}&strMessage=err_mandatory
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| name | 文字列 | 入力 | 必須 | IISサイト名 |
| bindings | 文字列 | 入力 | 必須 | ドメイン一覧（改行区切り） |
| btnSaveIISB | 文字列 | 入力 | - | 保存ボタン識別子 |

## 表示項目

### 編集フォーム

| 項目名 | データ型 | 説明 | 入力制御 |
|--------|----------|------|----------|
| サイト名 | 文字列 | 編集対象のIISサイト名 | 読み取り専用 |
| バインディング一覧 | 文字列 | ドメイン一覧（改行区切り） | テキストエリア（cols=90, rows=15） |

## イベント仕様

### 1-Save ボタン押下

バインディング設定をIISに保存する。

**処理フロー**：
1. テキストエリアから改行区切りでドメイン一覧を取得
2. Dictionaryオブジェクトで重複を排除
3. 各ドメインを小文字に変換、"http://"を除去
4. ServerBindings配列を構築（":80:"プレフィックス付き）
5. IISオブジェクトのServerBindingsプロパティを更新
6. SetInfo()でIISに反映
7. sitesテーブルのServerBindingsカラムを更新
8. 同画面にfbMessage=fb_saveOK付きでリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | IISから直接取得 |
| 保存 | sites（iis.resx） | UPDATE | バインディング情報の更新 |

### テーブル別更新項目詳細

#### sites（iis.resxローカルデータベース）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | ServerBindings | 新しいバインディング一覧 | ":80:"区切り |

### IISオブジェクト更新

| 操作 | プロパティ | 更新値 | 備考 |
|-----|----------|--------|------|
| UPDATE | ServerBindings | 配列形式のバインディング | ":80:{ドメイン}"形式 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | fb_saveOK | 保存成功時 |
| エラー | err_mandatory | バインディングが空の場合 |
| 警告 | ENTER-Separated list of domains - DO NOT INCLUDE "http://" | 入力ガイダンス |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| IISオブジェクト取得失敗 | response.endで処理終了 |
| サイト名が空 | response.endで処理終了 |
| バインディングが空 | err_mandatoryエラーでリダイレクト |

## 備考

- バインディングは改行（vbcrlf）区切りで入力する
- "http://"は自動的に除去される
- ドメインは自動的に小文字に変換される
- 重複したドメインは自動的に排除される
- ポート番号は80番固定（":80:"プレフィックス）
- on error resume nextでエラーを抑制しているため、IIS接続エラー時は画面終了
- IIS ADSIを使用してサーバーバインディングを直接操作

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | includes.asp | `asp/iismanager/includes.asp` | IIS接続とADSIの基本 |

**読解のコツ**: IISオブジェクトはADSI（Active Directory Service Interfaces）経由でアクセスする。ServerBindingsプロパティは配列形式で":80:{ドメイン}"という形式で格納される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_editbindings.asp | `asp/ad_editbindings.asp` | 画面のメインロジック、保存処理 |

**主要処理フロー**:
1. **6行目**: GetObjectでIISサイトオブジェクト取得
2. **7-8行目**: オブジェクト取得失敗時のエラーハンドリング
3. **9-45行目**: 保存処理（btnSaveIISB="Save"の場合）
4. **12-19行目**: Dictionary で重複排除・正規化
5. **24-29行目**: ServerBindings配列の構築
6. **30-31行目**: IISへの反映（SetInfo）
7. **37-43行目**: sitesテーブルの更新
8. **47-49行目**: 現在のバインディング表示

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_editbindings.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ iismanager/includes.asp
    │      └─ GetDynamicRS()（DB接続）
    │
    ├─ GetObject("IIS://localhost/w3svc/{name}")
    │      └─ IISサイトオブジェクト取得
    │
    └─ [保存処理]
           ├─ 入力値パース（改行分割）
           ├─ Dictionary重複排除
           ├─ 正規化（小文字、http://除去）
           ├─ ServerBindings配列構築
           ├─ webobj.ServerBindings = newSBS
           ├─ webobj.SetInfo()（IIS反映）
           └─ sites（UPDATE）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bindings ───────▶ 改行分割 ───────────────▶ 配列
(テキストエリア)         │
                        ▼
                  Dictionary重複排除
                        │
                        ▼
                  正規化（小文字、http://除去）
                        │
                        ▼
                  ":80:"プレフィックス付加
                        │
                        ▼
                  IIS SetInfo() ───────────▶ IIS更新完了
                        │
                        ▼
                  sites UPDATE ────────────▶ ローカルDB更新
                        │
                        ▼
                  リダイレクト（fb_saveOK）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_editbindings.asp | `asp/ad_editbindings.asp` | ソース | メイン画面ファイル |
| ad_iis.asp | `asp/ad_iis.asp` | ソース | IIS管理画面（遷移元） |
| includes.asp | `asp/iismanager/includes.asp` | ソース | IIS接続・データ取得関数 |
| iis.resx | `asp/iismanager/iis.resx` | データベース | IIS情報キャッシュ |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
