# 画面設計書 149-サイトコピー

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けサイトコピー画面（ad_copysite.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、既存のサイトを複製して新しいサイトを作成するために設計されている。QuickerSiteはマルチテナント型CMSであり、複数の顧客サイトを管理している。新規サイト作成時に、既存サイトをテンプレートとして利用することで、サイト構築の効率化を図ることができる。サイトコピーでは、ページ構造、テンプレート、フォーム、カタログ、ギャラリーなどの設定が複製される。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からサイト一覧でコピー元サイトを選択してアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. コピー元サイトの情報を表示
2. 新規サイトの基本情報を入力
3. コピー実行でサイト全体を複製

**画面遷移**：管理者ダッシュボード（ad_default.asp）のサイト詳細からコピーボタンで本画面に遷移する。コピー成功後は管理者ダッシュボードにリダイレクトされる。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | ページ複製 | 主機能 | サイト全体のコピー |

## 画面種別

登録

## URL/ルーティング

```
asp/ad_copysite.asp?siteToBeCopiedID={コピー元サイトID}
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| siteToBeCopiedID | 数値 | 入力 | 必須 | コピー元サイトID |
| siteName | 文字列 | 入力 | 必須 | 新規サイト名（組織名） |
| sUrl | 文字列 | 入力 | 必須 | 新規サイトURL |
| sAlternateDomains | 文字列 | 入力 | 任意 | 代替ドメイン（改行区切り） |
| siteTitle | 文字列 | 入力 | 任意 | サイトタイトル |
| copyRight | 文字列 | 入力 | 任意 | 著作権表示 |
| keywords | 文字列 | 入力 | 任意 | メタキーワード |
| sDescription | 文字列 | 入力 | 任意 | メタ説明 |
| defaultTemplate | 暗号化数値 | 入力 | 任意 | デフォルトテンプレートID |
| sDatumFormat | 文字列 | 入力 | 任意 | 日付フォーマット |
| language | 数値 | 入力 | 任意 | 言語ID |
| webmaster | 文字列 | 入力 | 任意 | ウェブマスター名 |
| webmasterEmail | 文字列 | 入力 | 任意 | ウェブマスターメール |
| dOnlineFrom | 日付 | 入力 | 任意 | 公開開始日 |
| bEnableMainRSS | ブール | 入力 | 任意 | メインRSS有効 |
| bApplication | ブール | 入力 | 任意 | アプリケーション許可 |
| bUserFriendlyURL | ブール | 入力 | 任意 | SEO URL有効 |
| bAllowStorageOutsideWWW | ブール | 入力 | 任意 | WWW外ストレージ許可 |
| bScanReferer | ブール | 入力 | 任意 | リファラースキャン |
| googleAnalytics | 文字列 | 入力 | 任意 | Google Analytics ID |

## 表示項目

### 入力フォーム

| 項目名 | データ型 | 説明 | 入力制御 |
|--------|----------|------|----------|
| 組織名 | 文字列 | サイト名 | テキスト（max254） |
| URL | 文字列 | サイトURL | テキスト（max254） |
| デフォルトテンプレート | 選択 | テンプレート選択 | ドロップダウン |
| 代替ドメイン | 文字列 | 改行区切りドメイン一覧 | テキストエリア |
| サイトタイトル | 文字列 | タイトル | テキスト（max254） |
| 著作権 | 文字列 | METAタグcopyright | テキスト（max254） |
| キーワード | 文字列 | METAタグkeywords | テキスト（max2048） |
| 説明 | 文字列 | METAタグdescription | テキストエリア |
| 日付フォーマット | 選択 | 日付表示形式 | ドロップダウン |
| 言語 | 選択 | サイト言語 | ドロップダウン |
| ウェブマスター名 | 文字列 | METAタグauthor | テキスト（max255） |
| ウェブマスターメール | 文字列 | 連絡先メール | テキスト（max254） |
| 公開開始日 | 日付 | サイト公開日 | 日付ピッカー |

## イベント仕様

### 1-コピーボタン押下

サイトのコピーを実行する。

**処理フロー**：
1. CSRFトークン検証（checkCSRF()）
2. フォームから入力値を取得
3. cls_customer.check()でバリデーション
4. cls_customer.copy()でサイトをコピー
5. ページ構造、テンプレート、カタログ、フォーム等を複製
6. 管理者ダッシュボードにnewAccount=True付きでリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblCustomer | SELECT | コピー元サイト情報取得 |
| コピー実行 | tblCustomer | INSERT | 新規サイト作成 |
| コピー実行 | tblPage | INSERT | ページ構造複製 |
| コピー実行 | tblTemplate | INSERT | テンプレート複製 |
| コピー実行 | tblCatalog | INSERT | カタログ複製 |
| コピー実行 | tblForm | INSERT | フォーム複製 |
| コピー実行 | tblFeed, tblGallery, etc. | INSERT | 各種設定複製 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sName | 入力値 | サイト名 |
| INSERT | sUrl | 入力値 | URL |
| INSERT | sAlternateDomains | 入力値 | 代替ドメイン |
| INSERT | siteTitle | 入力値 | タイトル |
| INSERT | adminPassword | sha256(QS_defaultPW) | デフォルトパスワード |
| INSERT | dOnlineFrom | 入力値またはnow() | 公開開始日 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | (*) mandatory | 必須項目説明 |
| エラー | err_mandatory | 必須項目未入力時 |
| エラー | err_url | URL形式不正時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| サイト名未入力 | err_mandatoryエラー |
| URL形式不正 | err_urlエラー |

## 備考

- コピー時に新しいサイトのadminPasswordはデフォルトパスワードにリセットされる
- 公開開始日（dOnlineFrom）はnow()にリセットされる
- コピー元サイトのsName、sUrl、sAlternateDomainsは空にクリアされる
- IISサイトも自動的に作成される（doSaveIIS=true）
- デフォルトテンプレートも自動的にコピーされる
- ページ構造は親子関係を維持してコピーされる
- メールアドレス（ゲストブック、フォーム）は新サイトのwebmasterEmailに更新される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのcopy()メソッド |

**読解のコツ**: copy()メソッドは非常に長く複雑。ページ、テンプレート、カタログ、フォームなど複数のオブジェクトを順次コピーしていく。IDの対応表（Dictionary）を使って親子関係を維持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_copysite.asp | `asp/ad_copysite.asp` | 画面のメインロジック、入力処理 |

**主要処理フロー**:
1. **5-12行目**: cls_customerのインスタンス化と初期化
2. **13-39行目**: フォーム入力値の取得と設定
3. **35-38行目**: check()とcopy()の実行
4. **40-44行目**: フォーム表示

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_copysite.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    ├─ cls_customer.pick()（コピー元取得）
    │      └─ tblCustomer（SELECT）
    │
    └─ [コピー処理]
           ├─ checkCSRF()
           ├─ cls_customer.check()（バリデーション）
           └─ cls_customer.copy()
                  ├─ save()（新規サイト作成）
                  │      └─ tblCustomer（INSERT）
                  │
                  ├─ defaultTemplateObj.copyToCustomerID()
                  │      └─ tblTemplate（INSERT）
                  │
                  ├─ [ページコピーループ]
                  │      └─ tblPage（INSERT）
                  │
                  ├─ copyTable()（各テーブル）
                  │      ├─ tblConstant
                  │      ├─ tblContactField
                  │      ├─ tblGallery
                  │      ├─ tblFeed
                  │      ├─ tblGuestbook
                  │      ├─ tblPoll
                  │      └─ tblPopup
                  │
                  └─ [カタログ・フォームコピー]
                         ├─ catalogs.copyToCustomer()
                         └─ forms.copyToCustomer()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

siteToBeCopiedID ──▶ cls_customer.pick() ───▶ コピー元情報取得
                          │
                          ▼
フォーム入力 ──────▶ check()バリデーション
                          │
                          ▼
                   copy()
                          │
                          ├─ save()（新規Customer）
                          │
                          ├─ defaultTemplate.copy()
                          │
                          ├─ pages.copy()（親子関係維持）
                          │
                          ├─ copyTable()（各設定）
                          │
                          └─ catalogs/forms.copy()
                                  │
                                  ▼
                          ad_default.asp?newAccount=True
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_copysite.asp | `asp/ad_copysite.asp` | ソース | メイン画面ファイル |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（copy()メソッド） |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理・CSRF関連 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
