# 画面設計書 15-ページ削除確認

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「ページ削除確認」機能の設計仕様を定義するものである。

### 本画面の処理概要

ページ削除確認は、独立した画面ではなく、各ページ編集画面（bs_editItem.asp、bs_editExternalURL.asp、bs_editContainer.asp等）に組み込まれた削除機能である。削除ボタン押下時にJavaScript確認ダイアログを表示し、ユーザーの確認後にページの論理削除を実行する。

**業務上の目的・背景**：
CMSにおいてページの削除は取り消しが困難な操作である。誤操作によるコンテンツ消失を防ぐため、削除前にユーザーに確認を求めることが重要である。本機能は、削除操作の安全性を確保しつつ、サイト管理者の業務効率を維持する。

**画面へのアクセス方法**：
1. バックサイトにログイン後、削除対象のページ編集画面を開く
2. 編集画面内の削除ボタン（dustbin.gifアイコンまたはテキストボタン）をクリック
3. JavaScript確認ダイアログが表示される

**主要な操作・処理内容**：
1. 削除ボタン/アイコンをクリック
2. JavaScript confirm()による確認ダイアログ表示
3. 「OK」クリックで削除処理実行、「キャンセル」で処理中止
4. 削除実行後、バックサイトホームまたはリストページにリダイレクト

**画面遷移**：
- 遷移元: 各ページ編集画面（bs_editItem.asp、bs_editExternalURL.asp、bs_editContainer.asp等）
- 遷移先（削除実行後）: バックサイトホーム（bs_default.asp）、イントラネット管理（bs_intranet.asp）、リストページ（bs_listPage.asp）

**権限による表示制御**：
page.canBeDeleted プロパティがtrueの場合のみ削除ボタンが表示される。これにより、削除不可のページ（ホームページなど）では削除ボタンが非表示になる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | ページ削除 | 主機能 | ページ削除前の確認処理 |

## 画面種別

確認ダイアログ（各編集画面に組み込み）

## URL/ルーティング

削除機能は各編集画面のフォームからPOST送信で実行される。

```
asp/bs_editItem.asp?iId={暗号化されたページID}
asp/bs_editExternalURL.asp?iId={暗号化されたページID}
asp/bs_editContainer.asp?iId={暗号化されたページID}
等の編集画面
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| iId | 入力（hidden） | String | Yes | 暗号化されたページID |
| btnaction | 入力（hidden） | String | Yes | アクション種別（delete） |
| QS_secCodeHidden | 入力（hidden） | String | Yes | CSRF対策トークン |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| 削除ボタン | ボタン/アイコン | bs_deleteButton.aspによる表示 |
| 削除アイコン | 画像リンク | bs_delete.aspによる表示（dustbin.gif） |
| 確認ダイアログ | JavaScript alert | confirm()による確認表示 |

## イベント仕様

### 1-削除ボタン/アイコンクリック

1. JavaScript deletePage()関数が呼び出される
2. confirm()で確認ダイアログを表示
3. メッセージ: l("deletecomplete")（「削除してよろしいですか？」相当）
4. キャンセル時：処理を中止し、編集画面に留まる

### 2-確認ダイアログでOK選択

1. フォームのbtnactionを l("delete") に設定
2. フォームをsubmit()で送信
3. bs_processPage.aspで削除処理が実行される

### 3-削除処理実行（bs_processPage.asp）

1. checkCSRF()でCSRFトークン検証
2. page.bDeleted = true を設定
3. page.parentPage.removeRang(page) で親ページの並び順を再計算
4. page.iRang = 0 を設定
5. page.bOnline = false を設定
6. page.bHomepage = false を設定
7. page.deleteListItems() でリストアイテムも削除
8. page.save() で保存
9. リダイレクト処理:
   - リストアイテムの場合: bs_listPage.aspへリダイレクト
   - イントラネットページの場合: bs_intranet.aspへリダイレクト
   - それ以外: bs_default.aspへリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除実行 | tblPage | UPDATE | 論理削除（bDeleted=true） |
| 削除実行 | tblPage | UPDATE | リストアイテムの論理削除 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bDeleted | true | 論理削除フラグ |
| UPDATE | iRang | 0 | 並び順をリセット |
| UPDATE | bOnline | false | 非公開に設定 |
| UPDATE | bHomepage | false | ホームページフラグをリセット |
| UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| deletecomplete | 確認 | 削除ボタン押下時 | 削除してよろしいですか？ |
| fb_topicremoved | 成功 | リストアイテム削除後 | トピックが削除されました |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 削除不可ページ | canBeDeletedがfalseの場合、削除ボタン自体が非表示 |
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| CSRFトークン不正 | checkCSRF()でエラー処理 |

## 備考

- 物理削除ではなく論理削除（bDeleted=true）を採用
- 削除されたページはバックサイトのツリー表示から除外される
- 親ページの並び順（iRang）は削除時に自動で再計算される
- リストアイテムの場合、親リストページの子アイテムも連動して削除される
- ホームページに設定されているページは削除不可（canBeDeleted=false）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 削除ボタン表示を理解する

削除ボタンがどのように表示されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_delete.asp | `asp/bs_delete.asp` | アイコン表示版の削除リンク |
| 1-2 | bs_deleteButton.asp | `asp/bs_deleteButton.asp` | ボタン版の削除UI |

**読解のコツ**: page.canBeDeletedプロパティでボタン表示を制御している点に注意。

#### Step 2: JavaScript処理を理解する

削除確認ダイアログの仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_processPage.asp | `asp/bs_processPage.asp` | deletePage()関数定義（行2-7） |

**主要処理フロー**:
1. **行2-7**: deletePage()関数がconfirm()を呼び出し
2. **行4-5**: btnaction.valueを設定してフォーム送信

#### Step 3: サーバー側削除処理を理解する

実際の削除処理の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_processPage.asp | `asp/bs_processPage.asp` | 削除処理（行26-44） |

**主要処理フロー**:
1. **行26-27**: l("delete")ケースで削除処理開始
2. **行28-33**: 削除関連フラグの設定
3. **行34-44**: 保存とリダイレクト

#### Step 4: canBeDeletedロジックを理解する

削除可否判定の仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | page.asp | `asp/includes/page.asp` | canBeDeletedプロパティの定義 |

### プログラム呼び出し階層図

```
[各編集画面] bs_editItem.asp / bs_editExternalURL.asp / bs_editContainer.asp
    │
    ├─ bs_delete.asp（アイコン表示）
    │      └─ page.canBeDeleted判定
    │
    ├─ bs_deleteButton.asp（ボタン表示）
    │      └─ page.canBeDeleted判定
    │
    └─ [削除ボタン押下時]
           │
           ├─ JavaScript deletePage()
           │      └─ confirm()で確認
           │
           └─ [OK時] フォームsubmit
                  │
                  └─ bs_processPage.asp
                         ├─ checkCSRF()
                         ├─ page.bDeleted = true
                         ├─ page.parentPage.removeRang()
                         ├─ page.deleteListItems()
                         ├─ page.save()
                         └─ response.redirect()
```

### データフロー図

```
[入力]                      [処理]                      [出力]

削除ボタンクリック ─────────▶ deletePage()関数 ────────▶ 確認ダイアログ
                                  │
                                  ▼
                            confirm()
                                  │
                            ┌─────┴─────┐
                            │           │
                          [OK]       [Cancel]
                            │           │
                            ▼           ▼
                      btnaction設定    処理中止
                            │
                            ▼
                      form.submit()
                            │
                            ▼
                      bs_processPage.asp
                            │
                            ├─ checkCSRF()
                            │
                            ├─ page.bDeleted = true
                            │
                            ├─ parentPage.removeRang()
                            │
                            ├─ page.deleteListItems()
                            │
                            ├─ page.save() ─────────────▶ tblPage UPDATE
                            │
                            └─ response.redirect() ─────▶ ホーム画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_delete.asp | `asp/bs_delete.asp` | インクルード | アイコン表示版削除リンク |
| bs_deleteButton.asp | `asp/bs_deleteButton.asp` | インクルード | ボタン版削除UI |
| bs_processPage.asp | `asp/bs_processPage.asp` | インクルード | 削除処理実行 |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス（canBeDeleted等） |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | 削除機能を含む編集画面 |
| bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | ソース | 削除機能を含む編集画面 |
| bs_editContainer.asp | `asp/bs_editContainer.asp` | ソース | 削除機能を含む編集画面 |
| dustbin.gif | `fixedImages/dustbin.gif` | 画像 | 削除アイコン画像 |
