# 画面設計書 150-アップグレード

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者向けアップグレード画面（ad_upgrade.asp）の設計仕様を記述する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、QuickerSite CMSのシステムアップグレードを実行するために設計されている。システム管理者は本画面を通じて、QuickerSite公式サーバーから最新のアップグレードスクリプトを取得し、システムを最新バージョンに更新することができる。アップグレード処理はリモートサーバーから取得したスクリプトを動的に実行する方式を採用している。

**画面へのアクセス方法**：システム管理者としてログイン後、管理者ダッシュボード（ad_default.asp）からアクセスする。本画面はシステム管理者専用であり、通常のバックサイト管理者はアクセスできない。

**主要な操作・処理内容**：
1. QuickerSite公式サーバーからアップグレードスクリプトを取得
2. 取得したスクリプトを動的に実行
3. システムバージョンの更新

**画面遷移**：管理者ダッシュボード（ad_default.asp）から本画面に遷移する。アップグレード処理の結果は画面上に表示される。

**権限による表示制御**：本画面はシステム管理者（Admin）のみアクセス可能であり、ad_security.aspによる認証チェックが実行される。認証されていない場合はnoaccess.htmにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | システムアップグレードの実行 |

## 画面種別

処理実行

## URL/ルーティング

```
asp/ad_upgrade.asp
```

## 入出力項目

| 項目名 | データ型 | I/O | 必須 | 説明 |
|--------|----------|-----|------|------|
| - | - | - | - | 入力パラメータなし |

## 表示項目

### 処理結果

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| アップグレード結果 | 文字列 | リモートスクリプトの実行結果 |

## イベント仕様

### 1-画面アクセス時

画面にアクセスすると自動的にアップグレード処理が実行される。

**処理フロー**：
1. MSXML2.ServerXMLHTTPオブジェクトを作成
2. QuickerSite公式サーバー（www.quickersite.com）にHTTPリクエスト送信
3. sCode=UPGRADEパラメータでアップグレードスクリプトを取得
4. 取得したレスポンステキストをtrim()で整形
5. execute()関数で動的にスクリプトを実行
6. 実行結果を画面に表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップグレード実行 | （リモートスクリプト依存） | 不定 | 取得したスクリプトの内容による |

### 注意事項

- 実際のデータベース更新処理はリモートから取得するスクリプトに依存するため、静的な分析では特定不可能
- スクリプトの内容はQuickerSite公式サーバーで管理されている

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | リモートスクリプトの実行結果による |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 未認証アクセス | noaccess.htmにリダイレクト |
| HTTP接続エラー | on error resume nextで抑制 |
| スクリプト実行エラー | on error resume nextで抑制 |

## 備考

- **セキュリティ上の注意**：本画面はリモートサーバーから取得したスクリプトを動的に実行（execute()関数）するため、セキュリティリスクが高い実装となっている
- リモートサーバーURL：http://www.quickersite.com/r/default.asp?sCode=UPGRADE
- 同期的なHTTPリクエスト（false指定）を使用
- エラーハンドリングはon error resume nextで実装されており、エラーが発生しても処理は継続する
- アップグレード処理はシリーズ化されており、ad_upgrade2.asp、ad_upgrade3.asp、ad_upgrade4.aspも存在する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ad_upgrade.asp | `asp/ad_upgrade.asp` | HTTPリクエストとスクリプト実行の仕組み |

**読解のコツ**: MSXML2.ServerXMLHTTPは同期的なHTTPリクエストを行うCOMオブジェクト。execute()はVBScriptの組み込み関数で、文字列をコードとして実行する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_upgrade.asp | `asp/ad_upgrade.asp` | 画面のメインロジック |

**主要処理フロー**:
1. **4行目**: on error resume nextでエラー抑制
2. **5-6行目**: MSXML2.ServerXMLHTTPオブジェクト作成
3. **7行目**: QuickerSite公式サーバーにHTTPリクエスト
4. **8行目**: 同期的に送信
5. **9行目**: レスポンステキストをexecute()で実行
6. **10行目**: オブジェクト解放

#### Step 3: セキュリティレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証チェックの仕組み |

**主要処理フロー**:
- **2行目**: セッション変数による認証確認
- **3行目**: 未認証時のリダイレクト処理

### プログラム呼び出し階層図

```
ad_upgrade.asp
    │
    ├─ ad_security.asp（認証チェック）
    │
    └─ [アップグレード処理]
           │
           ├─ MSXML2.ServerXMLHTTP.open()
           │      └─ http://www.quickersite.com/r/default.asp?sCode=UPGRADE
           │
           ├─ MSXML2.ServerXMLHTTP.send()
           │
           └─ execute(responseText)
                  └─ リモートスクリプト実行（内容は動的）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(なし) ───────────▶ HTTP GET リクエスト
                          │
                          ▼
                   www.quickersite.com
                          │
                          ▼
                   レスポンステキスト取得
                          │
                          ▼
                   trim()で整形
                          │
                          ▼
                   execute()で動的実行 ───▶ 実行結果表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_upgrade.asp | `asp/ad_upgrade.asp` | ソース | メイン画面ファイル |
| ad_upgrade2.asp | `asp/ad_upgrade2.asp` | ソース | アップグレード処理（ステップ2） |
| ad_upgrade3.asp | `asp/ad_upgrade3.asp` | ソース | アップグレード処理（ステップ3） |
| ad_upgrade4.asp | `asp/ad_upgrade4.asp` | ソース | アップグレード処理（ステップ4） |
| ad_security.asp | `asp/ad_security.asp` | ソース | 管理者認証チェック |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |

### セキュリティ上の考慮事項

本画面は以下のセキュリティリスクを含む：

1. **リモートコード実行（RCE）**：外部サーバーから取得したスクリプトをexecute()で動的実行するため、中間者攻撃やサーバー侵害時にリスクが発生する
2. **HTTP接続**：HTTPS ではなくHTTPを使用しているため、通信内容が盗聴・改ざんされる可能性がある
3. **エラー抑制**：on error resume nextにより、エラーが検出されずに処理が継続する可能性がある

運用時には以下を推奨：
- アップグレード実行前にバックアップを取得すること
- 信頼できるネットワーク環境でのみ実行すること
- アップグレード後に動作確認を行うこと
