# 画面設計書 151-アップグレード2

## 概要

本ドキュメントは、QuickerSite CMSのシステムアップグレード処理（ステップ2）画面の設計書です。この画面は、データベーススキーマをAccess形式で出力するための管理者専用ツール画面です。

### 本画面の処理概要

この画面は、システムのデータベーススキーマをAccess/JET形式のSQL文として生成・出力する機能を提供します。データベースのアップグレードやマイグレーション作業において、既存のテーブル構造を把握し、新しい環境にテーブルを再作成するためのスクリプトを生成します。

**業務上の目的・背景**：QuickerSite CMSは複数のデータベースエンジン（Access、SQL Server、MySQL）をサポートしており、システムアップグレードや環境移行時にデータベーススキーマの同期が必要です。この画面は、システム管理者がAccess形式のデータベーススキーマをSQL文として出力し、データベース構造の確認やマイグレーション用スクリプトとして利用できるようにします。

**画面へのアクセス方法**：管理者としてシステムにログイン後、管理者ダッシュボードからアップグレード処理へ遷移し、ステップ2として本画面にアクセスします。URLは `asp/ad_upgrade2.asp` です。

**主要な操作・処理内容**：
1. データベースカタログの取得（ADOX.Catalogオブジェクトを使用）
2. 全テーブルの走査とCREATE TABLE文の生成
3. 各カラムのALTER TABLE ADD COLUMN文の生成
4. プライマリキー（iId列）がある場合のINDEX作成文の生成
5. 画面上へのSQL文の出力表示

**画面遷移**：
- 遷移元: 管理者ダッシュボード（ad_default.asp）、アップグレード画面（ad_upgrade.asp）
- 遷移先: ad_customer.asp（フォームのアクション先）

**権限による表示制御**：システム管理者（Admin）としてセッション認証されている場合のみアクセス可能です。認証されていない場合は `noaccess.htm` にリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | システムアップグレード処理（ステップ2） |

## 画面種別

処理実行・結果表示画面

## URL/ルーティング

`asp/ad_upgrade2.asp`

## 入出力項目

本画面は入力項目を持たず、アクセス時に自動的に処理が実行されます。

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|----|----|
| SQLスクリプト | 出力 | テキスト | 生成されたCREATE TABLE/ALTER TABLE/CREATE INDEX文 |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| エラーハンドリング開始 | `On Error Resume Next` 文 |
| CREATE TABLE文 | 各テーブルのCREATE TABLE文 |
| ALTER TABLE文 | 各カラムのALTER TABLE ADD COLUMN文 |
| CREATE INDEX文 | プライマリキー用のINDEX作成文 |
| エラーハンドリング終了 | `On Error Goto 0` 文 |

## イベント仕様

### 1-ページ読み込み時

1. `ad_security.asp` によるセッション認証チェック
2. ADOX.Catalogオブジェクトを生成しデータベース接続
3. 全テーブルを走査
4. "tb"で始まるテーブルのみを処理対象とする
5. 各テーブルについてCREATE TABLE文を生成
6. 各カラムについてALTER TABLE ADD COLUMN文を生成
7. カラム名が"iId"の場合、プライマリキーフラグを設定
8. プライマリキーフラグがある場合、CREATE INDEX文を生成
9. 全SQL文を画面に出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | 全テーブル（tbプレフィックス） | SELECT（メタデータ） | テーブル構造の読み取り |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行いません。テーブルのメタデータを読み取りのみ行います。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 情報 | `On Error Resume Next` | 処理開始時 |
| 情報 | `On Error Goto 0` | 処理終了時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | `noaccess.htm` にリダイレクト |
| デフォルトパスワード使用中 | `noaccess.htm` にリダイレクト |

## 備考

- 本画面で出力されるSQL文はAccess/JET形式（Microsoft Access データベース用）です
- `GetSQLTypeName` 関数でADOデータ型をAccessのSQL型名に変換しています
- 対応するデータ型マッピング:
  - 3 (AUTOINCREMENT) -> `COUNTER NOT NULL` / `LONG NULL`
  - 7 (DATE) -> `DATETIME NULL`
  - 11 (BOOLEAN) -> `BIT NULL`
  - 6 (CURRENCY) -> `MONEY`
  - 128 (BINARY) -> `BINARY`
  - 17 (TINYINT) -> `TINYINT`
  - 131 (DECIMAL) -> `DECIMAL`
  - 5 (DOUBLE) -> `FLOAT`
  - 2 (SMALLINT) -> `INTEGER NULL`
  - 4 (SINGLE) -> `REAL`
  - 72 (GUID) -> `UNIQUEIDENTIFIER`
  - 202 (VARCHAR) -> `TEXT(255)`
  - 203 (LONGVARCHAR) -> `MEMO NULL`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ADOXライブラリで取得するデータベースメタデータの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ad_upgrade2.asp | `asp/ad_upgrade2.asp` | ADOX.Catalogの使用方法とテーブル・カラム情報の取得 |

**読解のコツ**: ADOXはActiveX Data Objects Extensionsの略で、データベースのスキーマ情報にアクセスするためのCOMオブジェクトです。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_upgrade2.asp | `asp/ad_upgrade2.asp` | メイン処理の流れ |
| 2-2 | ad_security.asp | `asp/ad_security.asp` | 認証チェックのロジック |

**主要処理フロー**:
1. **行1**: begin.aspのインクルード（初期化処理）
2. **行4**: ad_security.aspによる認証チェック
3. **行5-6**: ADOX.Catalogオブジェクトの生成とDB接続
4. **行9-36**: テーブル走査ループ
5. **行11**: CREATE TABLE文の出力
6. **行14-25**: カラム走査ループとALTER TABLE文の出力
7. **行26-28**: プライマリキーINDEX文の出力
8. **行38-54**: GetSQLTypeName関数（データ型変換）

#### Step 3: 認証処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_security.asp | `asp/ad_security.asp` | 管理者認証の検証ロジック |
| 3-2 | begin.asp | `asp/begin.asp` | セッション変数と初期化処理 |

**主要処理フロー**:
- **行2**: devVersion()関数でデフォルトパスワードチェック
- **行3**: Session変数`isAUTHENTICATEDasADMIN`による認証確認

### プログラム呼び出し階層図

```
ad_upgrade2.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- config/rebrand.asp
    |       +-- config/web_config.asp
    |       +-- includes/database.asp
    |       +-- includes/functions.asp
    |       +-- その他多数のインクルード
    |
    +-- includes/header.asp
    +-- bs_initBack.asp
    +-- bs_header.asp
    +-- ad_security.asp (認証チェック)
    |       |
    |       +-- Session変数チェック
    |       +-- noaccess.htmへのリダイレクト
    |
    +-- ADOX.Catalog (COMオブジェクト)
    |       |
    |       +-- Tables コレクション
    |               |
    |               +-- Columns コレクション
    |               +-- Indexes コレクション
    |
    +-- GetSQLTypeName() (データ型変換関数)
    |
    +-- ad_back.asp
    +-- bs_endBack.asp
    +-- includes/footer.asp
```

### データフロー図

```
[入力]                      [処理]                          [出力]

データベース接続          ADOX.Catalog                   SQL文（テキスト）
      |                       |                              |
      v                       v                              v
db.getConn --------> テーブル走査 --------> Response.Write
                           |                    |
                           v                    v
                      カラム走査           CREATE TABLE文
                           |               ALTER TABLE文
                           v               CREATE INDEX文
                   GetSQLTypeName
                   (型変換関数)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_upgrade2.asp | `asp/ad_upgrade2.asp` | ソース | メイン処理ファイル |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証チェック |
| database.asp | `asp/includes/database.asp` | インクルード | データベース接続クラス |
| header.asp | `asp/includes/header.asp` | テンプレート | ヘッダー表示 |
| footer.asp | `asp/includes/footer.asp` | テンプレート | フッター表示 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| ad_back.asp | `asp/ad_back.asp` | テンプレート | 管理者戻りリンク |
