# 画面設計書 152-アップグレード3

## 概要

本ドキュメントは、QuickerSite CMSのシステムアップグレード処理（ステップ3）画面の設計書です。この画面は、データベーススキーマをSQL Server形式で出力するための管理者専用ツール画面です。

### 本画面の処理概要

この画面は、システムのデータベーススキーマをSQL Server形式のSQL文として生成・出力する機能を提供します。データベースのアップグレードやマイグレーション作業において、既存のテーブル構造をSQL Server互換のスクリプトとして生成し、新しいSQL Server環境にテーブルを再作成するために使用します。

**業務上の目的・背景**：QuickerSite CMSは複数のデータベースエンジン（Access、SQL Server、MySQL）をサポートしています。AccessからSQL Serverへのマイグレーションやシステムアップグレード時に、この画面で生成されるスクリプトを使用して、データベース構造をSQL Serverに移行します。SQL Serverは大規模サイトや高負荷環境でよく使用されるため、この変換機能は重要です。

**画面へのアクセス方法**：管理者としてシステムにログイン後、管理者ダッシュボードからアップグレード処理へ遷移し、ステップ3として本画面にアクセスします。URLは `asp/ad_upgrade3.asp` です。

**主要な操作・処理内容**：
1. データベースカタログの取得（ADOX.Catalogオブジェクトを使用）
2. 全テーブルの走査とCREATE TABLE文の生成（QS_IDダミー列付き）
3. 各カラムのALTER TABLE ADD文の生成（SQL Server構文）
4. 画面上へのSQL文の出力表示

**画面遷移**：
- 遷移元: 管理者ダッシュボード（ad_default.asp）、アップグレード画面（ad_upgrade.asp）
- 遷移先: ad_customer.asp（フォームのアクション先）

**権限による表示制御**：システム管理者（Admin）としてセッション認証されている場合のみアクセス可能です。認証されていない場合は `noaccess.htm` にリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | システムアップグレード処理（ステップ3） |

## 画面種別

処理実行・結果表示画面

## URL/ルーティング

`asp/ad_upgrade3.asp`

## 入出力項目

本画面は入力項目を持たず、アクセス時に自動的に処理が実行されます。

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|----|----|
| SQLスクリプト | 出力 | テキスト | 生成されたCREATE TABLE/ALTER TABLE文（SQL Server形式） |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| エラーハンドリング開始 | `On Error Resume Next` 文 |
| CREATE TABLE文 | 各テーブルのCREATE TABLE文（QS_IDダミー列付き） |
| ALTER TABLE文 | 各カラムのALTER TABLE ADD文（SQL Server構文） |
| エラーハンドリング終了 | `On Error Goto 0` 文 |

## イベント仕様

### 1-ページ読み込み時

1. `ad_security.asp` によるセッション認証チェック
2. ADOX.Catalogオブジェクトを生成しデータベース接続
3. 全テーブルを走査
4. "tb"で始まるテーブルのみを処理対象とする
5. 各テーブルについてCREATE TABLE文を生成（QS_IDダミー列を含む）
6. 各カラムについてALTER TABLE ADD文を生成
7. 全SQL文を画面に出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | 全テーブル（tbプレフィックス） | SELECT（メタデータ） | テーブル構造の読み取り |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行いません。テーブルのメタデータを読み取りのみ行います。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 情報 | `On Error Resume Next` | 処理開始時 |
| 情報 | `On Error Goto 0` | 処理終了時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | `noaccess.htm` にリダイレクト |
| デフォルトパスワード使用中 | `noaccess.htm` にリダイレクト |

## 備考

- 本画面で出力されるSQL文はSQL Server形式です
- CREATE TABLE文にはQS_IDダミー列が含まれます（後で削除可能なプレースホルダー）
- ALTER TABLE文はCOLUMNキーワードなしの構文を使用（SQL Server特有）
- `GetSQLTypeName` 関数でADOデータ型をSQL Serverの型名に変換しています
- 対応するデータ型マッピング:
  - 3 (AUTOINCREMENT) -> `INT IDENTITY(1,1) NOT NULL` / `INT NULL`
  - 7 (DATE) -> `datetime NULL`
  - 11 (BOOLEAN) -> `bit NULL`
  - 6 (CURRENCY) -> `MONEY`
  - 128 (BINARY) -> `BINARY`
  - 17 (TINYINT) -> `int`
  - 131 (DECIMAL) -> `int`
  - 5 (DOUBLE) -> `int`
  - 2 (SMALLINT) -> `int NULL`
  - 4 (SINGLE) -> `REAL`
  - 72 (GUID) -> `UNIQUEIDENTIFIER`
  - 202 (VARCHAR) -> `nvarchar(255)`
  - 203 (LONGVARCHAR) -> `ntext NULL`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ADOXライブラリで取得するデータベースメタデータの構造と、SQL Serverのデータ型を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ad_upgrade3.asp | `asp/ad_upgrade3.asp` | SQL Serverへの型マッピングとCREATE TABLE構文 |

**読解のコツ**: SQL Serverでは`nvarchar`（Unicode文字列）や`ntext`（Unicodeテキスト）など、Unicode対応の型が使用されます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_upgrade3.asp | `asp/ad_upgrade3.asp` | メイン処理の流れ |
| 2-2 | ad_security.asp | `asp/ad_security.asp` | 認証チェックのロジック |

**主要処理フロー**:
1. **行1**: begin.aspのインクルード（初期化処理）
2. **行4**: ad_security.aspによる認証チェック
3. **行5-6**: ADOX.Catalogオブジェクトの生成とDB接続
4. **行9-36**: テーブル走査ループ
5. **行11**: CREATE TABLE文の出力（QS_IDダミー列付き）
6. **行14-25**: カラム走査ループとALTER TABLE ADD文の出力
7. **行38-54**: GetSQLTypeName関数（SQL Server用データ型変換）

#### Step 3: ad_upgrade2.aspとの違いを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_upgrade2.asp | `asp/ad_upgrade2.asp` | Access形式との比較 |
| 3-2 | ad_upgrade3.asp | `asp/ad_upgrade3.asp` | SQL Server形式の特徴 |

**主な違い**:
- CREATE TABLE構文: ダミー列QS_IDの追加
- ALTER TABLE構文: COLUMNキーワードなし
- 型マッピング: Unicode対応型（nvarchar, ntext）の使用
- IDENTITY構文: AUTO_INCREMENTの代わりにIDENTITY(1,1)

### プログラム呼び出し階層図

```
ad_upgrade3.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- config/rebrand.asp
    |       +-- config/web_config.asp
    |       +-- includes/database.asp
    |       +-- includes/functions.asp
    |       +-- その他多数のインクルード
    |
    +-- includes/header.asp
    +-- bs_initBack.asp
    +-- bs_header.asp
    +-- ad_security.asp (認証チェック)
    |       |
    |       +-- Session変数チェック
    |       +-- noaccess.htmへのリダイレクト
    |
    +-- ADOX.Catalog (COMオブジェクト)
    |       |
    |       +-- Tables コレクション
    |               |
    |               +-- Columns コレクション
    |               +-- Indexes コレクション
    |
    +-- GetSQLTypeName() (SQL Server用データ型変換関数)
    |
    +-- ad_back.asp
    +-- bs_endBack.asp
    +-- includes/footer.asp
```

### データフロー図

```
[入力]                      [処理]                          [出力]

データベース接続          ADOX.Catalog                   SQL文（SQL Server形式）
      |                       |                              |
      v                       v                              v
db.getConn --------> テーブル走査 --------> Response.Write
                           |                    |
                           v                    v
                      カラム走査           CREATE TABLE文
                           |               (QS_ID int NULL)
                           v               ALTER TABLE ADD文
                   GetSQLTypeName
                   (SQL Server型変換)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_upgrade3.asp | `asp/ad_upgrade3.asp` | ソース | メイン処理ファイル |
| ad_upgrade2.asp | `asp/ad_upgrade2.asp` | ソース | 比較対象（Access形式） |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証チェック |
| database.asp | `asp/includes/database.asp` | インクルード | データベース接続クラス |
| header.asp | `asp/includes/header.asp` | テンプレート | ヘッダー表示 |
| footer.asp | `asp/includes/footer.asp` | テンプレート | フッター表示 |
