# 画面設計書 153-アップグレード4

## 概要

本ドキュメントは、QuickerSite CMSのシステムアップグレード処理（ステップ4）画面の設計書です。この画面は、データベーススキーマを生SQL形式（db.executeラッパーなし）で出力するための管理者専用ツール画面です。

### 本画面の処理概要

この画面は、システムのデータベーススキーマを純粋なSQL文として生成・出力する機能を提供します。ad_upgrade2.aspやad_upgrade3.aspがASP/VBScript形式（db.execute()でラップ）で出力するのに対し、本画面はそのまま実行可能なSQL文を出力します。SQL Server Management StudioやMySQLクライアント等で直接実行できる形式です。

**業務上の目的・背景**：QuickerSite CMSのデータベースマイグレーションにおいて、管理ツールから直接実行可能なSQLスクリプトが必要な場合があります。この画面で出力されるスクリプトは、ASPコードを経由せずにデータベース管理ツールで直接実行でき、大量のテーブル作成を効率的に行えます。

**画面へのアクセス方法**：管理者としてシステムにログイン後、管理者ダッシュボードからアップグレード処理へ遷移し、ステップ4として本画面にアクセスします。URLは `asp/ad_upgrade4.asp` です。

**主要な操作・処理内容**：
1. データベースカタログの取得（ADOX.Catalogオブジェクトを使用）
2. 全テーブルの走査とCREATE TABLE文の生成（純粋SQL）
3. 各カラムのALTER TABLE ADD文の生成（純粋SQL）
4. 画面上への生SQL文の出力表示

**画面遷移**：
- 遷移元: 管理者ダッシュボード（ad_default.asp）、アップグレード画面（ad_upgrade.asp）
- 遷移先: ad_customer.asp（フォームのアクション先）

**権限による表示制御**：システム管理者（Admin）としてセッション認証されている場合のみアクセス可能です。認証されていない場合は `noaccess.htm` にリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | システムアップグレード処理（ステップ4） |

## 画面種別

処理実行・結果表示画面

## URL/ルーティング

`asp/ad_upgrade4.asp`

## 入出力項目

本画面は入力項目を持たず、アクセス時に自動的に処理が実行されます。

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|----|----|
| SQLスクリプト | 出力 | テキスト | 生成されたCREATE TABLE/ALTER TABLE文（純粋SQL形式） |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| エラーハンドリング開始 | `On Error Resume Next` 文 |
| CREATE TABLE文 | 各テーブルのCREATE TABLE文（QS_IDダミー列付き、セミコロン終端） |
| ALTER TABLE文 | 各カラムのALTER TABLE ADD文（セミコロン終端） |
| エラーハンドリング終了 | `On Error Goto 0` 文 |

## イベント仕様

### 1-ページ読み込み時

1. `ad_security.asp` によるセッション認証チェック
2. ADOX.Catalogオブジェクトを生成しデータベース接続
3. 全テーブルを走査
4. "tb"で始まるテーブルのみを処理対象とする
5. 各テーブルについてCREATE TABLE文を生成（QS_IDダミー列、セミコロン終端）
6. 各カラムについてALTER TABLE ADD文を生成（セミコロン終端）
7. 全SQL文を画面に出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | 全テーブル（tbプレフィックス） | SELECT（メタデータ） | テーブル構造の読み取り |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行いません。テーブルのメタデータを読み取りのみ行います。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 情報 | `On Error Resume Next` | 処理開始時 |
| 情報 | `On Error Goto 0` | 処理終了時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | `noaccess.htm` にリダイレクト |
| デフォルトパスワード使用中 | `noaccess.htm` にリダイレクト |

## 備考

- 本画面で出力されるSQL文は純粋なSQL形式（db.execute()ラッパーなし）
- 各SQL文はセミコロン（;）で終端
- CREATE TABLE文にはQS_IDダミー列が含まれる
- SQL Server Management Studio等で直接コピー&ペースト実行可能
- `GetSQLTypeName` 関数はad_upgrade3.aspと同一（SQL Server互換型）
- 対応するデータ型マッピング:
  - 3 (AUTOINCREMENT) -> `INT IDENTITY(1,1) NOT NULL` / `INT NULL`
  - 7 (DATE) -> `datetime NULL`
  - 11 (BOOLEAN) -> `bit NULL`
  - 6 (CURRENCY) -> `MONEY`
  - 128 (BINARY) -> `BINARY`
  - 17 (TINYINT) -> `int`
  - 131 (DECIMAL) -> `int`
  - 5 (DOUBLE) -> `int`
  - 2 (SMALLINT) -> `int NULL`
  - 4 (SINGLE) -> `REAL`
  - 72 (GUID) -> `UNIQUEIDENTIFIER`
  - 202 (VARCHAR) -> `nvarchar(255)`
  - 203 (LONGVARCHAR) -> `ntext NULL`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

出力されるSQL文の形式の違いを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ad_upgrade4.asp | `asp/ad_upgrade4.asp` | セミコロン終端の純粋SQL出力形式 |
| 1-2 | ad_upgrade3.asp | `asp/ad_upgrade3.asp` | db.execute()ラップ形式との比較 |

**読解のコツ**: ad_upgrade3.aspとの主な違いは出力形式のみ。型マッピングは同一です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_upgrade4.asp | `asp/ad_upgrade4.asp` | メイン処理の流れ |
| 2-2 | ad_security.asp | `asp/ad_security.asp` | 認証チェックのロジック |

**主要処理フロー**:
1. **行1**: begin.aspのインクルード（初期化処理）
2. **行4**: ad_security.aspによる認証チェック
3. **行5-6**: ADOX.Catalogオブジェクトの生成とDB接続
4. **行9-36**: テーブル走査ループ
5. **行11**: CREATE TABLE文の出力（セミコロン終端）
6. **行15**: ALTER TABLE ADD文の出力（セミコロン終端）
7. **行38-54**: GetSQLTypeName関数（SQL Server用データ型変換）

#### Step 3: 出力形式の違いを比較する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_upgrade2.asp | `asp/ad_upgrade2.asp` | Access形式 + db.execute() |
| 3-2 | ad_upgrade3.asp | `asp/ad_upgrade3.asp` | SQL Server形式 + db.execute() |
| 3-3 | ad_upgrade4.asp | `asp/ad_upgrade4.asp` | SQL Server形式 + 純粋SQL |

**出力形式の比較**:
- ad_upgrade2: `db.execute("CREATE TABLE...")`
- ad_upgrade3: `db.execute("CREATE TABLE...")`
- ad_upgrade4: `CREATE TABLE...;`

### プログラム呼び出し階層図

```
ad_upgrade4.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- config/rebrand.asp
    |       +-- config/web_config.asp
    |       +-- includes/database.asp
    |       +-- includes/functions.asp
    |       +-- その他多数のインクルード
    |
    +-- includes/header.asp
    +-- bs_initBack.asp
    +-- bs_header.asp
    +-- ad_security.asp (認証チェック)
    |       |
    |       +-- Session変数チェック
    |       +-- noaccess.htmへのリダイレクト
    |
    +-- ADOX.Catalog (COMオブジェクト)
    |       |
    |       +-- Tables コレクション
    |               |
    |               +-- Columns コレクション
    |
    +-- GetSQLTypeName() (SQL Server用データ型変換関数)
    |
    +-- ad_back.asp
    +-- bs_endBack.asp
    +-- includes/footer.asp
```

### データフロー図

```
[入力]                      [処理]                          [出力]

データベース接続          ADOX.Catalog                   純粋SQL文
      |                       |                              |
      v                       v                              v
db.getConn --------> テーブル走査 --------> Response.Write
                           |                    |
                           v                    v
                      カラム走査           CREATE TABLE文;
                           |               ALTER TABLE ADD文;
                           v               (セミコロン終端)
                   GetSQLTypeName
                   (SQL Server型変換)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_upgrade4.asp | `asp/ad_upgrade4.asp` | ソース | メイン処理ファイル |
| ad_upgrade2.asp | `asp/ad_upgrade2.asp` | ソース | 比較対象（Access形式） |
| ad_upgrade3.asp | `asp/ad_upgrade3.asp` | ソース | 比較対象（SQL Server + db.execute） |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証チェック |
| database.asp | `asp/includes/database.asp` | インクルード | データベース接続クラス |
