# 画面設計書 154-アプリケーションリセット

## 概要

本ドキュメントは、QuickerSite CMSの全アプリケーションリセット画面の設計書です。この画面は、管理者が管理する全ての顧客サイトのアプリケーションキャッシュを一括でリセットするための管理者専用ツール画面です。

### 本画面の処理概要

この画面は、システム管理者が管理する全ての顧客サイトに対して、アプリケーションキャッシュのリセットを一括で実行する機能を提供します。各サイトの`ad_resetAPP.asp`エンドポイントにHTTPリクエストを送信し、リセット結果を画面に表示します。

**業務上の目的・背景**：QuickerSite CMSはマルチテナント型のCMSであり、複数の顧客サイトを一つのシステムで管理します。システムアップグレードや設定変更後、全サイトのキャッシュをクリアする必要がある場合があります。この画面は、その一括処理を効率的に行うためのツールです。キャッシュリセットにより、設定変更やテンプレート更新が全サイトに即座に反映されます。

**画面へのアクセス方法**：管理者としてシステムにログイン後、管理者ダッシュボードからアクセスします。URLは `asp/ad_resetAllAPP.asp` です。管理者として認証されている必要があります。

**主要な操作・処理内容**：
1. 全顧客リストの取得
2. 各顧客サイトに対してHTTPリクエストを送信（ad_resetAPP.asp）
3. 各サイトのリセット結果（成功/失敗）を画面に表示
4. 処理完了後、レスポンスを終了

**画面遷移**：
- 遷移元: 管理者ダッシュボード（ad_default.asp）
- 遷移先: なし（処理完了後Response.End）

**権限による表示制御**：システム管理者（Admin）としてセッション認証されている場合のみアクセス可能です。認証されていない場合は `noaccess.htm` にリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | 全アプリケーションのキャッシュリセット |

## 画面種別

一括処理実行・結果表示画面

## URL/ルーティング

`asp/ad_resetAllAPP.asp`

## 入出力項目

本画面は入力項目を持たず、アクセス時に自動的に処理が実行されます。

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|----|----|
| リセット結果 | 出力 | テキスト | 各サイトのリセット成功/失敗の結果 |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| サイトURL | 処理対象のサイトURL |
| リセット結果 | "Reset OK" または "Reset NOT OK"（赤字太字） |

## イベント仕様

### 1-ページ読み込み時

1. `ad_security.asp` によるセッション認証チェック
2. `cls_customerList` クラスで全顧客リストを取得
3. 各顧客に対してループ処理:
   a. リセット用URLを構築（sQSUrl/asp/ad_resetAPP.asp?apw=認証ハッシュ）
   b. `GetWebPage` 関数でHTTPリクエストを送信
   c. レスポンスに"Application Reset"が含まれれば成功
   d. 結果を画面に出力
   e. `Response.Flush` で即時表示
4. `Response.End` で処理終了

### GetWebPage関数の処理

1. `MSXML2.ServerXMLHTTP` オブジェクトを生成
2. GETリクエストを送信
3. HTTPステータス200かつレスポンスに"Application Reset"が含まれれば成功
4. エラー発生時はfalseを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | tblCustomer | SELECT | 顧客一覧の取得 |

### テーブル別更新項目詳細

#### tblCustomer（読み取りのみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | 全件取得 | 顧客ID |
| SELECT | sQSUrl | 全件取得 | QuickerSiteのURL |
| SELECT | sUrl | 全件取得 | サイトURL |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | `{サイトURL} Reset OK` | リセット成功時 |
| エラー | `{サイトURL} Reset NOT OK` | リセット失敗時（赤字太字） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | `noaccess.htm` にリダイレクト |
| デフォルトパスワード使用中 | `noaccess.htm` にリダイレクト |
| HTTPリクエストエラー | "Reset NOT OK" を表示し、次のサイトへ処理続行 |

## 備考

- 認証にはC_ADMINPASSWORDのSHA256ハッシュを使用（apwパラメータ）
- 各サイトへのリクエストは同期的に実行される
- `Response.Flush` により、各サイトの結果が即座に画面に表示される
- エラーが発生しても処理は継続し、全サイトを処理する
- リセット成功の判定は、レスポンスに"Application Reset"文字列が含まれるかどうか

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

顧客リストの構造と、リセットURLの構築方法を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customerList.asp | `asp/includes/customerList.asp` | cls_customerListクラスの構造 |
| 1-2 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのプロパティ |

**読解のコツ**: `sQSUrl`はQuickerSiteのベースURL、`sUrl`は公開サイトのURLです。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_resetAllAPP.asp | `asp/ad_resetAllAPP.asp` | メイン処理の流れ |
| 2-2 | ad_security.asp | `asp/ad_security.asp` | 認証チェックのロジック |

**主要処理フロー**:
1. **行1**: begin.aspのインクルード（初期化処理）
2. **行4**: ad_security.aspによる認証チェック
3. **行4-5**: cls_customerListの生成と顧客テーブル取得
4. **行8-17**: 顧客ループ処理
5. **行10**: リセットURL構築（SHA256認証トークン付き）
6. **行11-15**: GetWebPage呼び出しと結果表示
7. **行19-35**: GetWebPage関数定義
8. **行37**: Response.Endで処理終了

#### Step 3: 個別リセット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_resetAPP.asp | `asp/ad_resetAPP.asp` | 個別サイトのリセット処理 |

**主要処理フロー**:
- **行4**: `removeApplication()` 関数でキャッシュクリア
- **行5**: "Application Reset" メッセージ出力
- **行7**: `logon.logoff` でセッション終了

### プログラム呼び出し階層図

```
ad_resetAllAPP.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- includes/customerList.asp
    |       +-- includes/customer.asp
    |       +-- includes/sha256.asp
    |       +-- その他多数のインクルード
    |
    +-- ad_security.asp (認証チェック)
    |
    +-- cls_customerList.table()
    |       |
    |       +-- tblCustomerからSELECT
    |       +-- cls_customerオブジェクト生成
    |
    +-- GetWebPage() (HTTPリクエスト)
    |       |
    |       +-- MSXML2.ServerXMLHTTP
    |               |
    |               +-- GET {sQSUrl}/asp/ad_resetAPP.asp?apw={sha256}
    |                       |
    |                       +-- ad_resetAPP.asp (各サイト)
    |                               |
    |                               +-- removeApplication()
    |                               +-- logon.logoff
    |
    +-- Response.Flush (即時出力)
    +-- Response.End
```

### データフロー図

```
[入力]                      [処理]                          [出力]

認証チェック              顧客リスト取得                リセット結果
      |                       |                              |
      v                       v                              v
Session確認 --------> cls_customerList --------> 各サイトURL
                           |                         |
                           v                         v
                      FOR EACH --------> HTTP GET (ad_resetAPP.asp)
                        ループ                       |
                           |                         v
                           +-------> Response.Write (OK/NOT OK)
                           |                         |
                           v                         v
                      Response.Flush ---------> 即時画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_resetAllAPP.asp | `asp/ad_resetAllAPP.asp` | ソース | メイン処理ファイル |
| ad_resetAPP.asp | `asp/ad_resetAPP.asp` | ソース | 個別サイトリセット処理 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証チェック |
| customerList.asp | `asp/includes/customerList.asp` | インクルード | 顧客リストクラス |
| customer.asp | `asp/includes/customer.asp` | インクルード | 顧客クラス |
| sha256.asp | `asp/includes/sha256.asp` | インクルード | SHA256ハッシュ関数 |
