# 画面設計書 155-アプリケーションリセット（個別）

## 概要

本ドキュメントは、QuickerSite CMSの個別アプリケーションリセット画面の設計書です。この画面は、単一サイトのアプリケーションキャッシュをリセットするためのエンドポイントであり、全サイト一括リセット処理（ad_resetAllAPP.asp）から呼び出されます。

### 本画面の処理概要

この画面は、個別のサイトのアプリケーションキャッシュをリセットする機能を提供します。`removeApplication()` 関数を呼び出してキャッシュをクリアし、セッションをログオフして処理を完了します。主に一括リセット処理からHTTPリクエストで呼び出される用途を想定しています。

**業務上の目的・背景**：QuickerSite CMSでは、設定変更やテンプレート更新後にアプリケーションキャッシュをクリアする必要があります。この画面は、その個別サイトのキャッシュリセット機能を提供します。一括リセット画面（ad_resetAllAPP.asp）からの呼び出しに対応するとともに、個別にキャッシュをクリアしたい場合にも使用できます。

**画面へのアクセス方法**：
1. 一括リセット画面（ad_resetAllAPP.asp）からHTTPリクエストで呼び出される
2. 直接アクセスする場合は、URLパラメータ `apw` にC_ADMINPASSWORDのSHA256ハッシュを指定

URLは `asp/ad_resetAPP.asp` です。

**主要な操作・処理内容**：
1. 管理者認証チェック
2. `removeApplication()` 関数でキャッシュクリア実行
3. "Application Reset" メッセージとサイトリンクを出力
4. `logon.logoff` でセッション終了
5. `Response.End` で処理終了

**画面遷移**：
- 遷移元: ad_resetAllAPP.asp（HTTPリクエスト）、または直接アクセス
- 遷移先: なし（処理完了後Response.End）、サイトトップへのリンクを表示

**権限による表示制御**：システム管理者（Admin）としてセッション認証されている場合、またはURLパラメータ `apw` に正しい認証トークンが指定されている場合のみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | 個別アプリケーションのキャッシュリセット |

## 画面種別

処理実行・結果表示画面（APIエンドポイント）

## URL/ルーティング

`asp/ad_resetAPP.asp`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|----|----|-----|
| apw | 入力（URLパラメータ） | 文字列 | 条件付き | C_ADMINPASSWORDのSHA256ハッシュ（HTTPリクエスト時使用） |
| メッセージ | 出力 | テキスト | - | "Application Reset" と確認リンク |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| Application Reset | 処理完了メッセージ |
| Check site リンク | サイトトップページへのリンク |

## イベント仕様

### 1-ページ読み込み時

1. `ad_security.asp` によるセッション認証チェック
2. `removeApplication()` 関数でアプリケーションキャッシュをクリア
3. "Application Reset" メッセージを出力
4. サイトURLへのリンクを出力
5. `logon.logoff` でセッションを終了
6. `Response.End` で処理を終了

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし（キャッシュクリアのみ） |

### テーブル別更新項目詳細

本画面ではデータベースの更新は行いません。アプリケーションキャッシュ（ASPのApplicationオブジェクト）のクリアのみを行います。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | `Application Reset` | 処理完了時 |
| リンク | `Check site` リンク | 処理完了時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | `noaccess.htm` にリダイレクト |
| デフォルトパスワード使用中 | `noaccess.htm` にリダイレクト |

## 備考

- 本画面は主にad_resetAllAPP.aspから呼び出されるエンドポイントとして機能
- `removeApplication()` 関数はASPのApplicationオブジェクトに保存されたキャッシュをクリア
- 処理後は自動的にログオフされるため、再度認証が必要
- 一括リセット処理での呼び出し時は、認証トークン（apwパラメータ）による認証が使用される
- レスポンスに"Application Reset"文字列が含まれることで、呼び出し元が成功を判定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ASPのApplicationオブジェクトとキャッシュの仕組みを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | begin.asp | `asp/begin.asp` | Applicationオブジェクトへのキャッシュ保存パターン |

**読解のコツ**: ASPのApplicationオブジェクトはアプリケーション全体で共有されるグローバル変数領域です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_resetAPP.asp | `asp/ad_resetAPP.asp` | メイン処理の流れ（非常にシンプル） |
| 2-2 | ad_security.asp | `asp/ad_security.asp` | 認証チェックのロジック |

**主要処理フロー**:
1. **行1**: begin.aspのインクルード（初期化処理）
2. **行4**: ad_security.aspによる認証チェック
3. **行4**: `removeApplication()` 関数呼び出し
4. **行5**: "Application Reset" メッセージ出力
5. **行6**: サイトリンク出力
6. **行7**: `logon.logoff` でセッション終了
7. **行8**: `Response.End` で処理終了

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_resetAllAPP.asp | `asp/ad_resetAllAPP.asp` | 一括リセット処理からの呼び出し方法 |

**呼び出しパターン**:
- URL: `{sQSUrl}/asp/ad_resetAPP.asp?apw={sha256(C_ADMINPASSWORD)}`
- Method: GET
- 成功判定: レスポンスに"Application Reset"が含まれる

### プログラム呼び出し階層図

```
ad_resetAPP.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- includes/functions.asp (removeApplication関数)
    |       +-- includes/logonEdit.asp (logonクラス)
    |       +-- その他多数のインクルード
    |
    +-- ad_security.asp (認証チェック)
    |       |
    |       +-- Session変数チェック
    |       +-- または apwパラメータ検証
    |
    +-- removeApplication() (キャッシュクリア)
    |       |
    |       +-- Application.RemoveAll または個別キー削除
    |
    +-- logon.logoff() (セッション終了)
    |
    +-- Response.End
```

### データフロー図

```
[入力]                      [処理]                          [出力]

認証情報                  認証チェック                  結果メッセージ
(Session または apw)            |                              |
      |                         v                              v
      +-------> ad_security.asp --------> removeApplication()
                                                |
                                                v
                                      Application Cache Clear
                                                |
                                                v
                                          logon.logoff()
                                                |
                                                v
                                      "Application Reset"
                                      + サイトリンク出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_resetAPP.asp | `asp/ad_resetAPP.asp` | ソース | メイン処理ファイル |
| ad_resetAllAPP.asp | `asp/ad_resetAllAPP.asp` | ソース | 一括リセット処理（呼び出し元） |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| ad_security.asp | `asp/ad_security.asp` | インクルード | 管理者認証チェック |
| functions.asp | `asp/includes/functions.asp` | インクルード | removeApplication関数定義 |
| logonEdit.asp | `asp/includes/logonEdit.asp` | インクルード | logonクラス定義 |
| customer.asp | `asp/includes/customer.asp` | インクルード | customerオブジェクト（sUrl取得） |
