# 画面設計書 156-管理メニュー

## 概要

本ドキュメントは、QuickerSite CMSの管理者メニュー画面の設計書です。この画面は、システム管理者向けの主要機能へのリンクを提供するナビゲーションメニューです。

### 本画面の処理概要

この画面は、管理者ダッシュボードや各管理機能への主要なリンクを集約したナビゲーションメニューを提供します。顧客管理、製品・サービス管理などの機能へ簡単にアクセスできるよう、中央揃えのリンク一覧として表示されます。

**業務上の目的・背景**：QuickerSite CMSの管理者は、複数の顧客サイトと製品・サービスを管理します。この画面は、頻繁に使用する管理機能へのショートカットを提供し、管理業務の効率化を図ります。シンプルなテキストリンク形式で、必要な機能に素早くアクセスできます。

**画面へのアクセス方法**：管理者としてシステムにログイン後、他の管理画面内でインクルードされて表示されます。直接アクセスするURLは `asp/ad_adminMenu.asp` ですが、通常は他のページのコンポーネントとして使用されます。

**主要な操作・処理内容**：
1. Customersリンク：顧客一覧画面（ad_clientList.asp）へ遷移
2. New Customerリンク：新規顧客登録画面（ad_client.asp）へ遷移
3. Products/Servicesリンク：製品一覧画面（ad_clientproducts.asp）へ遷移
4. Add Product/Serviceリンク：新規製品登録画面（ad_clientproduct.asp）へ遷移

**画面遷移**：
- 遷移先: ad_clientList.asp、ad_client.asp、ad_clientproducts.asp、ad_clientproduct.asp

**権限による表示制御**：本画面は単独では認証チェックを行わず、インクルード元の画面で認証されていることを前提としています。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ページ一覧 | 主機能 | 管理者メニューの表示 |

## 画面種別

ナビゲーションメニュー（インクルードコンポーネント）

## URL/ルーティング

`asp/ad_adminMenu.asp`

## 入出力項目

本画面は入出力項目を持たず、静的なナビゲーションリンクを表示します。

## 表示項目

| 表示項目 | リンク先 | 説明 |
|----------|---------|------|
| Customers | ad_clientList.asp | 顧客一覧画面へのリンク |
| New Customer | ad_client.asp | 新規顧客登録画面へのリンク |
| Products/Services | ad_clientproducts.asp | 製品・サービス一覧画面へのリンク |
| Add Product/Service | ad_clientproduct.asp | 新規製品・サービス登録画面へのリンク |

## イベント仕様

### 1-リンククリック時

各リンクをクリックすると、対応する管理画面へ遷移します。

| リンク | 遷移先 | 処理 |
|--------|-------|------|
| Customers | ad_clientList.asp | 顧客一覧を表示 |
| New Customer | ad_client.asp | 新規顧客登録フォームを表示 |
| Products/Services | ad_clientproducts.asp | 製品・サービス一覧を表示 |
| Add Product/Service | ad_clientproduct.asp | 新規製品・サービス登録フォームを表示 |

## データベース更新仕様

本画面ではデータベースの読み取り・更新は行いません。純粋なナビゲーションメニューです。

## メッセージ仕様

本画面ではメッセージ表示は行いません。

## 例外処理

本画面は単純なHTML出力のため、例外処理は実装されていません。

## 備考

- `getArtLink` 関数を使用してリンクを生成（Artisteerテンプレート対応）
- リンクは中央揃え（`<p align="center">`）で表示
- 各リンクは`&nbsp;&nbsp;`（2つの非改行スペース）で区切られる
- 本画面は通常、他の管理画面にインクルードされて使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リンク生成に使用される関数を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | artisteer.asp | `asp/includes/artisteer.asp` | getArtLink関数の定義 |

**読解のコツ**: `getArtLink` 関数は、Artisteerテンプレートとの互換性を保ちながらリンクを生成します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_adminMenu.asp | `asp/ad_adminMenu.asp` | メイン処理（非常にシンプル） |

**主要処理フロー**:
1. **行2**: 中央揃えの段落開始
2. **行2**: getArtLinkで各リンクを生成
3. **行5**: 段落終了

#### Step 3: リンク先画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ad_clientList.asp | `asp/ad_clientList.asp` | 顧客一覧画面 |
| 3-2 | ad_client.asp | `asp/ad_client.asp` | 顧客詳細・登録画面 |
| 3-3 | ad_clientproducts.asp | `asp/ad_clientproducts.asp` | 製品一覧画面 |
| 3-4 | ad_clientproduct.asp | `asp/ad_clientproduct.asp` | 製品詳細・登録画面 |

### プログラム呼び出し階層図

```
ad_adminMenu.asp
    |
    +-- getArtLink("ad_clientList.asp","Customers","","","")
    |       |
    |       +-- Artisteerスタイルのリンクタグ生成
    |
    +-- getArtLink("ad_client.asp","New Customer","","","")
    |
    +-- getArtLink("ad_clientproducts.asp","Products/Services","","","")
    |
    +-- getArtLink("ad_clientproduct.asp","Add Product/Service","","","")
```

### データフロー図

```
[入力]                      [処理]                          [出力]

なし                    getArtLink関数               HTMLリンク
                              |                           |
                              v                           v
                       リンクタグ生成 ---------> <p align="center">
                                                   リンク1
                                                   リンク2
                                                   リンク3
                                                   リンク4
                                                 </p>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_adminMenu.asp | `asp/ad_adminMenu.asp` | ソース | メニュー表示ファイル |
| artisteer.asp | `asp/includes/artisteer.asp` | インクルード | getArtLink関数定義 |
| ad_clientList.asp | `asp/ad_clientList.asp` | 遷移先 | 顧客一覧画面 |
| ad_client.asp | `asp/ad_client.asp` | 遷移先 | 顧客詳細・登録画面 |
| ad_clientproducts.asp | `asp/ad_clientproducts.asp` | 遷移先 | 製品一覧画面 |
| ad_clientproduct.asp | `asp/ad_clientproduct.asp` | 遷移先 | 製品登録画面 |
