# 画面設計書 158-トップページ

## 概要

本ドキュメントは、QuickerSite CMSのフロントエンドトップページ（default.asp）の設計書です。この画面は、サイト訪問者が最初にアクセスする公開サイトのエントリーポイントであり、CMSで管理されたコンテンツを動的にレンダリングして表示します。

### 本画面の処理概要

この画面は、QuickerSite CMSのメインエントリーポイントとして、リクエストに応じて適切なページコンテンツを表示します。URLパラメータやユーザーフレンドリーURLを解析し、対応するページをデータベースから取得してテンプレートに基づいてレンダリングします。ログイン処理、検索、フォーム送信など様々なアクションにも対応します。

**業務上の目的・背景**：QuickerSite CMSで構築されたWebサイトの公開画面の中核となるファイルです。サイト訪問者は全てこのファイルを経由してコンテンツにアクセスします。CMS管理者がバックサイトで設定したページ、テンプレート、コンテンツを組み合わせて最終的なHTMLを生成し、訪問者に提供します。

**画面へのアクセス方法**：
- 直接アクセス: `default.asp` または `default.asp?iId={暗号化されたページID}`
- ユーザーフレンドリーURL経由: `/ページ名` 形式（URL書き換え設定時）

**主要な操作・処理内容**：
1. 初期化処理（begin.asp）
2. ページID解析とページオブジェクト取得
3. 各種アクション分岐（login, search, send, sitemap, vote等）
4. ページコンテンツの取得と組み立て
5. テンプレートに基づくレンダリング
6. 訪問ログ記録
7. HTML出力

**画面遷移**：
- 遷移元: 外部リンク、検索エンジン、他のサイトページ
- 遷移先: 各種コンテンツページ、ログイン画面、検索結果、サイトマップ等

**権限による表示制御**：
- 一般公開ページ: 認証不要
- パスワード保護ページ: パスワード認証必要
- イントラネットページ: 会員認証必要
- オフラインページ: 管理者認証時のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 99 | ページ表示 | 主機能 | サイトトップページのレンダリング・表示 |
| 115 | XMLサイトマップ出力 | 補助機能 | SEO対策のサイトマップへのリンク |

## 画面種別

フロントエンドエントリーポイント（動的コンテンツ表示）

## URL/ルーティング

- メインエントリー: `default.asp`
- パラメータ付き: `default.asp?iId={暗号化されたページID}`
- アクション指定: `default.asp?pageAction={アクション名}&iId={ページID}`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|----|----|-----|
| iId | 入力（URLパラメータ） | 文字列 | いいえ | 暗号化されたページID |
| sCode | 入力（URLパラメータ） | 文字列 | いいえ | ページコード |
| pageAction | 入力（URLパラメータ） | 文字列 | いいえ | 実行するアクション |
| HTML | 出力 | テキスト | - | レンダリングされたHTMLページ |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| ページタイトル | 選択されたページのタイトル |
| ページコンテンツ | 選択されたページの本文 |
| フォーム | ページに関連付けられたフォーム |
| カタログ | ページに関連付けられたカタログ |
| フィード | ページに関連付けられたRSSフィード |
| リストページ | リスト形式のコンテンツ |
| テーマ | フォーラム/掲示板コンテンツ |

## イベント仕様

### 1-ページ読み込み時（通常）

1. `begin.asp` のインクルードで初期化
2. `execBeforePageLoad` カスタム処理実行
3. `process.asp` でメイン処理実行
4. ページIDまたはユーザーフレンドリーURLからページ取得
5. 認証チェック（必要な場合）
6. テンプレートに基づくHTML生成

### 2-pageAction別処理

| pageAction | 処理内容 | インクルードファイル |
|------------|---------|-------------------|
| login | ログイン処理 | process_login.asp |
| search | 検索処理 | process_search.asp |
| send | メール送信処理 | process_send.asp |
| sitemap | サイトマップ表示 | process_sitemap.asp |
| vote | 投票処理 | - |
| showitem | アイテム詳細表示 | process_showitem.asp |
| showpost | 投稿詳細表示 | process_showpost.asp |
| unsubscribe | 購読解除 | process_unsubscribe.asp |
| register | 会員登録 | process_register.asp |
| profile | プロフィール編集 | process_profile.asp |
| forgotPW | パスワード忘れ | process_forgotPW.asp |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | tblPage | SELECT | ページ情報取得 |
| ページ表示 | tblCustomer | SELECT | 顧客（サイト）設定取得 |
| 訪問記録 | tblVisit | INSERT | 訪問ログ記録 |
| ページ表示 | tblHits | UPDATE | ヒットカウンター更新 |

### テーブル別更新項目詳細

#### tblPage（読み取り）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, sValue, bOnline, iTemplateID, iFormID 等 | iId条件またはsUserFriendlyURL条件 | ページ情報取得 |

#### tblVisit（挿入）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iPageID, dVisitTS, sIP, sUserAgent 等 | ページ訪問時 | アクセスログ |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 警告（JavaScript） | 'This page is offline...' | オフラインページを管理者が閲覧時 |
| エラー | 404エラーページ | ページが見つからない場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ページが存在しない | ホームページにリダイレクトまたは404ページ表示 |
| パスワード保護ページへの未認証アクセス | ログイン画面にリダイレクト |
| イントラネットページへの未認証アクセス | イントラネットログイン画面にリダイレクト |
| 外部URLページ | 外部URLにリダイレクト |
| コンテナページ | 最初の子ページに自動遷移 |

## 備考

- サイト全体のエントリーポイントとなる重要なファイル
- `process.asp` で多くのロジックが処理される
- テンプレートエンジンにより、管理画面で設定したデザインが適用される
- 多様なコンテンツタイプ（標準ページ、リストページ、カタログ、フォーム等）に対応
- SEO対策として、ユーザーフレンドリーURLをサポート
- モバイルブラウザ検出機能あり

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページオブジェクトとカスタマーオブジェクトの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスの構造 |
| 1-2 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスの構造 |
| 1-3 | template.asp | `asp/includes/template.asp` | テンプレートクラスの構造 |

**読解のコツ**: ページはテンプレートと関連付けられ、テンプレートがHTMLの外枠を提供します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | default.asp | `default.asp` | エントリーポイント（3行のみ） |
| 2-2 | begin.asp | `asp/begin.asp` | 初期化処理（204行） |
| 2-3 | process.asp | `asp/process.asp` | メインロジック（290行） |

**主要処理フロー**:
1. **default.asp 行1**: begin.aspインクルード
2. **default.asp 行2**: execBeforePageLoad実行
3. **default.asp 行3**: process.aspインクルード
4. **process.asp 行10-12**: ユーザーフレンドリーURLチェック
5. **process.asp 行40-167**: pageAction分岐
6. **process.asp 行279**: テンプレートビルド

#### Step 3: pageAction別処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_login.asp | `asp/process_login.asp` | ログイン処理 |
| 3-2 | process_search.asp | `asp/process_search.asp` | 検索処理 |
| 3-3 | process_listpage.asp | `asp/process_listpage.asp` | リストページ処理 |
| 3-4 | process_catalog.asp | `asp/process_catalog.asp` | カタログ処理 |

### プログラム呼び出し階層図

```
default.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- customer.asp (顧客設定読み込み)
    |       +-- page.asp (ページクラス定義)
    |       +-- template.asp (テンプレートクラス定義)
    |       +-- その他100以上のインクルード
    |
    +-- run(execBeforePageLoad) (カスタム前処理)
    |
    +-- process.asp (メインロジック)
            |
            +-- selectedPage.pickByUserFriendlyURL()
            |
            +-- pageAction分岐
            |       |
            |       +-- process_login.asp
            |       +-- process_search.asp
            |       +-- process_send.asp
            |       +-- process_sitemap.asp
            |       +-- process_register.asp
            |       +-- process_profile.asp
            |       +-- process_listpage.asp
            |       +-- process_catalog.asp
            |       +-- その他
            |
            +-- selectedPage.AddHit()
            +-- selectedPage.addVisit()
            +-- selectedPage.buildTemplate()
```

### データフロー図

```
[入力]                      [処理]                          [出力]

HTTPリクエスト            begin.asp                      HTMLページ
(iId, pageAction等)           |                              |
      |                       v                              v
      +-------> selectedPage.pick() --------> pageAction分岐
                      |                            |
                      v                            v
               ページデータ取得          各種process_*.asp
                      |                            |
                      v                            v
               テンプレート取得 --------> buildTemplate()
                                                   |
                                                   v
                                            HTML生成・出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| default.asp | `default.asp` | ソース | エントリーポイント |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| process.asp | `asp/process.asp` | インクルード | メインロジック |
| page.asp | `asp/includes/page.asp` | インクルード | ページクラス定義 |
| customer.asp | `asp/includes/customer.asp` | インクルード | 顧客クラス定義 |
| template.asp | `asp/includes/template.asp` | インクルード | テンプレートクラス定義 |
| process_login.asp | `asp/process_login.asp` | インクルード | ログイン処理 |
| process_search.asp | `asp/process_search.asp` | インクルード | 検索処理 |
| process_listpage.asp | `asp/process_listpage.asp` | インクルード | リストページ処理 |
| process_catalog.asp | `asp/process_catalog.asp` | インクルード | カタログ処理 |
