# 画面設計書 159-インデックス

## 概要

本ドキュメントは、QuickerSite CMSのインデックスページ（index.asp）の設計書です。この画面は、default.aspへのリダイレクトを行うシンプルなエントリーポイントです。

### 本画面の処理概要

この画面は、`index.asp` へのアクセスを `default.asp` にリダイレクトするためのラッパーファイルです。IISの既定ドキュメント設定で `index.asp` が指定されている環境でも、QuickerSiteのメインエントリーポイントである `default.asp` の処理が実行されるようにします。

**業務上の目的・背景**：Webサーバーの設定によっては、既定ドキュメントとして `index.asp` が優先される場合があります。このファイルは、そのような環境でも正しくサイトが表示されるよう、`default.asp` をインクルードすることで同一の処理を保証します。これにより、URLが `http://example.com/index.asp` でも `http://example.com/default.asp` でも同じコンテンツが表示されます。

**画面へのアクセス方法**：
- 直接アクセス: `index.asp`
- IIS既定ドキュメント経由: `/` （index.aspが既定ドキュメントの場合）

**主要な操作・処理内容**：
1. default.aspをインクルード（処理委譲）

**画面遷移**：
- 遷移元: 外部リンク、直接URL入力
- 遷移先: なし（default.aspと同一処理）

**権限による表示制御**：default.aspに委譲されるため、default.aspの権限制御が適用されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 99 | ページ表示 | 主機能 | サイトインデックスへのリダイレクト処理 |

## 画面種別

リダイレクト（インクルードによる処理委譲）

## URL/ルーティング

`index.asp`

## 入出力項目

default.aspと同一のため、default.aspの設計書を参照してください。

## 表示項目

default.aspと同一のため、default.aspの設計書を参照してください。

## イベント仕様

### 1-ページ読み込み時

1. default.aspをインクルード
2. 以降はdefault.aspの処理フローと同一

## データベース更新仕様

default.aspと同一のため、default.aspの設計書を参照してください。

## メッセージ仕様

default.aspと同一のため、default.aspの設計書を参照してください。

## 例外処理

default.aspと同一のため、default.aspの設計書を参照してください。

## 備考

- ファイル内容は1行のみ: `<!-- #include file="default.asp"-->`
- default.aspと完全に同一の処理を実行
- IISの既定ドキュメント設定への対応
- SEO的には重複コンテンツとなる可能性があるため、カノニカルURL設定が推奨
- URL正規化のためのリダイレクト設定（301）の検討も必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ファイル内容を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.asp | `index.asp` | 1行のみ（default.aspインクルード） |

**読解のコツ**: このファイルは単純なインクルードディレクティブのみで、実際の処理はdefault.aspで行われます。

#### Step 2: インクルード先を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | default.asp | `default.asp` | 実際のエントリーポイント |

**主要処理フロー**:
1. **index.asp 行1**: `<!-- #include file="default.asp"-->`
2. 以降はdefault.aspと同一

### プログラム呼び出し階層図

```
index.asp
    |
    +-- default.asp (インクルード)
            |
            +-- begin.asp (初期化)
            +-- run(execBeforePageLoad)
            +-- process.asp (メインロジック)
```

### データフロー図

```
[入力]                      [処理]                          [出力]

HTTPリクエスト            インクルード                    HTMLページ
(/index.asp)                  |                              |
      |                       v                              v
      +-------> default.asp処理 ---------> (default.aspと同一)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.asp | `index.asp` | ソース | インデックスページ（ラッパー） |
| default.asp | `default.asp` | ソース | 実際のエントリーポイント |
