# 画面設計書 16-ページ選択画面

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「ページ選択画面」の設計仕様を定義するものである。

### 本画面の処理概要

ページ選択画面は、ページの移動先を選択するための画面である。サイトのページ階層構造（ツリー）を表示し、移動対象ページを挿入する位置を選択することができる。選択された位置の子ページとしてページが移動される。

**業務上の目的・背景**：
サイト構造の変更時に、既存のページを別の親ページの配下に移動する必要がある。本画面は、視覚的なツリー構造を表示し、移動先を直感的に選択できるインターフェースを提供する。これにより、サイト管理者はドラッグ&ドロップに頼らず、明確な選択操作でページ移動を実行できる。

**画面へのアクセス方法**：
1. バックサイトにログイン後、移動対象のページを選択
2. ページ編集画面から「移動」アクションを実行
3. またはbs_process.aspのMoveアクションからリダイレクト
4. URLパラメータとして暗号化されたページID（iId）が渡される

**主要な操作・処理内容**：
1. 移動対象ページの情報を表示
2. サイトのページツリー構造を表示
3. 挿入位置の親ページを選択（アイコンクリック）
4. 確認ダイアログ後、ページ移動を実行
5. メインアイテム化（トップレベルへの移動）のリンク表示

**画面遷移**：
- 遷移元: bs_process.aspのMoveアクション（各編集画面から）
- 遷移先: バックサイトホーム（bs_default.asp）、イントラネット管理（bs_intranet.asp）

**権限による表示制御**：
secondAdmin.bPagesMoveがfalseの場合、画面へのアクセスが拒否される（logon.hasaccess関数による制御）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ページ移動・並び替え | 主機能 | ページ移動先の選択（ツリー表示） |

## 画面種別

選択画面（ツリー表示）

## URL/ルーティング

```
asp/bs_selectPage.asp?iId={暗号化されたページID}&btnaction=selectPage
```

または

```
asp/bs_selectPage.asp?iId={暗号化されたページID}&btnaction=Insert&insertInto={暗号化された移動先親ページID}
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| iId | 入力（URL） | String | Yes | 暗号化された移動対象ページID |
| btnaction | 入力（URL） | String | Yes | アクション種別（selectPage/Insert） |
| insertInto | 入力（URL） | String | No | 暗号化された移動先親ページID |
| QS_secCodeURL | 入力（URL） | String | Yes | CSRF対策トークン（URL用） |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| 移動対象ページ名 | テキスト | 移動するページのタイトル |
| 挿入アイコン | アイコンリンク | 各親ページへの挿入操作アイコン |
| ページツリー | 階層表示 | サイトのページ構造（cls_menuで生成） |
| メインアイテム化リンク | リンク | トップレベルへの移動リンク |

## イベント仕様

### 1-挿入アイコンクリック

1. getIcon()関数で生成されたアイコンリンクをクリック
2. insertItem() JavaScript関数が呼び出される
3. confirm()で「このアイテムを移動しますか？」確認ダイアログ表示
4. OKでリンク先（bs_selectPage.asp?btnaction=Insert&...）に遷移
5. キャンセルで処理中止

### 2-Insert アクション実行（bs_process.asp）

1. checkCSRF()でCSRFトークン検証
2. page.parentPage.removeRang(page)で元の親から並び順を除去
3. page.iParentID = decrypt(insertInto)で新しい親ページを設定
4. page.bLossePagina = false でフリーページフラグを解除
5. 親ページが非公開なら、移動ページも非公開に設定
6. page.iRang = getRang + 1 で新しい並び順を設定
7. 親ページにパスワードがあれば、移動ページにも適用
8. page.save()で保存
9. バックサイトホームまたはイントラネット管理にリダイレクト

### 3-メインアイテム化リンククリック

1. 親ページなし（トップレベル）での再表示
2. iParentIDなしでページを保存
3. 結果としてページがメニューのトップレベルに移動

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Insert実行 | tblPage | UPDATE | 移動対象ページの親IDと並び順を更新 |
| Insert実行 | tblPage | UPDATE | 元の親の子ページの並び順を再計算 |
| Insert実行 | tblPage | UPDATE | パスワード継承（必要な場合） |

### テーブル別更新項目詳細

#### tblPage（移動対象ページ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iParentID | decrypt(insertInto)の値 | 新しい親ページID |
| UPDATE | bLossePagina | false | フリーページフラグ解除 |
| UPDATE | bOnline | 親ページのbOnline値（非公開時） | 親に従う |
| UPDATE | iRang | getRang + 1 | 新しい並び順 |
| UPDATE | sPw | 親ページのsPw値（設定時） | パスワード継承 |
| UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| suretomoveitem | 確認 | 挿入アイコン押下時 | このアイテムを移動しますか？ |
| click | 説明 | 画面表示時 | クリックして... |
| toinsertitem | 説明 | 画面表示時 | ...アイテムを挿入 |
| newmainitem | 説明 | メインアイテム化リンク | 新しいメインアイテムにする |
| makemainitemof | 説明 | メインアイテム化リンク | ...のメインアイテムにする |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | logon.hasaccess(secondAdmin.bPagesMove)でアクセス拒否 |
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| CSRFトークン不正 | checkCSRF()でエラー処理 |

## 備考

- cls_menuクラスのgetReplaceMenu()メソッドでツリー表示を生成
- menu.bOnline = false で非公開ページも表示対象に含める
- フリーページ（bLossePagina=true）からの移動時は、フラグがfalseにリセットされる
- 親ページのパスワード設定は子ページに継承される
- イントラネットページの場合、bs_backIntranet.aspで追加のナビゲーションを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面構成を理解する

ページ選択画面の表示内容を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_selectPage.asp | `asp/bs_selectPage.asp` | 画面構成、ツリー表示、JavaScript |

**読解のコツ**: cls_menuクラスのgetReplaceMenu()メソッドがツリー構造を生成している点に注目。

#### Step 2: ツリー表示を理解する

メニュー/ツリー表示の仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_selectPage.asp | `asp/bs_selectPage.asp` | cls_menu初期化とgetReplaceMenu呼び出し（行5-8） |

**主要処理フロー**:
1. **行4-5**: ページの子ページリストを取得
2. **行5-8**: cls_menuオブジェクト生成とツリー表示

#### Step 3: 移動処理を理解する

ページ移動の実際の処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | Insertアクション（行41-64） |

**主要処理フロー**:
1. **行41-42**: checkCSRF()とページID確認
2. **行44-46**: 元の親ページからの除去
3. **行47-52**: 新しい親ページの設定と公開状態同期
4. **行53-58**: パスワード継承処理
5. **行59-64**: 保存とリダイレクト

#### Step 4: JavaScript処理を理解する

確認ダイアログの仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_selectPage.asp | `asp/bs_selectPage.asp` | insertItem()関数（行10-19） |

### プログラム呼び出し階層図

```
bs_selectPage.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bPagesMove)
    │
    ├─ bs_process.asp（共通処理）
    │
    ├─ cls_page.pick()（ページデータ取得）
    │      └─ subPages()で子ページリスト取得
    │
    ├─ cls_menu.getReplaceMenu()（ツリー表示生成）
    │      └─ 各ページに挿入アイコンを付与
    │
    └─ [挿入アイコンクリック時]
           │
           ├─ JavaScript insertItem()
           │      └─ confirm()で確認
           │
           └─ [OK時] bs_selectPage.asp?btnaction=Insert へ遷移
                  │
                  └─ bs_process.asp (Insert処理)
                         ├─ checkCSRF()
                         ├─ page.parentPage.removeRang()
                         ├─ page.iParentID設定
                         ├─ page.bOnline同期
                         ├─ page.iRang設定
                         ├─ page.sPw継承
                         ├─ page.save()
                         └─ response.redirect()
```

### データフロー図

```
[入力]                      [処理]                      [出力]

URLパラメータ(iId) ─────────▶ decrypt() ─────────────▶ 移動対象ページ取得
                                  │
                                  ▼
                            cls_page.pick()
                                  │
                                  ▼
                            subPages() ──────────────▶ 子ページリスト
                                  │
                                  ▼
                            cls_menu.getReplaceMenu() ─▶ ツリー表示
                                  │
挿入アイコンクリック ────────────▶ insertItem()
                                  │
                                  ▼
                            confirm()
                                  │
                            ┌─────┴─────┐
                          [OK]       [Cancel]
                            │
                            ▼
insertInto(親ページID) ─────▶ bs_process.asp
                                  │
                                  ├─ 元親から除去
                                  │
                                  ├─ 新親に設定
                                  │
                                  ├─ 並び順設定
                                  │
                                  └─ page.save() ────────▶ tblPage UPDATE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_selectPage.asp | `asp/bs_selectPage.asp` | ソース | メイン画面処理 |
| bs_process.asp | `asp/bs_process.asp` | インクルード | Insert処理実行 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| menu.asp | `asp/includes/menu.asp` | インクルード | cls_menuクラス（推定） |
| bs_backIntranet.asp | `asp/bs_backIntranet.asp` | インクルード | イントラネット用ナビ |
