# 画面設計書 160-メールページ

## 概要

本ドキュメントは、QuickerSite CMSのメールページ（mailPage.asp）の設計書です。この画面は、サイト訪問者がページコンテンツを指定したメールアドレスに送信（シェア）するための機能を提供します。

### 本画面の処理概要

この画面は、現在表示しているページの内容をメールで送信する「ページシェア」機能を提供します。訪問者がメールアドレスを入力し、CAPTCHA認証を通過すると、ページのタイトルと本文がメールとして送信されます。SNSシェアの代替として、メールでコンテンツを共有したい場合に使用します。

**業務上の目的・背景**：Webサイトのコンテンツを友人や同僚と共有したい場合、メールでの送信は依然として有効な手段です。この機能により、訪問者は興味のあるページをワンクリックでメール送信フォームにアクセスし、簡単にコンテンツを共有できます。CAPTCHA認証によりスパム送信を防止しています。

**画面へのアクセス方法**：
- ページ内のメール送信アイコン/リンクをクリック
- URL: `mailPage.asp?iId={暗号化されたページID}`

**主要な操作・処理内容**：
1. 対象ページのコンテンツ取得
2. メールアドレス入力フォーム表示
3. CAPTCHA認証
4. メール送信処理
5. 送信完了メッセージ表示

**画面遷移**：
- 遷移元: 各コンテンツページ（メール送信リンク）
- 遷移先: 送信完了後、ウィンドウクローズ

**権限による表示制御**：一般公開機能のため、特別な認証は不要です。ただし、CAPTCHA認証は必須です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 112 | ページメール送信 | 主機能 | ページ内容を指定メールアドレスに送信 |

## 画面種別

機能画面（フォーム入力・処理実行）

## URL/ルーティング

`mailPage.asp?iId={暗号化されたページID}`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|----|----|-----|
| iId | 入力（URLパラメータ） | 文字列 | はい | 暗号化されたページID |
| sEmail | 入力（フォーム） | メールアドレス | はい | 送信先メールアドレス |
| captcha | 入力（フォーム） | 文字列 | はい | CAPTCHA認証コード（4文字） |
| btnAction | 入力（hidden） | 文字列 | はい | "sendPage"固定 |
| 送信完了メッセージ | 出力 | テキスト | - | 送信成功時のメッセージ |

## 表示項目

### 入力フォーム表示時

| 表示項目 | 説明 |
|----------|------|
| ページタイトル | 送信対象ページのタイトル |
| 案内メッセージ | "The page 'xxx' will be sent" |
| メールアドレス入力欄 | 送信先メールアドレス |
| CAPTCHA画像 | スパム防止用認証画像 |
| CAPTCHA入力欄 | 認証コード入力 |
| 送信ボタン | メール送信実行 |

### 送信完了表示時

| 表示項目 | 説明 |
|----------|------|
| 完了メッセージ | "Page is sent" |
| 閉じるボタン | ウィンドウクローズ |

## イベント仕様

### 1-ページ読み込み時（初回）

1. begin.aspのインクルード（初期化）
2. process.aspのインクルード（ページ取得）
3. メールアドレス入力フォームを表示
4. 前回入力したメールアドレスをセッションから復元

### 2-送信ボタンクリック時

1. CSRFトークン検証（checkCSRF関数）
2. CAPTCHA認証チェック
3. メールアドレス構文チェック
4. バリデーションエラー時: エラーメッセージ表示
5. バリデーション成功時:
   a. メール本文構築（HTMLメール）
   b. cls_mail_messageオブジェクトでメール送信
   c. 送信完了画面表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | tblPage | SELECT | 対象ページ情報取得 |

### テーブル別更新項目詳細

#### tblPage（読み取りのみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, sValue 等 | iId条件 | ページ情報取得 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | `pageIsSent`（ラベル） | メール送信成功時 |
| エラー | `err_captcha`（ラベル） | CAPTCHA認証失敗時 |
| エラー | `err_email`（ラベル） | メールアドレス不正時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| CAPTCHA認証失敗 | エラーメッセージ表示、フォーム再表示 |
| メールアドレス不正 | エラーメッセージ表示、フォーム再表示 |
| アプリケーション指定ページ | Response.End（処理中断） |

## 備考

- ポップアップウィンドウとして表示されることを想定（`window.close()`使用）
- HTMLメール形式で送信
- CSSスタイルもメール本文に含める
- CAPTCHA画像は `includes/captcha.asp` で生成
- CSRFトークンによるセキュリティ対策実装
- セッションにメールアドレスを保存し、次回入力を省略可能
- `pagetoemailbody` 変数によるカスタムメール本文対応
- 多言語対応（l関数によるラベル取得）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メール送信に使用するクラスとページオブジェクトの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mail_message.asp | `asp/includes/mail_message.asp` | cls_mail_messageクラスの構造 |
| 1-2 | page.asp | `asp/includes/page.asp` | selectedPageオブジェクトの構造 |

**読解のコツ**: `cls_mail_message` クラスはCDONTSまたはCDO.Messageを使用してメール送信を行います。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mailPage.asp | `mailPage.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **行1**: begin.aspインクルード
2. **行2-3**: printReplies=true, pagetoemail=true 設定
3. **行3**: process.aspインクルード
4. **行11**: sApplication チェック（アプリケーションページは除外）
5. **行17-50**: メール送信処理
6. **行51**: 結果表示（送信完了/フォーム）

#### Step 3: バリデーション処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mailPage.asp | `mailPage.asp` 行19-27 | CSRFとCAPTCHA検証 |
| 3-2 | functions.asp | `asp/includes/functions.asp` | CheckEmailSyntax関数 |

**バリデーションフロー**:
1. **行19**: `checkCSRF()` - CSRFトークン検証
2. **行22**: セッション`CAPTCHA`と入力値の比較
3. **行25**: `CheckEmailSyntax()` - メールアドレス形式チェック

### プログラム呼び出し階層図

```
mailPage.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- includes/mail_message.asp (メールクラス)
    |       +-- includes/functions.asp (バリデーション関数)
    |       +-- その他多数のインクルード
    |
    +-- process.asp (ページ取得)
    |       |
    |       +-- selectedPage.pick()
    |
    +-- フォーム送信時
            |
            +-- checkCSRF() (CSRF検証)
            +-- CAPTCHA検証
            +-- CheckEmailSyntax() (メール形式チェック)
            +-- cls_mail_message (メール送信)
                    |
                    +-- CDO.Message または CDONTS
```

### データフロー図

```
[入力]                      [処理]                          [出力]

iId (ページID)           ページ取得                   HTML (フォーム/完了)
      |                       |                              |
      v                       v                              v
process.asp --------> selectedPage --------> フォーム表示
                                                   |
sEmail, CAPTCHA         バリデーション             v
      |                       |              送信ボタンクリック
      v                       v                    |
checkCSRF() --------> CAPTCHA検証                  v
                           |              メール本文構築
                           v                    |
              CheckEmailSyntax() --------> cls_mail_message.send()
                                                   |
                                                   v
                                            送信完了表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mailPage.asp | `mailPage.asp` | ソース | メイン処理ファイル |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| process.asp | `asp/process.asp` | インクルード | ページ取得処理 |
| mail_message.asp | `asp/includes/mail_message.asp` | インクルード | メール送信クラス |
| captcha.asp | `asp/includes/captcha.asp` | インクルード | CAPTCHA画像生成 |
| functions.asp | `asp/includes/functions.asp` | インクルード | バリデーション関数 |
| messages.asp | `asp/includes/messages.asp` | インクルード | メッセージ表示クラス |
| css.asp | `asp/includes/css.asp` | インクルード | CSSスタイル取得 |
