# 画面設計書 161-印刷ページ

## 概要

本ドキュメントは、QuickerSite CMSにおける印刷ページ（printPage.asp）の画面設計書である。この画面は、公開サイトのページコンテンツを印刷用のシンプルなレイアウトで表示する機能を提供する。

### 本画面の処理概要

印刷ページ画面は、CMSで管理されているページコンテンツを印刷に適した形式で表示し、ユーザーがWebページの内容を紙媒体に出力できるようにする機能である。

**業務上の目的・背景**：Webサイトの訪問者がページ内容を印刷して保存・配布したいというニーズに対応するため、この画面が提供される。通常のページ表示ではナビゲーションメニュー、サイドバー、広告などの余分な要素が含まれるが、印刷ページではコンテンツのみを簡潔に表示し、紙資源の節約と可読性の向上を実現する。また、印刷時のレイアウト崩れを防ぎ、ユーザビリティを向上させることも目的としている。

**画面へのアクセス方法**：公開サイトのページに設置された「印刷」アイコンまたはリンクをクリックすることでアクセスする。URLは `printPage.asp?iId={暗号化されたページID}` の形式となる。

**主要な操作・処理内容**：
1. ページIDに基づいてデータベースからページコンテンツを取得
2. テンプレートを適用せず、シンプルなHTMLレイアウトでコンテンツを表示
3. ページタイトルと本文（ブロック置換済み）を出力
4. ページ読み込み完了時に自動的にブラウザの印刷ダイアログを表示

**画面遷移**：
- 遷移元：公開サイトの各ページ（default.asp）から印刷アイコン/リンク経由
- 遷移先：なし（印刷後はブラウザの戻るボタンまたはウィンドウを閉じる）

**権限による表示制御**：
- パスワード保護されたページの場合、認証済みの場合のみ印刷ページにアクセス可能
- イントラネットページの場合、イントラネット認証が必要
- 特定のアプリケーション（sApplication）が設定されているページは印刷表示を中止

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 113 | ページ印刷 | 主機能 | 印刷用レイアウトでのページ表示 |
| 99 | ページ表示 | 補助機能 | ページコンテンツの取得・表示 |

## 画面種別

表示（印刷プレビュー）

## URL/ルーティング

```
/printPage.asp?iId={暗号化されたページID}
```

## 入出力項目

### 入力項目（リクエストパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ページID | iId | String | 必須 | 暗号化されたページID |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 選択されたページのタイトル（定数置換処理済み） |
| ページ本文 | 選択されたページの本文コンテンツ（ブロック置換・定数置換処理済み） |

## 表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| タイトル | 太字テキスト | ページタイトルを太字で表示 |
| 区切り線 | hr要素 | タイトルと本文の間の区切り |
| 本文 | HTML | ページの本文コンテンツ |

## イベント仕様

### 1-ページ読み込み完了

**トリガー**: ページのDOMが完全に読み込まれた時点

**処理内容**:
1. JavaScriptの `window.focus()` でウィンドウにフォーカスを当てる
2. JavaScriptの `window.print()` でブラウザの印刷ダイアログを自動的に開く

**画面遷移**: なし（印刷ダイアログ表示のみ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | tblPage | SELECT | ページコンテンツの取得 |
| ページ表示 | tblCustomer | SELECT | 顧客情報（文字コード等）の取得 |

### テーブル別更新項目詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | iId, sTitle, sValue, sApplication | iId = 復号化したページID AND iCustomerID = 現在の顧客ID | ページ基本情報 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| - | - | 本画面では特にメッセージ表示なし |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| ページが見つからない | begin.aspでホームページにリダイレクト |
| アプリケーション指定ページ | Response.Endで処理を中止（8行目） |
| 認証が必要なページ | process.aspでログイン画面にリダイレクト |

## 備考

- 印刷ページはポップアップウィンドウとして開くことを想定
- CSSファイル（qs_ltr.cssまたはqs_rtl.css）でテキスト方向に対応
- sorttable.jsはテーブルソート用だが印刷時には機能しない
- `printReplies=true` の設定により、テンプレートを経由せず直接HTMLを出力

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページデータの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスの構造、sTitle/sValueプロパティ |
| 1-2 | customer.asp | `asp/includes/customer.asp` | cls_customerクラス、文字コード設定 |

**読解のコツ**: VBScriptのクラス定義では、Public/Privateでアクセス修飾子を指定し、Property Get/Letでプロパティを定義する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printPage.asp | `printPage.asp` | メインファイル、インクルード順序、HTML出力構造 |

**主要処理フロー**:
1. **1行目**: begin.aspをインクルードし、初期化処理実行
2. **1行目**: `printReplies=true` を設定し、テンプレート非使用モードに
3. **1行目**: process.aspをインクルードし、ページデータ取得
4. **9-12行目**: body要素のonloadで印刷ダイアログを呼び出し
5. **11行目**: ページタイトルと本文をHTMLに出力

#### Step 3: 初期化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | begin.asp | `asp/begin.asp` | セッション設定、定数定義、各種クラスのインクルード |
| 3-2 | process.asp | `asp/process.asp` | ページ選択、認証チェック、本文取得処理 |

**主要処理フロー**:
- **begin.asp 151-155行**: customerオブジェクトの初期化とpick処理
- **begin.asp 192-196行**: selectedPageオブジェクトの初期化とpick処理
- **process.asp 278-284行**: printRepliesフラグに基づくテンプレート処理分岐

#### Step 4: コンテンツ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | insertConstants.asp | `asp/includes/insertConstants.asp` | treatConstants関数、定数置換処理 |
| 4-2 | page.asp | `asp/includes/page.asp` | replaceBlocks関数、ブロック置換処理 |

**主要処理フロー**:
- `treatConstants(selectedPage.replaceBlocks(pageTitle),true)`: 定数とブロックの両方を置換
- `treatConstants(selectedPage.replaceBlocks(pageBody),true)`: 本文も同様に処理

### プログラム呼び出し階層図

```
printPage.asp
    |
    +-- begin.asp (初期化)
    |       |
    |       +-- config/rebrand.asp
    |       +-- config/web_config.asp
    |       +-- includes/*.asp (各種クラス定義)
    |       +-- customer.pick() (顧客データ読込)
    |       +-- selectedPage.pick() (ページデータ読込)
    |
    +-- process.asp (ページ処理)
    |       |
    |       +-- selectedPage.AddHit() (アクセス数更新)
    |       +-- selectedPage.addVisit() (訪問数更新)
    |       +-- (printReplies=trueのため、buildTemplate()はスキップ)
    |
    +-- selectedPage.replaceBlocks() (ブロック置換)
    +-- treatConstants() (定数置換)
    +-- cleanUPASP() (後処理)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request.iId ──────▶ decrypt() ──────▶ ページID
                            |
                            ▼
                    selectedPage.pick()
                            |
                            ▼
                    tblPage (DB参照)
                            |
                            ▼
                    sTitle, sValue 取得
                            |
                            ▼
                    replaceBlocks()
                            |
                            ▼
                    treatConstants()
                            |
                            ▼
                                              ──────▶ HTML出力（印刷用）
                                                        |
                                                        ▼
                                                  window.print()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printPage.asp | `printPage.asp` | ソース | メインエントリーポイント |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理、インクルードファイル群の読込 |
| process.asp | `asp/process.asp` | ソース | ページ処理のメインロジック |
| page.asp | `asp/includes/page.asp` | ソース | cls_pageクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | cls_customerクラス定義 |
| insertConstants.asp | `asp/includes/insertConstants.asp` | ソース | treatConstants関数 |
| encryption.asp | `asp/includes/encryption.asp` | ソース | encrypt/decrypt関数 |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通ユーティリティ関数 |
| qs_ltr.css | `quickersite/css/qs_ltr.css` | CSS | 左から右（LTR）テキスト用スタイル |
| qs_rtl.css | `quickersite/css/qs_rtl.css` | CSS | 右から左（RTL）テキスト用スタイル |
| sorttable.js | `quickersite/js/sorttable.js` | JS | テーブルソート機能（印刷時は不使用） |
