# 画面設計書 162-RSS

## 概要

本ドキュメントは、QuickerSite CMSにおけるRSSフィード生成画面（rss.asp）の画面設計書である。この画面は、サイトやページのコンテンツをRSS 2.0形式のXMLフィードとして出力する機能を提供する。

### 本画面の処理概要

RSS画面は、CMSで管理されているコンテンツをRSS 2.0形式のXMLフィードとして生成・出力する機能を提供する。これにより、RSSリーダーやフィードアグリゲーターを使用するユーザーが、サイトの更新情報を購読できるようになる。

**業務上の目的・背景**：現代のWebサイトでは、コンテンツ更新情報をRSSフィードで配信することが標準的な機能となっている。ユーザーはRSSリーダーを使用して複数のサイトの更新情報を効率的に追跡でき、サイト運営者は訪問者のリピート率向上とエンゲージメント強化を図ることができる。QuickerSiteでは、サイト全体のRSSフィード、個別ページのリストアイテム、フォーラム投稿、カタログアイテムなど、様々なコンテンツタイプに対応したRSSフィードを自動生成する。

**画面へのアクセス方法**：
- サイト全体RSS: `rss.asp`（iIdパラメータなし）
- ページ別RSS: `rss.asp?iId={暗号化されたページID}`
- テーマ/ビュータイプ指定: `rss.asp?iId={ページID}&viewtype={タイプ}`

**主要な操作・処理内容**：
1. ページIDの有無に応じて、サイト全体RSSまたはページ別RSSを判定
2. サイト全体RSSの場合、最近更新されたページ（最大300件）を取得
3. ページ別RSSの場合、リストページ、フォーラム、カタログのコンテンツを取得
4. kwRSS_writerクラスを使用してRSS 2.0形式のXMLを生成
5. アプリケーションオブジェクトにキャッシュして次回リクエスト時の高速化
6. 生成したXMLをContent-Type: application/xmlで出力

**画面遷移**：
- 遷移元：公開サイトの各ページに設置されたRSSアイコン/リンク
- 遷移先：なし（XMLデータ出力のため、ブラウザまたはRSSリーダーが処理）

**権限による表示制御**：
- イントラネットページの場合、未認証時は「No Access」のRSSアイテムを返す
- パスワード保護ページは除外される
- 非公開ページ（bOnline=false）は除外される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 114 | RSSフィード出力 | 主機能 | サイト・ページのRSSフィード生成 |
| 99 | ページ表示 | 補助機能 | ページコンテンツの取得 |
| 100 | リストページ表示 | 補助機能 | リストアイテムのRSSフィード化 |

## 画面種別

データ出力（XML）

## URL/ルーティング

```
# サイト全体RSS
/rss.asp

# ページ別RSS
/rss.asp?iId={暗号化されたページID}

# ビュータイプ指定
/rss.asp?iId={暗号化されたページID}&viewtype={タイプ}
```

## 入出力項目

### 入力項目（リクエストパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ページID | iId | String | 任意 | 暗号化されたページID。指定しない場合はサイト全体RSS |
| ビュータイプ | viewtype | String | 任意 | フォーラムのビュータイプ指定 |

### 出力項目（RSS XML構造）

| 要素 | 説明 |
|------|------|
| channel/title | サイト名またはページタイトル + サイト名 |
| channel/link | サイトURL |
| channel/description | サイト説明 |
| channel/language | 言語コード |
| item/title | アイテムタイトル（日付付き可） |
| item/link | アイテムへのリンクURL |
| item/description | アイテム本文（CDATAラップ） |
| item/pubDate | RFC 822形式の更新日時 |
| item/author | 著者メールアドレス（名前付き） |
| item/guid | 一意識別子（リンクURLと同じ） |
| item/enclosure | 画像添付（リストアイテム画像がある場合） |
| item/comments | コメントリンク（フォーラムの場合） |

## 表示項目

本画面はXML出力のため、視覚的な表示項目はなし。

## イベント仕様

### 1-サイト全体RSSリクエスト（iId未指定）

**トリガー**: iIdパラメータなしでrss.aspにアクセス

**処理内容**:
1. customer.bEnableMainRSSで全体RSS有効かチェック
2. アプリケーションキャッシュから既存RSSを確認
3. キャッシュがない場合、tblPageから最近更新された300件を取得
4. 各ページの公開条件をチェック（オンライン、非削除、非コンテナ、非イントラネット、パスワードなし等）
5. RSS XMLを生成してキャッシュに保存
6. XML出力

### 2-ページ別RSSリクエスト（iId指定）

**トリガー**: iIdパラメータ付きでrss.aspにアクセス

**処理内容**:
1. イントラネットページの場合、認証状態をチェック
2. 未認証の場合は「No Access」RSSを返す
3. 認証済みまたは通常ページの場合：
   - リストページ（bPushRSS=true）: リストアイテムをRSS化
   - フォーラム（iThemeID設定）: 投稿をRSS化
   - カタログ（iCatalogID設定）: カタログアイテムをRSS化
4. RSS XMLを生成してキャッシュに保存
5. ヒットカウント更新とリファラーログ記録
6. XML出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| サイト全体RSS | tblPage | SELECT | 全ページから最近更新されたものを取得 |
| ページ別RSS（リスト） | tblPage | SELECT | リストアイテムを取得 |
| ページ別RSS（フォーラム） | tblPost | SELECT | フォーラム投稿を取得 |
| ページ別RSS（カタログ） | tblCatalogItem | SELECT | カタログアイテムを取得 |
| ヒットカウント | tblPage | UPDATE | RSSアクセス数を更新 |
| リファラーログ | tblReferer | INSERT | 参照元URLを記録 |

### テーブル別更新項目詳細

#### tblPage（参照）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | iId, sTitle, sValue, updatedTS | iCustomerID = cId, bOnline = true, bDeleted = false, etc. | 公開条件を満たすページのみ |

#### tblPage（更新）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | iHitsRSS | iHitsRSS + 1 | addHitRSSメソッド経由 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| RSSコンテンツ | "No Access" | イントラネットページに未認証でアクセス |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| サイト全体RSS無効 | bEnableMainRSS=falseの場合、空レスポンス |
| ページが見つからない | begin.aspでホームページにリダイレクト |
| イントラネット未認証 | 「No Access」RSSアイテムを返す |

## 備考

- RSSはアプリケーションオブジェクトにキャッシュされ、パフォーマンス向上
- キャッシュキーは `RSS{cId}` または `RSS{cId}{pageId}{viewtype}` 形式
- RFC 822形式の日付フォーマットはFormat_RFC822_DateAndTime関数で生成
- ユーザーフレンドリーURLが設定されている場合は、それを使用したリンクを生成
- 画像がある場合はenclosure要素で添付（type="image/jpeg"固定）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、RSSフィード生成に必要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rss_writer.asp | `asp/includes/rss_writer.asp` | kwRSS_writerクラス、aspXMLクラスの構造 |
| 1-2 | page.asp | `asp/includes/page.asp` | cls_pageクラス、fastlistitems、RSSLink等 |

**読解のコツ**: kwRSS_writerクラスは最大500アイテムまで対応。AddNew()で新規アイテム追加、SetTitle()/SetLink()等で属性設定、GetRSS()でXML出力。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rss.asp | `rss.asp` | メインファイル、分岐ロジック、キャッシュ処理 |

**主要処理フロー**:
1. **1-2行目**: begin.aspとrss_writer.aspをインクルード
2. **4行目**: Content-Typeをapplication/xmlに設定
3. **9行目**: selectedPage.iIdで分岐（0ならサイト全体RSS）
4. **11-58行目**: サイト全体RSS生成処理
5. **61-232行目**: ページ別RSS生成処理

#### Step 3: サイト全体RSS処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rss.asp | `rss.asp` 11-58行目 | サイト全体RSS生成ロジック |

**主要処理フロー**:
- **13行目**: キャッシュ確認 `application("RSS" & cId)`
- **23行目**: tblPageから最新300件を取得
- **30行目**: 公開条件チェック（bOnline, bDeleted, bContainerPage等）
- **51行目**: キャッシュに保存

#### Step 4: ページ別RSS処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | rss.asp | `rss.asp` 61-130行目 | リストページRSS生成 |
| 4-2 | rss.asp | `rss.asp` 133-173行目 | フォーラムRSS生成 |
| 4-3 | rss.asp | `rss.asp` 175-213行目 | カタログRSS生成 |

**主要処理フロー**:
- **91行目**: selectedPage.bPushRSSでリストページRSS有効判定
- **94行目**: selectedPage.fastlistitemsでリストアイテム取得
- **133行目**: selectedPage.iThemeIDでフォーラム判定
- **178行目**: selectedPage.catalogでカタログ判定

### プログラム呼び出し階層図

```
rss.asp
    |
    +-- begin.asp (初期化)
    |       +-- customer.pick()
    |       +-- selectedPage.pick()
    |
    +-- rss_writer.asp
    |       +-- kwRSS_writer クラス
    |       +-- aspXML クラス
    |
    +-- [iId=0の場合] サイト全体RSS
    |       +-- application("RSS" & cId) キャッシュチェック
    |       +-- db.execute() ページ一覧取得
    |       +-- cls_page.pick() 各ページデータ
    |       +-- rss.GetRSS() XML生成
    |
    +-- [iId指定の場合] ページ別RSS
            +-- [イントラネット] 認証チェック
            +-- [リストページ] selectedPage.fastlistitems
            +-- [フォーラム] selectedPage.theme.posts
            +-- [カタログ] itemSearch.resultItems
            +-- selectedPage.addHitRSS()
            +-- logReferer()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request ──────────▶ iId判定 ─────────┐
                                      |
[iId=0]                               ▼
tblPage ──────────▶ 最新300件取得 ──▶ キャッシュチェック
                                      |
                                      ▼
[iId指定]                    kwRSS_writer
tblPage ──────────▶ リストアイテム  ──▶ AddNew()
tblPost ──────────▶ フォーラム投稿  ──▶ SetTitle()
tblCatalogItem ───▶ カタログアイテム──▶ SetLink()
                                      |
                                      ▼
                              aspXML.GetXML()
                                      |
                                      ▼
                              application()キャッシュ
                                      |
                                      ▼
                                              ──────▶ RSS XML出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rss.asp | `rss.asp` | ソース | メインエントリーポイント |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| rss_writer.asp | `asp/includes/rss_writer.asp` | ソース | kwRSS_writer、aspXMLクラス定義 |
| page.asp | `asp/includes/page.asp` | ソース | cls_pageクラス（fastlistitems等） |
| customer.asp | `asp/includes/customer.asp` | ソース | cls_customerクラス（bEnableMainRSS等） |
| theme.asp | `asp/includes/theme.asp` | ソース | cls_themeクラス（フォーラム投稿） |
| post.asp | `asp/includes/post.asp` | ソース | cls_postクラス（投稿データ） |
| catalog.asp | `asp/includes/catalog.asp` | ソース | cls_catalogクラス |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | cls_catalogItemクラス |
| itemSearch.asp | `asp/includes/itemSearch.asp` | ソース | cls_itemSearchクラス |
| functions.asp | `asp/includes/functions.asp` | ソース | Format_RFC822_DateAndTime関数等 |
| logVisit.asp | `asp/includes/logVisit.asp` | ソース | logReferer関数 |
