# 画面設計書 163-サイトマップ

## 概要

本ドキュメントは、QuickerSite CMSにおけるXMLサイトマップ生成画面（sitemap.asp）の画面設計書である。この画面は、検索エンジンのクローラー向けにサイト構造をXML形式で出力する機能を提供する。

### 本画面の処理概要

サイトマップ画面は、CMSで管理されている全公開ページのURLをXMLサイトマップ形式（sitemaps.org仕様）で生成・出力する機能を提供する。これにより、検索エンジン（Google、Bing等）がサイト構造を効率的にクロールし、インデックス登録を促進できる。

**業務上の目的・背景**：SEO（検索エンジン最適化）において、XMLサイトマップは検索エンジンにサイト構造を明示的に伝える重要な手段である。特に大規模なサイトや頻繁に更新されるサイトでは、クローラーが全ページを発見するのに時間がかかるため、XMLサイトマップを提供することでインデックス登録を迅速化し、検索結果への露出を早めることができる。QuickerSiteでは、通常ページ、リストアイテム、フォーラム投稿を含む包括的なサイトマップを自動生成する。

**画面へのアクセス方法**：
- 直接アクセス: `sitemap.asp`
- 検索エンジンへの登録: Google Search ConsoleやBing Webmaster Toolsで `http://yoursite.com/sitemap.asp` を登録

**主要な操作・処理内容**：
1. cls_searchクラスを使用してサイト内の全公開ページを取得
2. 各ページについて、フォーラム投稿がある場合は投稿URLも追加
3. リストアイテムは親ページIDと合わせたURLを生成
4. ユーザーフレンドリーURLが設定されている場合はそれを使用
5. sitemaps.org仕様のXML形式でURLリストを出力

**画面遷移**：
- 遷移元：検索エンジンのクローラーまたは直接URLアクセス
- 遷移先：なし（XMLデータ出力）

**権限による表示制御**：
- 公開ページのみが含まれる（非公開、削除済み、パスワード保護、イントラネットページは除外）
- 認証不要で誰でもアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | XMLサイトマップ出力 | 主機能 | 検索エンジン向けXMLサイトマップ生成 |
| 102 | サイト内検索 | 補助機能 | cls_searchクラスを使用したページ一覧取得 |

## 画面種別

データ出力（XML）

## URL/ルーティング

```
/sitemap.asp
```

## 入出力項目

### 入力項目（リクエストパラメータ）

本画面に入力パラメータはなし。

### 出力項目（XMLサイトマップ構造）

| 要素 | 説明 |
|------|------|
| urlset | ルート要素（sitemaps.org名前空間） |
| url | 各URLのコンテナ要素 |
| loc | ページの完全URL |

## 表示項目

本画面はXML出力のため、視覚的な表示項目はなし。

### XML出力例

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset
xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
<url>
<loc>http://www.example.com/default.asp?iId=ABC123</loc>
</url>
<url>
<loc>http://www.example.com/page-name</loc>
</url>
</urlset>
```

## イベント仕様

### 1-サイトマップ生成

**トリガー**: sitemap.aspへのHTTPリクエスト

**処理内容**:
1. cls_searchオブジェクトを生成し、検索条件を設定
   - includeURL=false（外部URLページを除外）
   - allowEmptyString=true（空文字列でも検索実行）
   - includeListItems=true（リストアイテムを含む）
2. 検索を実行してすべての公開ページを取得
3. 各ページについて：
   - フォーラム（iThemeID設定）の場合、投稿URLを追加
   - リストアイテム（iListPageID設定）の場合、親ページIDと合わせたURLを生成
   - ユーザーフレンドリーURLがある場合はそれを使用
   - それ以外は標準URL形式を使用
4. XML文字列を生成して出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ一覧取得 | tblPage | SELECT | cls_searchを使用して公開ページを取得 |
| フォーラム投稿取得 | tblPost | SELECT | フォーラムページの投稿一覧を取得 |

### テーブル別更新項目詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | iId, sUserFriendlyURL, iListPageID, iThemeID | cls_searchの検索条件に基づく | 公開条件を満たすページのみ |

#### tblPost（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | iId | iThemeID = {ページのiThemeID}, (iPostID is null or iPostID=0) | 親投稿のみ（返信除く） |

## メッセージ仕様

本画面ではメッセージ表示なし。

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| 検索結果が0件 | 空のurlsetのみを出力 |
| データベースエラー | begin.aspのエラーハンドリングに従う |

## 備考

- XMLサイトマップはsitemaps.org仕様（バージョン0.9）に準拠
- lastmod、changefreq、priority要素は含まれていない（loc要素のみ）
- 検索エンジンへの送信はGoogle Search Console等から手動で行う
- サイトマップ検証は http://www.xml-sitemaps.com/validate-xml-sitemap.html 等で可能
- フォーラム投稿は親投稿（iPostID is null or iPostID=0）のみが含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページ検索に使用されるcls_searchクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | search.asp | `asp/includes/search.asp` | cls_searchクラス、resultsメソッド |
| 1-2 | page.asp | `asp/includes/page.asp` | cls_pageクラス、sUserFriendlyURL等 |

**読解のコツ**: cls_searchクラスはデータベースからページを検索するユーティリティクラス。includeURLやincludeListItems等のプロパティで検索条件を制御。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sitemap.asp | `sitemap.asp` | メインファイル、XML生成ロジック |

**主要処理フロー**:
1. **1行目**: begin.aspをインクルード
2. **8-14行目**: XMLヘッダーとurlset開始タグを生成
3. **16-23行目**: cls_searchで検索条件を設定
4. **26-54行目**: 各ページのURLを生成
5. **55行目**: urlset終了タグ
6. **59行目**: XMLを出力

#### Step 3: 検索処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | search.asp | `asp/includes/search.asp` | resultsメソッドの実装詳細 |

**主要処理フロー**:
- **17行目（sitemap.asp）**: includeURL=false（外部URLを除外）
- **18行目**: allowEmptyString=true（全ページ取得のため）
- **19行目**: includeListItems=true（リストアイテムを含む）
- **55-103行目（search.asp）**: SQLクエリ生成、公開条件フィルタリング

#### Step 4: URL生成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | sitemap.asp | `sitemap.asp` 29-53行目 | URLタイプ別の生成ロジック |

**主要処理フロー**:
- **29-39行目**: フォーラム（iThemeID）の場合、投稿URLを追加
- **44-45行目**: リストアイテムの場合、親ページID付きURL
- **47-48行目**: ユーザーフレンドリーURLがある場合
- **50-51行目**: 標準URL形式

### プログラム呼び出し階層図

```
sitemap.asp
    |
    +-- begin.asp (初期化)
    |       +-- customer.pick()
    |       +-- (selectedPageは使用されない)
    |
    +-- cls_search.new
    |       +-- includeURL = false
    |       +-- allowEmptyString = true
    |       +-- includeListItems = true
    |
    +-- getSiteMap.results
    |       +-- db.execute() SQL実行
    |       +-- cls_page.pick() 各ページ取得
    |
    +-- [iThemeID設定] フォーラム投稿取得
    |       +-- db.execute() 投稿一覧取得
    |
    +-- XML文字列生成
    |       +-- URL形式判定（リストアイテム/UFL/標準）
    |
    +-- Response.Write sitemap
    +-- cleanUPASP()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(パラメータなし) ───▶ cls_search初期化
                            |
                            ▼
                    results実行
                            |
                            ▼
                    tblPage (DB参照)
                            |
                            ▼
                    [iThemeID設定?]
                     /           \
                    Y             N
                    |             |
                    ▼             |
           tblPost (DB参照)      |
                    |             |
                    ▼             ▼
                URL形式判定
                    |
                    ▼
           sitemap変数に追記
                    |
                    ▼
                                              ──────▶ XML出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sitemap.asp | `sitemap.asp` | ソース | メインエントリーポイント |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| search.asp | `asp/includes/search.asp` | ソース | cls_searchクラス定義 |
| page.asp | `asp/includes/page.asp` | ソース | cls_pageクラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | cls_customerクラス（sQSUrl等） |
| encryption.asp | `asp/includes/encryption.asp` | ソース | encrypt関数 |
| functions.asp | `asp/includes/functions.asp` | ソース | convertGetal、isLeeg等 |
