# 画面設計書 164-ログイン処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるページログイン処理画面（process_login.asp）の画面設計書である。この画面は、パスワード保護されたページにアクセスするためのログインフォームを表示し、認証処理を行う。

### 本画面の処理概要

ログイン処理画面は、パスワード保護されたページへのアクセス時に、パスワード入力フォームを表示し、入力されたパスワードを検証してページへのアクセスを許可する機能を提供する。

**業務上の目的・背景**：CMSで管理されている特定のページを一般公開せず、限られたユーザーにのみ閲覧を許可したいケースがある。例えば、顧客専用情報、社内向け資料、有料コンテンツなどを保護するために、ページ単位でパスワードを設定できる。この画面は、そのようなパスワード保護ページにアクセスしようとしたユーザーに対して、パスワード入力を求め、正しいパスワードが入力された場合のみコンテンツを表示する仕組みを提供する。

**画面へのアクセス方法**：
- パスワード保護されたページ（sPw設定あり）にアクセスしようとすると、process.aspからリダイレクトされる
- URL形式: `default.asp?pageAction=login&iId={暗号化されたページID}`

**主要な操作・処理内容**：
1. パスワード入力フォームを表示
2. ユーザーがパスワードを入力して送信
3. logon.logonItemメソッドでパスワードを検証
4. 認証成功時は対象ページにリダイレクト
5. 認証失敗時はエラーメッセージを表示

**画面遷移**：
- 遷移元：パスワード保護ページへの直接アクセス（process.aspでリダイレクト）
- 遷移先（成功）：対象のパスワード保護ページ（default.asp?iId={ページID}）
- 遷移先（失敗）：同画面にエラーメッセージ表示

**権限による表示制御**：
- 全ユーザーがアクセス可能（認証前画面のため）
- 正しいパスワード入力後、Cookieにパスワードが保存される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 103 | ページログイン | 主機能 | ユーザーログイン処理 |
| 104 | イントラネットログイン | 補助機能 | 会員専用エリアへのログイン |

## 画面種別

認証（ログイン）

## URL/ルーティング

```
/default.asp?pageAction=login&iId={暗号化されたページID}
```

## 入出力項目

### 入力項目（フォーム）

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| ページID | iId | hidden | 必須 | 40 | 暗号化されたページID |
| ページアクション | pageAction | hidden | 必須 | - | 固定値「login」 |
| パスワード | sPw | password | 必須 | 15 | ページアクセス用パスワード |

### 出力項目

| 項目名 | 説明 |
|------|------|
| ページタイトル | 対象ページのタイトル |
| 説明テキスト | パスワード要求の説明文 |
| パスワード要求リンク | ウェブマスターへのメール問い合わせリンク |
| エラーメッセージ | 認証失敗時のエラー（err_login） |

## 表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 説明テキスト | テキスト | 「{ページタイトル}にアクセスするにはパスワードが必要です」 |
| パスワード要求リンク | リンク | ウェブマスターへのmailtoリンク |
| パスワードラベル | テキスト | 「Password:」（多言語対応） |
| パスワード入力欄 | input[type=password] | 幅200px、最大15文字 |
| ログインボタン | submit | 「Login」（多言語対応） |

## イベント仕様

### 1-パスワード送信

**トリガー**: ログインボタンをクリック（フォーム送信）

**処理内容**:
1. Request.Form("pageAction")が"login"であることを確認
2. logon.logonItem(Request.form("sPw"), selectedPage)でパスワード検証
3. 認証成功時：
   - 対象ページにリダイレクト（default.asp?iId={ページID}）
4. 認証失敗時：
   - message.AddError("err_login")でエラーメッセージを設定
   - フォームを再表示

**画面遷移**:
- 成功：`default.asp?iId={暗号化されたページID}`
- 失敗：現在の画面を再表示

### 2-パスワード要求メール

**トリガー**: 「パスワードを問い合わせる」リンクをクリック

**処理内容**:
- ブラウザのメールクライアントが起動
- 宛先：ウェブマスターのメールアドレス
- 件名：「パスワード要求」
- 本文：「{ページタイトル}のパスワードをお願いします」

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | tblPage | SELECT | ページ情報（タイトル、パスワード）取得 |
| パスワード検証 | tblPage | SELECT | sPwカラムとの照合 |

### テーブル別更新項目詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | iId, sTitle, sPw | iId = 復号化したページID | パスワード検証用 |

## メッセージ仕様

| 種別 | メッセージID | メッセージ | 発生条件 |
|------|------------|----------|---------|
| エラー | err_login | ログイン失敗メッセージ | パスワードが一致しない場合 |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| ページが見つからない | begin.aspでホームページにリダイレクト |
| ページにパスワード未設定 | process.aspで通常ページとして表示 |
| 空のパスワード入力 | HTML5 required属性で送信前にブラウザが警告 |

## 備考

- パスワードはCookieに暗号化して保存され、次回アクセス時は自動認証される
- Cookieキーは `encrypt(selectedPage.iId)` 形式
- パスワード最大長は15文字（input maxlength属性）
- フォーム送信後はJavaScriptでパスワード入力欄にフォーカス
- 多言語対応：l()関数で各ラベルを言語ファイルから取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページのパスワード保護に関するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラス、sPwプロパティ |
| 1-2 | logonEdit.asp | `asp/includes/logonEdit.asp` | cls_logonEditクラス、logonItemメソッド |

**読解のコツ**: logonItemメソッドはパスワード検証を行い、一致すればCookieに保存してtrueを返す。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_login.asp | `asp/process_login.asp` | メインファイル、認証ロジック、フォーム生成 |

**主要処理フロー**:
1. **2行目**: pageAction="login"かチェック
2. **3行目**: logon.logonItemでパスワード検証
3. **4行目**: 認証成功時はリダイレクト
4. **6行目**: 認証失敗時はエラーメッセージ追加
5. **9-25行目**: ログインフォームのHTML生成

#### Step 3: 認証処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | logonItemメソッドの実装 |
| 3-2 | encryption.asp | `asp/includes/encryption.asp` | encrypt関数（Cookie保存用） |

**主要処理フロー**:
- logonItem(pw, page): ページのsPwと入力パスワードを比較
- 一致時：Cookie保存、trueを返す
- 不一致時：falseを返す

#### Step 4: フォーム生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | process_login.asp | `asp/process_login.asp` 9-25行目 | HTML生成ロジック |
| 4-2 | language.asp | `asp/includes/language.asp` | l()関数（多言語対応） |

**主要処理フロー**:
- **9行目**: form開始、action="default.asp"
- **10行目**: hidden input: iId（暗号化ページID）
- **11行目**: hidden input: pageAction="login"
- **12-13行目**: 説明テキストとパスワード要求リンク
- **16-17行目**: パスワード入力フィールド
- **21行目**: ログインボタン
- **25行目**: JavaScript: パスワード欄にフォーカス

### プログラム呼び出し階層図

```
default.asp
    |
    +-- begin.asp (初期化)
    |       +-- logon = new cls_logonEdit
    |       +-- selectedPage.pick()
    |
    +-- process.asp
    |       +-- [pageAction="login"] process_login.asp
    |               |
    |               +-- logon.logonItem(sPw, selectedPage)
    |               |       +-- パスワード比較
    |               |       +-- Cookie保存（成功時）
    |               |
    |               +-- [成功] Response.Redirect
    |               +-- [失敗] message.AddError
    |               +-- フォームHTML生成
    |                       +-- l() 多言語取得
    |                       +-- sanitize() サニタイズ
    |                       +-- encrypt() ページID暗号化
    |
    +-- テンプレート適用（pageBody出力）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request.iId ──────▶ decrypt() ──────▶ ページID
                            |
                            ▼
                    selectedPage.pick()
                            |
                            ▼
Request.Form("sPw") ──────▶ logon.logonItem()
                            |
                            ▼
                    tblPage.sPw と比較
                            |
                     ┌──────┴──────┐
                     ▼             ▼
               [一致]         [不一致]
                 |               |
                 ▼               ▼
           Cookie保存      message.AddError
                 |               |
                 ▼               ▼
           リダイレクト    フォーム再表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_login.asp | `asp/process_login.asp` | ソース | メイン処理ファイル |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| process.asp | `asp/process.asp` | ソース | pageActionによる分岐 |
| logonEdit.asp | `asp/includes/logonEdit.asp` | ソース | cls_logonEditクラス（認証） |
| page.asp | `asp/includes/page.asp` | ソース | cls_pageクラス |
| encryption.asp | `asp/includes/encryption.asp` | ソース | encrypt/decrypt関数 |
| language.asp | `asp/includes/language.asp` | ソース | l()関数（多言語） |
| messages.asp | `asp/includes/messages.asp` | ソース | message.AddError |
| functions.asp | `asp/includes/functions.asp` | ソース | sanitize関数等 |
