# 画面設計書 165-検索処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるサイト内検索処理画面（process_search.asp）の画面設計書である。この画面は、公開サイト上でキーワード検索を実行し、検索結果を表示する機能を提供する。

### 本画面の処理概要

検索処理画面は、ユーザーが入力したキーワードに基づいてサイト内のページを検索し、マッチしたページの一覧を表示する機能を提供する。タイトルと本文の両方を対象とした全文検索を行い、結果をリンク付きリストで表示する。

**業務上の目的・背景**：Webサイトのコンテンツが増加すると、ユーザーが必要な情報を見つけることが困難になる。サイト内検索機能は、ユーザーが目的の情報に素早くアクセスできるようにし、ユーザビリティを向上させる重要な機能である。QuickerSiteでは、通常ページ、リストアイテム、外部URLページ、フォーラム投稿を含む包括的な検索機能を提供する。

**画面へのアクセス方法**：
- 検索フォームからの送信: `default.asp?pageAction=search&svalue={検索キーワード}`
- POSTでも検索可能: svalueパラメータをFormで送信

**主要な操作・処理内容**：
1. 検索キーワード（svalue）をリクエストから取得（最大100文字）
2. cls_searchクラスを使用してデータベース検索を実行
3. 検索結果を取得し、各ページタイプに応じたリンクを生成
4. 検索キーワードを太字でハイライト
5. 検索結果件数とキーワードをページタイトルに表示

**画面遷移**：
- 遷移元：サイトヘッダーなどに設置された検索フォーム
- 遷移先：検索結果のリンククリックで各ページに遷移

**権限による表示制御**：
- パスワード保護ページは検索対象外（ログインしている場合は対象）
- イントラネットページは認証済みの場合のみ検索対象
- bHideFromSearch=trueのページは検索対象外

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 102 | サイト内検索 | 主機能 | 公開サイトでのキーワード検索処理 |

## 画面種別

検索結果一覧

## URL/ルーティング

```
/default.asp?pageAction=search&svalue={検索キーワード}
```

## 入出力項目

### 入力項目（リクエストパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 最大長 | 説明 |
|--------|-------------|-----|------|--------|------|
| 検索キーワード | svalue | String | 必須 | 100 | 検索する文字列 |
| イントラネット検索 | bIntranet | Boolean | 任意 | - | イントラネット内検索フラグ |

### 出力項目

| 項目名 | 説明 |
|------|------|
| ページタイトル | 「{件数}件の検索結果: '{キーワード}'」 |
| 検索結果リスト | マッチしたページのタイトルとスニペット |

## 表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 検索結果タイトル | リンク | ページタイトル（クリックで遷移） |
| スニペット | テキスト | 本文の先頭150文字（キーワードを太字表示） |

### 検索結果HTML構造

```html
<div id='QS_searchResults'>
  <div class='QS_searchResultsTitle'>
    <a href='default.asp?iId=...'>ページタイトル</a>
  </div>
  <div class='QS_searchResultsText'>
    本文スニペット（<b>キーワード</b>ハイライト）...
  </div>
</div>
```

## イベント仕様

### 1-検索実行

**トリガー**: pageAction=searchでアクセス

**処理内容**:
1. 検索キーワードをRequest.FormまたはRequest.QueryStringから取得
2. search.value、bIntranet、includeListItemsを設定
3. search.resultsで検索を実行
4. 結果が0件より多い場合、検索結果HTMLを生成
5. 各結果について：
   - アプリケーションページ：シンプルなリンク
   - リストアイテム（外部URLなし）：親ページID付きリンク
   - リストアイテム（外部URLあり）：外部URLへのリンク
   - 通常ページ（フォーラム投稿）：投稿IDリンク
   - 外部URLページ：外部サイトへのリンク
6. キーワードを太字に置換
7. pageTitleに結果件数を設定

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索実行 | tblPage | SELECT | タイトル・本文でキーワード検索 |
| 検索実行 | tblPost | SELECT | フォーラム投稿の検索 |

### テーブル別更新項目詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | iId, sTitle, sValueTextOnly, sExternalURL, iListPageID, iPostID, sLPExternalURL | sTitle LIKE '%keyword%' OR sValueTextOnly LIKE '%keyword%' | 公開条件を満たすページのみ |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| - | - | 検索結果が0件でも特にエラーメッセージなし |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| 検索キーワードが空 | 検索実行されず、結果0件 |
| 検索キーワードが3文字未満 | cls_search内で検索スキップ |
| 検索結果0件 | pageBodyは空、pageTitleに「0件の検索結果」表示 |

## 備考

- 検索キーワードは最大100文字に制限
- キーワードが3文字未満の場合は検索されない
- 検索結果のスニペットは本文の先頭150文字
- キーワードは大文字小文字を区別しない（vbTextCompare）
- 複数単語の場合、OR検索（いずれかの単語を含む）
- 検索キーワードはCookieに保存され、再利用される
- HTMLコメントはRemoveHTMLComments関数で除去

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、検索クラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | search.asp | `asp/includes/search.asp` | cls_searchクラス、resultsメソッド |

**読解のコツ**: cls_searchクラスは複雑なSQLを動的に生成して検索を行う。includeListItems、bIntranet等のフラグで検索範囲を制御。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_search.asp | `asp/process_search.asp` | メインファイル、検索実行、結果表示 |

**主要処理フロー**:
1. **2行目**: search.valueにキーワード設定（最大100文字）
2. **3行目**: QueryStringからも取得（GET対応）
3. **4-6行目**: 検索条件設定
4. **7行目**: search.resultsで検索実行
5. **8-42行目**: 検索結果のHTML生成
6. **43行目**: pageTitleに結果件数を設定

#### Step 3: 検索ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | search.asp | `asp/includes/search.asp` 31-154行目 | resultsメソッドの詳細 |

**主要処理フロー**:
- **34行目**: 空文字列・3文字未満チェック
- **55-88行目**: SQLクエリ構築（LIKE検索）
- **96-104行目**: ページオブジェクト生成・Dictionary追加
- **107-153行目**: フォーラム投稿の検索

#### Step 4: 結果タイプ別処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | process_search.asp | `asp/process_search.asp` 11-37行目 | 結果タイプ別の分岐処理 |

**主要処理フロー**:
- **11-13行目**: sApplication設定ページ
- **14-25行目**: リストアイテム（外部URL有無で分岐）
- **26-33行目**: 通常ページ（フォーラム投稿有無で分岐）
- **34-36行目**: 外部URLページ

### プログラム呼び出し階層図

```
default.asp
    |
    +-- begin.asp (初期化)
    |       +-- search = new cls_search
    |
    +-- process.asp
    |       +-- [pageAction="search"] process_search.asp
    |               |
    |               +-- search.value = Request("svalue")
    |               +-- search.bIntranet = Request("bIntranet")
    |               +-- search.includeListItems = true
    |               +-- search.bIncludeHideFromSearch = false
    |               |
    |               +-- search.results
    |               |       +-- SQL生成（tblPage検索）
    |               |       +-- SQL生成（tblPost検索）
    |               |       +-- cls_page.pick()
    |               |
    |               +-- 検索結果HTML生成
    |                       +-- encrypt() ページID暗号化
    |                       +-- treatConstants() 定数置換
    |                       +-- RemoveHTMLComments()
    |                       +-- sanitize() サニタイズ
    |
    +-- テンプレート適用（pageBody出力）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request.svalue ────▶ search.value設定
        |                   |
        |                   ▼
        |           cls_search.results
        |                   |
        |                   ▼
        |           SQL生成（LIKE検索）
        |                   |
        |                   ▼
        |           tblPage, tblPost (DB参照)
        |                   |
        |                   ▼
        |           Dictionary形式で結果格納
        |                   |
        |                   ▼
        |           [結果タイプ判定]
        |            /     |     \
        |       リスト  通常   外部URL
        |           \    |    /
        |            ▼   ▼   ▼
        |           リンクHTML生成
        |                   |
        |                   ▼
        |           キーワードハイライト
        |                   |
        └──────────────────────────▶ 検索結果ページ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_search.asp | `asp/process_search.asp` | ソース | メイン処理ファイル |
| search.asp | `asp/includes/search.asp` | ソース | cls_searchクラス定義 |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| process.asp | `asp/process.asp` | ソース | pageAction分岐 |
| page.asp | `asp/includes/page.asp` | ソース | cls_pageクラス |
| post.asp | `asp/includes/post.asp` | ソース | cls_postクラス |
| encryption.asp | `asp/includes/encryption.asp` | ソース | encrypt関数 |
| functions.asp | `asp/includes/functions.asp` | ソース | treatConstants、RemoveHTMLComments、sanitize |
| insertConstants.asp | `asp/includes/insertConstants.asp` | ソース | treatConstants関数 |
