# 画面設計書 166-メール送信処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるメール送信処理画面（process_send.asp）の画面設計書である。この画面は、フォームから送信されたデータをメールとして送信する処理を担当する。

### 本画面の処理概要

メール送信処理画面は、CMSに組み込まれたフォーム機能からのデータ送信を処理し、設定された宛先にメールを送信する機能を提供する。

**業務上の目的・背景**：Webサイト上のお問い合わせフォームや申し込みフォームなど、ユーザーが入力したデータをサイト管理者にメールで通知する必要がある。この処理は、フォーム機能（bs_formEdit.asp等で設定）と連携し、フォーム送信時のバックエンド処理を担当する。ただし、現在のprocess_send.aspは空ファイルであり、実際のメール送信処理はform.asp内のbuildメソッドで行われている可能性が高い。

**画面へのアクセス方法**：
- URL形式: `default.asp?pageAction=send`
- フォーム送信によるリダイレクト

**主要な操作・処理内容**：
1. process.aspからpageAction="send"でインクルードされる
2. 実際の処理内容は現在空（フォーム機能で直接処理される可能性）

**画面遷移**：
- 遷移元：公開サイトのフォーム送信
- 遷移先：フォーム送信完了ページまたは元のページ

**権限による表示制御**：
- フォームが設置されたページへのアクセス権限に依存

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | フォーム送信 | 主機能 | フォームからのメール送信処理 |

## 画面種別

処理（バックエンド）

## URL/ルーティング

```
/default.asp?pageAction=send
```

## 入出力項目

### 入力項目

現在のprocess_send.aspは空ファイルのため、具体的な入力項目は定義されていない。
フォーム機能（form.asp）で直接処理される場合の入力項目はフォーム設計による。

### 出力項目

出力項目なし（処理のみ）

## 表示項目

なし（バックエンド処理）

## イベント仕様

### 1-メール送信（未実装）

**トリガー**: pageAction="send"でアクセス

**処理内容**:
- 現在のprocess_send.aspは空ファイルのため、処理なし
- 実際のメール送信はform.asp内で行われている可能性あり

## データベース更新仕様

現在のprocess_send.aspは空ファイルのため、データベース更新なし。

## メッセージ仕様

なし

## 例外処理

なし

## 備考

- process_send.aspは現在空ファイル（2行目に空行のみ）
- メール送信処理はフォーム機能（asp/includes/form.asp）のbuildメソッド内で直接処理されている可能性が高い
- mailPage.aspやbs_massMailing2.asp等の他の画面でメール送信が実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 現状確認

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process_send.asp | `asp/process_send.asp` | 空ファイルであることを確認 |

**読解のコツ**: このファイルは空のため、実際のメール送信処理は他の場所で行われている。

#### Step 2: 関連するメール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form.asp | `asp/includes/form.asp` | cls_formクラス、buildメソッド内のメール送信 |
| 2-2 | mail_message.asp | `asp/includes/mail_message.asp` | cls_mail_messageクラス |

### プログラム呼び出し階層図

```
default.asp
    |
    +-- process.asp
            +-- [pageAction="send"] process_send.asp
                    +-- (空ファイル - 処理なし)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_send.asp | `asp/process_send.asp` | ソース | メイン処理（空ファイル） |
| form.asp | `asp/includes/form.asp` | ソース | フォームクラス（実際のメール送信） |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| process.asp | `asp/process.asp` | ソース | pageAction分岐 |
