# 画面設計書 167-登録処理

## 概要

本ドキュメントは、QuickerSite CMSにおける会員登録処理画面（process_register.asp）の画面設計書である。この画面は、新規会員の仮登録を行い、アクティベーションメールを送信する機能を提供する。

### 本画面の処理概要

登録処理画面は、イントラネット（会員専用エリア）への新規会員登録を受け付け、メールアドレスの確認のためのアクティベーションリンクを送信する機能を提供する。二段階認証方式により、メールアドレスの実在性を確認してから本登録を完了させる。

**業務上の目的・背景**：会員専用コンテンツを提供するサイトでは、新規会員の登録機能が必要となる。メールアドレスの実在性確認（ダブルオプトイン）は、スパム防止やGDPR等の法令遵守の観点からも重要である。QuickerSiteでは、メールアドレス入力とCAPTCHA認証を組み合わせた仮登録フォームを提供し、アクティベーションメールを送信することで、信頼性の高い会員登録プロセスを実現する。

**画面へのアクセス方法**：
- URL形式: `default.asp?pageAction=register`
- イントラネット機能が有効かつ新規登録許可が設定されている場合のみアクセス可能

**主要な操作・処理内容**：
1. メールアドレス入力フォームを表示
2. CAPTCHA認証で自動登録を防止
3. CSRF対策のセキュリティトークンを検証
4. 重複メールアドレスのチェック
5. アクティベーションチケットを生成してデータベースに保存
6. アクティベーションリンク付きメールを送信
7. イントラネットログイン画面にリダイレクト

**画面遷移**：
- 遷移元：イントラネットログイン画面の「新規登録」リンク
- 遷移先（成功）：イントラネットログイン画面（fb_activationlinkメッセージ付き）
- 遷移先（失敗）：同画面にエラーメッセージ表示

**権限による表示制御**：
- customer.intranetUse=trueかつcustomer.bAllowNewRegistrations=trueの場合のみアクセス可能
- それ以外はホームページにリダイレクト

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | 会員登録 | 主機能 | 新規会員の仮登録・アクティベーションメール送信 |

## 画面種別

登録フォーム

## URL/ルーティング

```
/default.asp?pageAction=register
```

## 入出力項目

### 入力項目（フォーム）

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| ページアクション | pageAction | hidden | 必須 | - | 固定値「register」 |
| CSRFトークン | QS_secCodeHidden | hidden | 必須 | - | セキュリティトークン |
| メールアドレス | sEmail | email | 必須 | 100 | 登録するメールアドレス |
| CAPTCHA | captcha | text | 必須 | 4 | 画像認証コード |

### 出力項目

| 項目名 | 説明 |
|------|------|
| ページタイトル | customer.sLabelRegister（多言語対応の登録ラベル） |
| 説明テキスト | customer.sExplTicket（チケット発行の説明文） |

## 表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 説明テキスト | HTML | 管理者が設定した登録説明文 |
| メールアドレスラベル | テキスト | 「Email:」（多言語対応） |
| メールアドレス入力欄 | input[type=email] | 幅200px、最大100文字 |
| CAPTCHAラベル | テキスト | 「CAPTCHA:」（多言語対応） |
| CAPTCHA画像 | img | 認証用画像 |
| CAPTCHA入力欄 | input[type=text] | 幅63px、最大4文字 |
| 送信ボタン | submit | 「Send」（多言語対応） |

## イベント仕様

### 1-登録フォーム送信

**トリガー**: 送信ボタンをクリック（フォーム送信）

**処理内容**:
1. checkCSRF()でCSRFトークンを検証
2. cls_ticketオブジェクトを生成
3. メールアドレスをsEmailプロパティに設定
4. ticket.saveAndSend()を実行：
   - CAPTCHA検証
   - メールアドレス形式検証
   - 重複チェック（tblContactRegistration、tblContact）
   - チケット生成・保存
   - アクティベーションメール送信
5. 成功時：イントラネットログイン画面にリダイレクト
6. 失敗時：エラーメッセージ表示

**画面遷移**:
- 成功：`default.asp?pageAction=loginIntranet&iId={ホームページID}&fbMessage=fb_activationlink`
- 失敗：現在の画面を再表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 仮登録 | tblContactRegistration | INSERT | アクティベーションチケット登録 |
| 重複チェック | tblContactRegistration | SELECT | 同一メールの仮登録確認 |
| 重複チェック | tblContact | SELECT | 既存会員の確認 |

### テーブル別更新項目詳細

#### tblContactRegistration（INSERT）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | iCustomerID | cId | 顧客ID |
| INSERT | sEmail | 入力値 | メールアドレス |
| INSERT | sTicket | GeneratePassWord x 2 | 16文字のチケット |
| INSERT | sVisitorDetails | getVisitorDetails() | 訪問者情報 |
| INSERT | dCreatedTS | now() | 作成日時 |

## メッセージ仕様

| 種別 | メッセージID | メッセージ | 発生条件 |
|------|------------|----------|---------|
| 成功 | fb_activationlink | アクティベーションリンク送信完了 | 仮登録成功時 |
| エラー | err_email | メールアドレスエラー | 空または形式不正 |
| エラー | err_captcha | CAPTCHA認証エラー | CAPTCHA不一致 |
| エラー | err_activationlink | アクティベーションリンク重複 | 同一メールで仮登録済み |
| エラー | err_doubleemail | メールアドレス重複 | 既に本登録済み |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| イントラネット無効 | ホームページにリダイレクト |
| 新規登録不許可 | ホームページにリダイレクト |
| CSRF検証失敗 | エラー処理（checkCSRF内） |
| メール送信失敗 | エラーメッセージ表示（要確認） |

## 備考

- アクティベーションリンクの形式：`{サイトURL}/default.asp?pageAction=profile&ac={チケット}`
- チケットは16文字のランダム文字列（GeneratePassWord x 2）
- CAPTCHA画像は `quickersite/asp/includes/captcha.asp` で生成
- メール本文は `customer.sMailTicket` で設定、`[QS_Intranet:ActivationLink]` がリンクに置換される
- 訪問者情報（IP、ブラウザ等）がsVisitorDetailsに記録される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、チケットクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ticket.asp | `asp/includes/ticket.asp` | cls_ticketクラス、saveAndSend、checkメソッド |

**読解のコツ**: saveAndSendメソッドがメインの処理。checkでバリデーション、saveでDB登録、sendTicketでメール送信。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_register.asp | `asp/process_register.asp` | メインファイル、フォーム生成、送信処理 |

**主要処理フロー**:
1. **2行目**: pageAction=registerかチェック
2. **3行目**: checkCSRF()でCSRF検証
3. **4-5行目**: ticketオブジェクト生成、メール設定
4. **6行目**: saveAndSend()実行
5. **7行目**: 成功時リダイレクト
6. **10-29行目**: フォームHTML生成

#### Step 3: チケット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ticket.asp | `asp/includes/ticket.asp` 35-71行目 | checkメソッド（バリデーション） |
| 3-2 | ticket.asp | `asp/includes/ticket.asp` 72-99行目 | saveAndSendメソッド |
| 3-3 | ticket.asp | `asp/includes/ticket.asp` 107-115行目 | sendTicketメソッド |

**主要処理フロー**:
- **check()**: メールアドレス検証、CAPTCHA検証、重複チェック
- **saveAndSend()**: チケット生成、DB保存、メール送信
- **sendTicket()**: アクティベーションメール送信

### プログラム呼び出し階層図

```
default.asp
    |
    +-- process.asp
            +-- [intranetUse && bAllowNewRegistrations]
            |       +-- [pageAction="register"] process_register.asp
            |               |
            |               +-- checkCSRF()
            |               +-- ticket = new cls_ticket
            |               +-- ticket.sEmail = Request("sEmail")
            |               +-- ticket.saveAndSend()
            |               |       +-- check()
            |               |       |       +-- isLeeg/CheckEmailSyntax
            |               |       |       +-- CAPTCHA検証
            |               |       |       +-- DB重複チェック
            |               |       |
            |               |       +-- GeneratePassWord()
            |               |       +-- DB INSERT
            |               |       +-- sendTicket()
            |               |               +-- cls_mail_message
            |               |
            |               +-- [成功] Response.Redirect
            |               +-- [失敗] フォーム表示
            |
            +-- [else] redirectToHP()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request.sEmail ────▶ ticket.sEmail設定
        |                   |
        ▼                   ▼
Request.captcha ───▶ CAPTCHA検証（Session比較）
        |                   |
        |                   ▼
        |           メールアドレス検証
        |                   |
        |                   ▼
        |           重複チェック（tblContactRegistration）
        |                   |
        |                   ▼
        |           重複チェック（tblContact）
        |                   |
        |                   ▼
        |           チケット生成（GeneratePassWord x 2）
        |                   |
        |                   ▼
        |           tblContactRegistration INSERT
        |                   |
        |                   ▼
        |           アクティベーションメール送信
        |                   |
        └───────────────────────────▶ リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_register.asp | `asp/process_register.asp` | ソース | メイン処理ファイル |
| ticket.asp | `asp/includes/ticket.asp` | ソース | cls_ticketクラス |
| process.asp | `asp/process.asp` | ソース | pageAction分岐・アクセス制御 |
| customer.asp | `asp/includes/customer.asp` | ソース | intranetUse、bAllowNewRegistrations |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | cls_mail_messageクラス |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| functions.asp | `asp/includes/functions.asp` | ソース | checkCSRF、GeneratePassWord、sanitize |
