# 画面設計書 168-プロフィール処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるプロフィール処理画面（process_profile.asp）の画面設計書である。この画面は、会員のプロフィール情報の編集・更新機能を提供する。新規会員登録の本登録（アクティベーション後）および既存会員のプロフィール編集の両方に対応する。

### 本画面の処理概要

プロフィール処理画面は、イントラネット（会員専用エリア）の会員がログイン情報や連絡先情報などのプロフィールを編集・更新する機能を提供する。また、新規会員登録時のアクティベーションリンクからアクセスした場合は、初期プロフィール設定として機能する。

**業務上の目的・背景**：会員制サイトでは、会員自身がプロフィール情報を管理できることが重要である。メールアドレスやパスワードの変更、連絡先情報の更新など、セルフサービスで対応できることで、サイト運営者の管理負担を軽減し、会員の利便性を向上させる。QuickerSiteでは、管理者が定義したカスタムフィールドを含む柔軟なプロフィール管理機能を提供する。

**画面へのアクセス方法**：
- 既存会員：イントラネット内の「マイプロフィール」リンクから
- 新規会員：アクティベーションメールのリンクから（`default.asp?pageAction=profile&ac={チケット}`）

**主要な操作・処理内容**：
1. アクティベーションチケット（ac）がある場合は、新規登録モード
2. 既存会員の場合は、現在のプロフィール情報を表示
3. メールアドレス、パスワード、ニックネームの編集
4. 管理者定義のカスタムフィールドの編集
5. プライベートメッセージ許可設定
6. 保存時にCSRF検証とデータバリデーション
7. 新規会員の場合は本登録完了後にウェルカムページへリダイレクト

**画面遷移**：
- 遷移元：アクティベーションリンク、イントラネットメニュー
- 遷移先（新規保存成功）：ウェルカムページ（pageAction=welcome）
- 遷移先（更新成功）：同画面にfb_saveOKメッセージ表示

**権限による表示制御**：
- イントラネット機能とマイプロフィール機能が有効な場合のみアクセス可能
- アクティベーションチケットがある場合は未認証でもアクセス可能
- 認証済み会員は自身のプロフィールのみ編集可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 107 | 会員プロフィール編集 | 主機能 | ログイン会員の自身のプロフィール編集 |

## 画面種別

編集フォーム

## URL/ルーティング

```
# 新規会員（アクティベーション）
/default.asp?pageAction=profile&ac={チケット}

# 既存会員
/default.asp?pageAction=profile
```

## 入出力項目

### 入力項目（リクエストパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| アクティベーションコード | ac | String | 任意 | 新規登録時のチケット |

### 入力項目（フォーム）

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| CSRFトークン | QS_secCodeHidden | hidden | 必須 | - | セキュリティトークン |
| ページアクション | pageAction | hidden | 必須 | - | 固定値「profile」 |
| チケット | ac | hidden | 条件付 | - | アクティベーションコード |
| メールアドレス | sEmail | email | 必須 | 50 | ログイン用メールアドレス |
| パスワード | sPw | password | 必須 | 20 | ログイン用パスワード |
| ニックネーム | sNickName | text | 必須 | 50 | 表示名 |
| PM許可 | bGetEmailsFromSite | radio | 必須 | - | プライベートメッセージ許可 |
| カスタムフィールド | (暗号化ID) | 可変 | 条件付 | - | 管理者定義フィールド |

### 出力項目

| 項目名 | 説明 |
|------|------|
| ページタイトル | customer.intranetMyProfile |
| 説明テキスト | customer.sExplProfile |

## 表示項目

### 基本情報セクション

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| メールアドレス | input[type=email] | 幅指定なし、サイズ30 |
| パスワード | input[type=password] | サイズ30、最大20文字 |
| ニックネーム | input[type=text] | サイズ30、最大50文字 |
| PM許可 | radio | Yes/Noの選択 |

### カスタムフィールドセクション

管理者がcontactFieldsで定義したフィールドタイプに応じて動的に表示：
- text, url, email: input[type=text]
- richtext: FCKEditorインスタンス
- textarea: textarea要素
- checkbox: input[type=checkbox]
- select: select要素
- date: datepicker付きinput
- comment: 静的テキスト表示

## イベント仕様

### 1-プロフィール保存

**トリガー**: 保存ボタン（btnaction=save）をクリック

**処理内容**:
1. checkCSRF()でCSRF検証
2. logon.contact.getRequestValues()でフォーム値を取得
3. 新規登録でメールアドレス一致の場合はallowDE=trueで重複許可
4. logon.contact.save()で保存：
   - メールアドレス形式検証
   - 重複チェック
   - パスワード、ニックネーム検証
5. 成功時：
   - Cookie設定（sPw、sEmail）
   - 新規登録の場合：チケット削除、管理者通知メール送信
   - デフォルトステータス設定
   - 新規：ウェルカムページへリダイレクト / 既存：成功メッセージ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プロフィール保存（新規） | tblContact | INSERT | 会員情報の新規登録 |
| プロフィール保存（更新） | tblContact | UPDATE | 会員情報の更新 |
| チケット削除 | tblContactRegistration | DELETE | アクティベーション完了後 |

### テーブル別更新項目詳細

#### tblContact（INSERT/UPDATE）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT/UPDATE | sEmail | フォーム入力値 | ログインID |
| INSERT/UPDATE | sPw | フォーム入力値 | パスワード |
| INSERT/UPDATE | sNickName | フォーム入力値 | 表示名 |
| INSERT/UPDATE | bGetEmailsFromSite | フォーム入力値 | PM許可フラグ |
| INSERT/UPDATE | iStatus | customer.iDefaultStatus | 新規登録時のみ |
| UPDATE | sOrigEmail | 元のメールアドレス | メール変更時 |

## メッセージ仕様

| 種別 | メッセージID | メッセージ | 発生条件 |
|------|------------|----------|---------|
| 成功 | fb_saveOK | 保存完了 | プロフィール保存成功 |
| エラー | err_email | メールアドレスエラー | 形式不正または重複 |
| エラー | err_pw | パスワードエラー | 未入力または不正 |
| エラー | err_nickname | ニックネームエラー | 未入力または不正 |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| イントラネット無効 | ホームページにリダイレクト |
| マイプロフィール無効 | ホームページにリダイレクト |
| 無効なチケット | ログイン画面にリダイレクト（err_wrongactivationlink） |
| 未認証＋チケットなし | ログイン画面にリダイレクト |

## 備考

- 新規会員登録時は管理者に通知メールを送信（customer.bSendMailUponNewMember設定時）
- アバター機能有効時はアバターアップロードリンクを表示
- カスタムフィールドはbProfile=trueのもののみ表示
- 日付フィールドはJQuery Datepickerを使用
- リッチテキストはFCKEditorを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | cls_contactクラス、save、getRequestValues |
| 1-2 | contactField.asp | `asp/includes/contactField.asp` | cls_contactFieldクラス（カスタムフィールド） |
| 1-3 | ticket.asp | `asp/includes/ticket.asp` | cls_ticketクラス、pickByTicket |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_profile.asp | `asp/process_profile.asp` | メインファイル、保存処理、フォーム生成 |

**主要処理フロー**:
1. **2-9行目**: チケット検証、認証チェック
2. **11-13行目**: チケットからメール取得
3. **14行目**: カスタムフィールド取得
4. **15-46行目**: 保存処理
5. **48-117行目**: フォームHTML生成

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_profile.asp | `asp/process_profile.asp` 15-46行目 | 保存処理分岐 |
| 3-2 | contact.asp | `asp/includes/contact.asp` | saveメソッド |

**主要処理フロー**:
- **16行目**: checkCSRF()
- **17行目**: getRequestValues()でフォーム値取得
- **19行目**: 重複メールアドレス許可判定
- **20行目**: save()実行
- **25-35行目**: 新規会員の追加処理（チケット削除、通知メール）

### プログラム呼び出し階層図

```
default.asp
    |
    +-- process.asp
            +-- [intranetUse && intranetUseMyProfile]
                    +-- [pageAction="profile"] process_profile.asp
                            |
                            +-- ticket.pickByTicket(ac)
                            +-- [未認証＋無効チケット] リダイレクト
                            |
                            +-- customer.contactFields()
                            |
                            +-- [btnaction="save"]
                            |       +-- checkCSRF()
                            |       +-- logon.contact.getRequestValues()
                            |       +-- logon.contact.save()
                            |       +-- [成功] Cookie設定
                            |       +-- [新規] ticket.remove()
                            |       +-- [新規] 管理者通知メール
                            |       +-- [新規] デフォルトステータス設定
                            |
                            +-- フォームHTML生成
                                    +-- 基本項目（Email, PW, Nick）
                                    +-- カスタムフィールドループ
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request.ac ─────────▶ ticket.pickByTicket()
        |                   |
        |                   ▼
        |           認証状態チェック
        |                   |
        ▼                   ▼
Request.Form ──────▶ getRequestValues()
        |                   |
        |                   ▼
        |           バリデーション
        |                   |
        |                   ▼
        |           tblContact INSERT/UPDATE
        |                   |
        |                   ▼
        |           [新規] tblContactRegistration DELETE
        |                   |
        |                   ▼
        |           Cookie設定
        |                   |
        └───────────────────────────▶ リダイレクト/再表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_profile.asp | `asp/process_profile.asp` | ソース | メイン処理ファイル |
| contact.asp | `asp/includes/contact.asp` | ソース | cls_contactクラス |
| contactField.asp | `asp/includes/contactField.asp` | ソース | cls_contactFieldクラス |
| ticket.asp | `asp/includes/ticket.asp` | ソース | cls_ticketクラス |
| logonEdit.asp | `asp/includes/logonEdit.asp` | ソース | logon.contactへのアクセス |
| customer.asp | `asp/includes/customer.asp` | ソース | contactFields、設定値 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | 管理者通知メール |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | リッチテキストエディタ |
