# 画面設計書 169-配信停止処理

## 概要

本ドキュメントは、QuickerSite CMSにおける配信停止処理画面（process_unsubscribe.asp）の画面設計書である。この画面は、ニュースレターの購読解除処理を行う機能を提供する。

### 本画面の処理概要

配信停止処理画面は、ニュースレター購読者が購読解除リンクをクリックした際に、購読状態を非アクティブに更新し、フィードバックメッセージを表示する機能を提供する。

**業務上の目的・背景**：電子メールマーケティングにおいて、購読者に簡単な購読解除手段を提供することは法的要件（CAN-SPAM法、GDPR等）であると同時に、ユーザーエクスペリエンスの観点からも重要である。QuickerSiteでは、ニュースレターメールに含まれる一意のキーを使用して、ワンクリックで購読解除できる仕組みを提供する。解除時には、管理者への通知メールを送信するオプションも用意されている。

**画面へのアクセス方法**：
- ニュースレターメール内の購読解除リンクから
- URL形式: `default.asp?pageAction=unsubscribe&e={24文字のキー}`

**主要な操作・処理内容**：
1. URLパラメータ（e）から24文字のキーを取得
2. tblNewsletterCategorySubscriberテーブルからキーでレコードを検索
3. 対応するニュースレターカテゴリ情報を取得
4. 購読者のbActiveフラグをfalseに更新
5. カスタマイズされた購読解除完了メッセージを表示
6. 管理者への通知メールを送信（設定時）

**画面遷移**：
- 遷移元：ニュースレターメール内の購読解除リンク
- 遷移先：なし（完了メッセージを表示して終了）
- エラー時：ホームページにリダイレクト

**権限による表示制御**：
- 認証不要（キーによる認可）
- 有効なキーを持つユーザーのみ処理可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 108 | ニュースレター購読解除 | 主機能 | ニュースレターの購読解除処理 |

## 画面種別

処理完了表示

## URL/ルーティング

```
/default.asp?pageAction=unsubscribe&e={24文字のキー}
```

## 入出力項目

### 入力項目（リクエストパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 長さ | 説明 |
|--------|-------------|-----|------|------|------|
| 購読解除キー | e | String | 必須 | 24 | 購読者固有のキー |

### 出力項目

| 項目名 | 説明 |
|------|------|
| ページタイトル | sUnsubscribeFBTitle（プレースホルダー置換済み） |
| ページ本文 | sUnsubscribeFB（プレースホルダー置換済み） |

## 表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| タイトル | テキスト | カテゴリ設定のsUnsubscribeFBTitle |
| 本文 | HTML | カテゴリ設定のsUnsubscribeFB |

### プレースホルダー

表示テキスト内で以下のプレースホルダーが使用可能：
- `[NL_NAME]`: 購読者名に置換
- `[NL_EMAIL]`: 購読者メールアドレスに置換

## イベント仕様

### 1-購読解除処理

**トリガー**: pageAction=unsubscribe&e={キー}でアクセス

**処理内容**:
1. キーの長さが24文字かチェック
2. tblNewsletterCategorySubscriberからキーでレコード検索
3. レコードが見つかった場合：
   - cls_newslettercategoryでカテゴリ情報取得
   - bActive=falseでない場合、falseに更新
   - 既に非アクティブの場合はホームページにリダイレクト
4. 購読解除完了メッセージを設定（プレースホルダー置換）
5. 管理者通知メール送信（sNotifEmail設定時）
6. レコードが見つからない場合：ホームページにリダイレクト

**画面遷移**:
- 成功：完了メッセージ表示
- 失敗/既解除：ホームページにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| キー検索 | tblNewsletterCategorySubscriber | SELECT | 購読者情報取得 |
| 購読解除 | tblNewsletterCategorySubscriber | UPDATE | bActive=false更新 |
| カテゴリ取得 | tblNewsletterCategory | SELECT | カテゴリ情報取得 |

### テーブル別更新項目詳細

#### tblNewsletterCategorySubscriber（UPDATE）

| 操作 | 項目（カラム名） | 更新値 | 条件 |
|-----|-----------------|-------|------|
| UPDATE | bActive | false | iCustomerID = cId AND sKey = {キー} |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|---------|
| 完了 | sUnsubscribeFB | 購読解除成功時（カテゴリ設定） |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| キーが24文字でない | ホームページにリダイレクト |
| キーが見つからない | ホームページにリダイレクト |
| カテゴリが見つからない | ホームページにリダイレクト |
| 既に購読解除済み | ホームページにリダイレクト |

## 備考

- キーは購読登録時に自動生成される24文字の一意文字列
- bActive=falseで購読解除（レコード削除ではない）
- 管理者通知メールには解除者のメールアドレスと名前が含まれる
- sUnsubscribeFB、sUnsubscribeFBTitleはカテゴリ編集画面で設定
- 物理削除ではないため、再購読時は同じレコードを再アクティブ化可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | cls_newslettercategoryクラス、sUnsubscribeFB等 |

**読解のコツ**: ニュースレターカテゴリには購読解除時の表示設定（タイトル、本文）と通知設定（sNotifEmail）が含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_unsubscribe.asp | `asp/process_unsubscribe.asp` | メインファイル、購読解除処理 |

**主要処理フロー**:
1. **2行目**: キー長チェック（24文字）
2. **5行目**: tblNewsletterCategorySubscriberからSELECT
3. **6行目**: レコード存在チェック
4. **8-9行目**: cls_newslettercategoryでカテゴリ取得
5. **10行目**: カテゴリ存在チェック
6. **12-18行目**: 完了メッセージ生成（プレースホルダー置換）
7. **21-26行目**: bActive更新
8. **27-34行目**: 管理者通知メール送信

### プログラム呼び出し階層図

```
default.asp
    |
    +-- process.asp
            +-- [pageAction="unsubscribe"] process_unsubscribe.asp
                    |
                    +-- [キー長チェック] len(e)==24?
                    |       +-- [NG] redirectToHP()
                    |
                    +-- db.execute() キー検索
                    |       +-- [見つからない] redirectToHP()
                    |
                    +-- cls_newslettercategory.pick()
                    |       +-- [見つからない] redirectToHP()
                    |
                    +-- [既に非アクティブ?]
                    |       +-- [Yes] redirectToHP()
                    |
                    +-- db.execute() bActive=false更新
                    |
                    +-- [sNotifEmail設定?]
                    |       +-- cls_mail_message 通知送信
                    |
                    +-- pageBody/pageTitle設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request.e ─────────▶ キー長チェック（24文字）
        |                   |
        |                   ▼
        |           tblNewsletterCategorySubscriber SELECT
        |                   |
        |                   ▼
        |           cls_newslettercategory.pick()
        |                   |
        |                   ▼
        |           bActiveチェック
        |                   |
        |                   ▼
        |           tblNewsletterCategorySubscriber UPDATE
        |                   |
        |                   ▼
        |           [sNotifEmail?]──▶ 管理者通知メール
        |                   |
        |                   ▼
        |           pageBody/pageTitle設定
        |                   |
        └───────────────────────────▶ 完了メッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_unsubscribe.asp | `asp/process_unsubscribe.asp` | ソース | メイン処理ファイル |
| newsletterCategory.asp | `asp/includes/newsletterCategory.asp` | ソース | cls_newslettercategoryクラス |
| process.asp | `asp/process.asp` | ソース | pageAction分岐 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | 管理者通知メール |
| functions.asp | `asp/includes/functions.asp` | ソース | redirectToHP、cleanup、convertStr等 |
