# 画面設計書 17-パスワード適用

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「パスワード適用」画面の設計仕様を定義するものである。

### 本画面の処理概要

パスワード適用画面は、個別のページにパスワード保護を設定するための画面である。パスワードを設定することで、そのページの閲覧に認証が必要になる。また、設定したパスワードは子ページにも適用される。

**業務上の目的・背景**：
Webサイトには会員限定コンテンツや社内向け情報など、アクセスを制限すべきページが存在する。本画面は、サイト全体ではなく特定のページ（およびその子ページ）に対してパスワード保護を設定する機能を提供する。これにより、柔軟なアクセス制御を実現し、コンテンツの機密性を確保できる。

**画面へのアクセス方法**：
1. バックサイトにログイン後、対象ページのセキュリティ設定へアクセス
2. URLパラメータとして暗号化されたページID（iId）が渡される
3. バックサイトヘッダーのセキュリティメニューから遷移可能

**主要な操作・処理内容**：
1. パスワードの入力（3〜15文字）
2. パスワードの保存（個別ページへの適用）
3. パスワードの削除（保護解除）
4. パスワードの一括削除（子ページも含めて解除）

**画面遷移**：
- 遷移元: 各ページ編集画面のセキュリティリンク、バックサイトホーム
- 遷移先（保存後）: バックサイトホーム（bs_default.asp）、イントラネット管理（bs_intranet.asp）

**権限による表示制御**：
- secondAdmin.bPagesPWがfalseの場合、画面へのアクセスが拒否される
- customer.sTotalPWが設定されている場合、サイト全体パスワードの説明メッセージを表示し、個別パスワードは設定不可
- page.parentPage.sPwが設定されている場合、親からの継承のため削除オプションが非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | ページパスワード保護 | 主機能 | 個別ページへのパスワード保護設定 |

## 画面種別

設定画面

## URL/ルーティング

```
asp/bs_applyPW.asp?iId={暗号化されたページID}
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| iId | 入力（hidden） | String | Yes | 暗号化されたページID |
| sPw | 入力（text） | String | Yes | パスワード（3〜15文字） |
| btnaction | 入力（submit） | String | Yes | アクション種別 |
| QS_secCodeHidden | 入力（hidden） | String | Yes | CSRF対策トークン |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| パスワード入力欄 | 入力フィールド | 8文字幅、最大15文字 |
| 保存ボタン | ボタン | パスワードの保存 |
| 削除ボタン | ボタン | パスワードの削除（親パスワードなし時のみ） |
| 全削除ボタン | ボタン | 子ページ含む一括削除（親パスワードなし時のみ） |
| サイト全体PW説明 | テキスト | sTotalPW設定時の説明メッセージ |

## イベント仕様

### 1-パスワード保存ボタン押下（save_pw）

1. フォームをPOST送信
2. btnaction=l("save_pw")でbs_processPage.aspの処理が実行
3. checkCSRF()でCSRFトークン検証
4. パスワード長チェック（3文字未満でエラー）
5. パスワードを小文字に変換して保存
6. page.resetAllSubPasswords(page.iId)で子ページにも同じパスワードを適用
7. バックサイトホームまたはイントラネット管理にリダイレクト

### 2-パスワード削除ボタン押下（delete_pw）

1. フォームをPOST送信
2. btnaction=l("delete_pw")でbs_processPage.aspの処理が実行
3. checkCSRF()でCSRFトークン検証
4. page.sPw=""でパスワードをクリア
5. page.save()で保存
6. バックサイトホームまたはイントラネット管理にリダイレクト

### 3-パスワード全削除ボタン押下（delete_pw_all）

1. フォームをPOST送信
2. btnaction=l("delete_pw_all")でbs_processPage.aspの処理が実行
3. checkCSRF()でCSRFトークン検証
4. page.sPw=""でパスワードをクリア
5. page.removeAllSubPasswords(page.iId)で子ページのパスワードも削除
6. バックサイトホームまたはイントラネット管理にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パスワード保存 | tblPage | UPDATE | 対象ページのパスワードを設定 |
| パスワード保存 | tblPage | UPDATE | 子ページのパスワードを同期 |
| パスワード削除 | tblPage | UPDATE | 対象ページのパスワードをクリア |
| パスワード全削除 | tblPage | UPDATE | 対象＋子ページのパスワードをクリア |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPw | lcase(request.form("sPw")) | パスワード（小文字化） |
| UPDATE | sPw | "" | 削除時は空文字 |
| UPDATE | updatedTS | now() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| err_pw | エラー | パスワード3文字未満 | パスワードは3文字以上必要です |
| pwexpl | 説明 | sTotalPW設定時 | サイト全体のパスワードが設定されています |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | logon.hasaccess(secondAdmin.bPagesPW)でアクセス拒否 |
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| パスワード3文字未満 | エラーメッセージ表示、保存中止 |
| CSRFトークン不正 | checkCSRF()でエラー処理 |

## 備考

- パスワードは小文字に統一されて保存される
- サイト全体パスワード（customer.sTotalPW）が設定されている場合、個別ページのパスワード設定は不可
- 親ページのパスワードが設定されている場合、削除ボタンは非表示（継承されるため）
- 子ページへのパスワード伝播はresetAllSubPasswords()メソッドで実行
- イントラネットページの場合、bs_backIntranet.aspで追加のナビゲーションを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面構成を理解する

パスワード適用画面の表示内容を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_applyPW.asp | `asp/bs_applyPW.asp` | 画面構成、条件分岐、フォーム表示 |

**読解のコツ**: customer.sTotalPWとpage.parentPage.sPwによる条件分岐に注目。

#### Step 2: パスワード保存処理を理解する

パスワード設定の処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_processPage.asp | `asp/bs_processPage.asp` | save_pw/delete_pw/delete_pw_all処理（行45-81） |

**主要処理フロー**:
1. **行45-60**: save_pwケース - パスワード長チェック、小文字変換、保存、子ページ同期
2. **行61-70**: delete_pwケース - パスワードクリア、保存
3. **行71-81**: delete_pw_allケース - パスワードクリア、子ページも削除

#### Step 3: パスワード伝播処理を理解する

子ページへのパスワード継承の仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | page.asp | `asp/includes/page.asp` | resetAllSubPasswords()、removeAllSubPasswords()メソッド |

### プログラム呼び出し階層図

```
bs_applyPW.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bPagesPW)
    │
    ├─ bs_process.asp（共通処理）
    │
    ├─ [customer.sTotalPWチェック]
    │      └─ 設定あり → 説明メッセージ表示、フォーム非表示
    │
    └─ [フォーム送信時]
           │
           └─ bs_processPage.asp
                  │
                  ├─ [save_pw]
                  │      ├─ checkCSRF()
                  │      ├─ パスワード長チェック（3文字以上）
                  │      ├─ lcase()で小文字変換
                  │      ├─ page.save()
                  │      └─ resetAllSubPasswords()
                  │
                  ├─ [delete_pw]
                  │      ├─ checkCSRF()
                  │      ├─ page.sPw = ""
                  │      └─ page.save()
                  │
                  └─ [delete_pw_all]
                         ├─ checkCSRF()
                         ├─ page.sPw = ""
                         ├─ page.save()
                         └─ removeAllSubPasswords()
```

### データフロー図

```
[入力]                      [処理]                      [出力]

URLパラメータ(iId) ─────────▶ decrypt() ─────────────▶ ページID取得
                                  │
                                  ▼
                            cls_page.pick() ──────────▶ 現在のパスワード取得
                                  │
customer.sTotalPW ───────────────▶ 条件判定
                                  │
                            ┌─────┴─────┐
                            │           │
                      [設定あり]    [設定なし]
                            │           │
                            ▼           ▼
                      説明表示    フォーム表示
                                        │
パスワード入力 ──────────────────────────▶ request.form("sPw")
                                        │
                                        ▼
                                  lcase() ────────────▶ 小文字変換
                                        │
                                        ▼
                                  page.save() ────────▶ tblPage UPDATE
                                        │
                                        ▼
                           resetAllSubPasswords() ────▶ 子ページ UPDATE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_applyPW.asp | `asp/bs_applyPW.asp` | ソース | メイン画面処理 |
| bs_processPage.asp | `asp/bs_processPage.asp` | インクルード | パスワード保存・削除処理 |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 共通処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| bs_backIntranet.asp | `asp/bs_backIntranet.asp` | インクルード | イントラネット用ナビ |
