# 画面設計書 170-パスワード忘れ処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるパスワード忘れ処理画面（process_forgotPW.asp）の画面設計書である。この画面は、パスワードを忘れた会員に対して、パスワードリセットのためのメール送信機能を提供する。

### 本画面の処理概要

パスワード忘れ処理画面は、イントラネット（会員専用エリア）のパスワードを忘れた会員が、登録済みのメールアドレスを入力することで、新しいパスワードをメールで受け取ることができる機能を提供する。

**業務上の目的・背景**：会員制サイトにおいて、パスワードを忘れたユーザーへの対応は必須機能である。サポート担当者が手動でパスワードをリセットする方式では運用負荷が高くなるため、セルフサービスでパスワードを再発行できる仕組みが求められる。QuickerSiteでは、登録メールアドレスへの確認とCAPTCHA認証を組み合わせ、セキュリティを確保しながら自動的なパスワード再発行を実現している。

**画面へのアクセス方法**：
- イントラネットログイン画面の「パスワードを忘れた」リンクから
- URL形式: `default.asp?pageAction=forgotPW`

**主要な操作・処理内容**：
1. メールアドレス入力フォームを表示
2. CAPTCHA認証で自動リクエストを防止
3. 入力されたメールアドレスの存在確認
4. 新しいパスワードを生成してメール送信
5. イントラネットログイン画面にリダイレクト

**画面遷移**：
- 遷移元：イントラネットログイン画面
- 遷移先（成功）：イントラネットログイン画面（fb_emailFoundメッセージ付き）
- 遷移先（失敗）：同画面にエラーメッセージ表示

**権限による表示制御**：
- イントラネット機能が有効な場合のみアクセス可能
- 認証不要（パスワード再発行のため）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 106 | パスワード再発行 | 主機能 | パスワードを忘れた会員への再発行処理 |

## 画面種別

入力フォーム

## URL/ルーティング

```
/default.asp?pageAction=forgotPW
```

## 入出力項目

### 入力項目（フォーム）

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| ページアクション | pageAction | hidden | 必須 | - | 固定値「forgotPW」 |
| メールアドレス | sEmail | email | 必須 | - | 登録済みメールアドレス |
| CAPTCHA | captcha | text | 必須 | 4 | 画像認証コード |

### 出力項目

| 項目名 | 説明 |
|------|------|
| ページタイトル | l("forgotPW")（多言語対応） |
| 説明テキスト | l("forgotPwExpl")（多言語対応） |

## 表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 説明テキスト | テキスト | パスワード再発行の説明 |
| メールアドレスラベル | テキスト | 「Email:」（多言語対応） |
| メールアドレス入力欄 | input[type=email] | 幅200px、サイズ30 |
| CAPTCHAラベル | テキスト | 「CAPTCHA:」（多言語対応） |
| CAPTCHA画像 | img | 認証用画像 |
| CAPTCHA入力欄 | input[type=text] | 幅63px、最大4文字 |
| 送信ボタン | submit | 「Send」（多言語対応） |

## イベント仕様

### 1-パスワードリセット送信

**トリガー**: 送信ボタンをクリック（pageAction=forgotPW）

**処理内容**:
1. CAPTCHA検証（Session("captcha")と入力値を比較）
2. CAPTCHA不一致の場合はerr_captchaエラー
3. logon.resetPW(sEmail)でパスワードリセット実行：
   - メールアドレスでtblContactを検索
   - 該当者がいれば新パスワードを生成
   - パスワード更新とメール送信
4. 成功時：イントラネットログイン画面にリダイレクト
5. 失敗時（メール未登録）：err_emailNotFoundエラー

**画面遷移**:
- 成功：`default.asp?pageAction=loginIntranet&iId={ホームページID}&fbMessage=fb_emailFound`
- 失敗：現在の画面を再表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| メールアドレス検索 | tblContact | SELECT | 登録会員の確認 |
| パスワード更新 | tblContact | UPDATE | 新パスワード設定 |

### テーブル別更新項目詳細

#### tblContact（UPDATE）

| 操作 | 項目（カラム名） | 更新値 | 条件 |
|-----|-----------------|-------|------|
| UPDATE | sPw | 新生成パスワード | sEmail = 入力値 AND iCustomerID = cId |

## メッセージ仕様

| 種別 | メッセージID | メッセージ | 発生条件 |
|------|------------|----------|---------|
| 成功 | fb_emailFound | メールアドレス確認・送信完了 | パスワードリセット成功 |
| エラー | err_captcha | CAPTCHA認証エラー | CAPTCHA不一致 |
| エラー | err_emailNotFound | メールアドレス未登録 | 該当する会員がいない |

## 例外処理

| 状態 | 処理内容 |
|------|---------|
| イントラネット無効 | ホームページにリダイレクト |
| CAPTCHA不一致 | err_captchaエラー表示 |
| メール未登録 | err_emailNotFoundエラー表示 |

## 備考

- CAPTCHA検証は大文字小文字を区別しない（LCase比較）
- 新パスワードはlogon.resetPWメソッド内で生成（GeneratePassWord等）
- パスワードリセットメールには新パスワードが平文で含まれる可能性（セキュリティ確認必要）
- フォーム送信後はJavaScriptでメール入力欄にフォーカス

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | cls_logonEditクラス、resetPWメソッド |
| 1-2 | contact.asp | `asp/includes/contact.asp` | cls_contactクラス、パスワード管理 |

**読解のコツ**: resetPWメソッドがパスワードリセットの中核処理。メールアドレスで会員を検索し、新パスワードを生成・更新・送信する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_forgotPW.asp | `asp/process_forgotPW.asp` | メインファイル、CAPTCHA検証、フォーム生成 |

**主要処理フロー**:
1. **2行目**: pageAction=forgotPWかチェック
2. **3行目**: CAPTCHA検証（Session比較）
3. **4行目**: CAPTCHA不一致でerr_captcha
4. **5行目**: logon.resetPW()実行
5. **6行目**: 成功時リダイレクト
6. **8行目**: 失敗時err_emailNotFound
7. **11-30行目**: フォームHTML生成

#### Step 3: パスワードリセット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logonEdit.asp | `asp/includes/logonEdit.asp` | resetPWメソッドの実装 |

**主要処理フロー**:
- メールアドレスでtblContact検索
- 該当者がいれば新パスワード生成
- tblContact更新
- パスワード通知メール送信

### プログラム呼び出し階層図

```
default.asp
    |
    +-- process.asp
            +-- [intranetUse]
                    +-- [pageAction="forgotPW"] process_forgotPW.asp
                            |
                            +-- [pageAction=forgotPW]
                            |       +-- CAPTCHA検証
                            |       |       +-- Session("captcha")比較
                            |       |       +-- [不一致] err_captcha
                            |       |
                            |       +-- logon.resetPW(sEmail)
                            |       |       +-- tblContact検索
                            |       |       +-- 新パスワード生成
                            |       |       +-- tblContact更新
                            |       |       +-- メール送信
                            |       |
                            |       +-- [成功] リダイレクト
                            |       +-- [失敗] err_emailNotFound
                            |
                            +-- フォームHTML生成
                                    +-- pageTitle設定
                                    +-- メール入力欄
                                    +-- CAPTCHA画像/入力欄
                                    +-- 送信ボタン
            |
            +-- [else] redirectToHP()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request.captcha ───▶ Session("captcha")比較
        |                   |
        |              [不一致]──▶ err_captcha
        |                   |
        ▼                   ▼
Request.sEmail ────▶ logon.resetPW()
        |                   |
        |                   ▼
        |           tblContact SELECT（メール検索）
        |                   |
        |              [見つからない]──▶ err_emailNotFound
        |                   |
        |                   ▼
        |           新パスワード生成
        |                   |
        |                   ▼
        |           tblContact UPDATE
        |                   |
        |                   ▼
        |           パスワード通知メール送信
        |                   |
        └───────────────────────────▶ リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_forgotPW.asp | `asp/process_forgotPW.asp` | ソース | メイン処理ファイル |
| logonEdit.asp | `asp/includes/logonEdit.asp` | ソース | resetPWメソッド |
| contact.asp | `asp/includes/contact.asp` | ソース | cls_contactクラス |
| process.asp | `asp/process.asp` | ソース | pageAction分岐・アクセス制御 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | パスワード通知メール |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| language.asp | `asp/includes/language.asp` | ソース | l()関数（多言語） |
| messages.asp | `asp/includes/messages.asp` | ソース | message.AddError |
| functions.asp | `asp/includes/functions.asp` | ソース | sanitize関数等 |
