# 画面設計書 171-カタログ処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるカタログ処理画面（process_catalog.asp）の設計仕様を記述したものである。本画面はフロントエンド側でカタログアイテムを一覧表示・検索するための処理を担当する。

### 本画面の処理概要

本画面は、公開サイト側でカタログ（商品・製品・サービスなど）を一覧表示し、ユーザーがカタログアイテムを検索・閲覧できるようにするための処理画面である。カタログ機能は、定型的な情報（商品名、価格、仕様など）を構造化して管理・表示するためのCMS機能であり、主にECサイトや製品カタログサイトで利用される。

**業務上の目的・背景**：カタログ機能は、多数のアイテム（商品・製品・サービスなど）を統一されたフォーマットで管理・表示する必要がある業務課題を解決する。管理者がバックサイトで登録したカタログアイテムを、サイト訪問者が検索・閲覧できるようにすることで、製品情報の効率的な配信と顧客の情報収集を支援する。

**画面へのアクセス方法**：サイトのページにカタログが紐付けられている場合、そのページにアクセスするとカタログ一覧が自動的に表示される。URLパラメータ `pageAction=catalog` を指定してフォーム送信することで検索が実行される。

**主要な操作・処理内容**：
1. カタログの公開状態チェック（bOnline）
2. 検索フィールドの動的生成（テキスト、日付、チェックボックス、セレクトボックス）
3. 検索条件に基づくカタログアイテムのフィルタリング
4. ページネーション処理によるアイテム一覧表示
5. 各アイテムの詳細情報（タイトル、日付、画像、カスタムフィールド、添付ファイル）の表示
6. フォームリンク（登録フォームへの遷移リンク）の表示

**画面遷移**：
- 遷移元：サイトトップページ（default.asp）からページ選択によりアクセス
- 遷移先：アイテムフォーム画面（pageAction=itemform）、アイテム詳細表示

**権限による表示制御**：カタログのbOnlineフラグがtrueの場合のみ表示される。オンライン期間（dOnlineFrom〜dOnlineUntill）内のアイテムのみが表示対象となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 101 | カタログ表示 | 主機能 | カタログ・商品一覧の表示処理 |
| 45 | カタログ一覧 | 補助機能 | カタログデータの取得 |
| 48 | カタログアイテム管理 | 補助機能 | アイテム情報の取得 |
| 49 | カタログアイテム検索 | 補助機能 | 検索条件によるフィルタリング |

## 画面種別

一覧（検索・ページネーション付き）

## URL/ルーティング

```
default.asp?pageAction=catalog&iID={暗号化ページID}
```

POST送信時のフォームパラメータ：
- `pageAction`: "catalog"
- `iID`: 暗号化されたページID
- `pageSize`: 1ページあたりの表示件数
- `absolutepage`: 現在のページ番号

## 入出力項目

### 入力項目（検索フォーム）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| アイテム名 | sTitle | text | - | アイテムタイトルの部分一致検索 |
| 検索フィールド | {暗号化フィールドID} | text/checkbox/select | - | カタログ定義の検索用フィールド |
| 日付フィールド | solo{暗号化フィールドID} | date | - | 日付型検索フィールド |
| ページサイズ | pageSize | hidden | - | 1ページあたりの表示件数 |
| 現在ページ | absolutepage | hidden | - | 現在表示中のページ番号 |

### 出力項目（カタログ一覧）

| 項目名 | 説明 |
|--------|------|
| アイテムタイトル | アイテムの日付とタイトル |
| アイテム画像 | サムネイル画像（存在する場合） |
| カスタムフィールド値 | カタログ定義の公開フィールド値 |
| 添付ファイルリンク | ファイルダウンロードリンク |
| フォームリンク | 登録フォームへの遷移リンク |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| 検索フォーム | catalog.bSearchable=true | フォーム要素 |
| ブラウズテーブル | 常時表示 | ページネーションナビ |
| アイテム画像 | sPicExtが存在する場合 | サムネイル画像 |
| フィールド値 | 値が存在する場合 | フィールドタイプに応じた表示 |
| ファイルリンク | fileTypes.count>0かつfiles存在時 | ダウンロードリンク |
| フォームリンク | catalog.iFormIDが設定かつitem.bForm=true | リンク |

## イベント仕様

### 1-検索ボタン押下

1. absolutepageを1にリセット
2. フォームをsubmit
3. process_catalog.aspが検索条件に基づきアイテムを抽出
4. 結果一覧を表示

### 2-リセットボタン押下

1. 現在ページのシンプルリンクに遷移
2. 検索条件がクリアされた状態で一覧表示

### 3-ページ送りボタン押下（<<, >>）

1. absolutepageを変更（-1または+1）
2. フォームをsubmit
3. 指定ページのアイテム一覧を表示

### 4-フォームリンク押下

1. pageAction=itemform、iPageID、iItemIDを指定して遷移
2. アイテム登録フォーム画面へ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索実行 | tblCatalogItem | SELECT | 検索条件に基づくアイテム取得 |
| 検索実行 | tbCatalogItemFields | SELECT | アイテムのフィールド値取得 |
| 検索実行 | tblCatalogField | SELECT | カタログフィールド定義取得 |
| 検索実行 | tblCatalogItemFiles | SELECT | アイテムの添付ファイル取得 |

### テーブル別更新項目詳細

本画面は参照専用のため、更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|--------------|
| resultsforsearch | 情報 | 検索結果0件 | "0 resultsforsearch" |

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| カタログがオフライン（bOnline=false） | カタログ一覧を表示しない |
| ページIDが無効 | トップページへリダイレクト |
| 検索結果0件 | 「0件」メッセージを表示 |

## 備考

- 検索フィールドは暗号化されたフィールドIDを使用してセキュリティを確保
- 日付フィールドはJQueryDatePickerを使用
- カタログアイテムのオンライン期間（dOnlineFrom〜dOnlineUntill）が考慮される
- 定数処理（treatConstants）が適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カタログ機能で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalog.asp | `asp/includes/catalog.asp` | cls_catalogクラスの構造、フィールド定義、ファイルタイプ定義 |
| 1-2 | catalogField.asp | `asp/includes/catalogField.asp` | cls_catalogFieldクラス、フィールドタイプの種類 |
| 1-3 | catalogItem.asp | `asp/includes/catalogItem.asp` | cls_catalogItemクラス、アイテムのプロパティとメソッド |
| 1-4 | itemSearch.asp | `asp/includes/itemSearch.asp` | cls_itemSearchクラス、検索ロジック |

**読解のコツ**: VBScriptクラスはClass〜End Classで定義される。プロパティはPublic/Private変数、メソッドはFunction/Subで定義。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_catalog.asp | `asp/process_catalog.asp` | カタログ一覧表示の全体フロー |

**主要処理フロー**:
1. **行3-7**: カタログオブジェクト取得、公開チェック、フィールド定義取得
2. **行8-13**: itemSearchオブジェクト初期化、検索条件取得
3. **行18-46**: 検索フォームHTML生成（bSearchable時のみ）
4. **行51-52**: 検索実行、結果アイテム取得、ブラウズテーブル生成
5. **行55-120**: アイテム一覧のHTML生成（ループ処理）

#### Step 3: 検索ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | itemSearch.asp | `asp/includes/itemSearch.asp` | fixedSQL関数でのSQL生成、resultItems関数での結果取得 |

**主要処理フロー**:
- **行42-113（fixedSQL）**: 検索条件を元にSQLを動的生成
- **行154-188（resultItems）**: ページネーション対応の結果取得
- **行189-206（browseTable）**: ページナビゲーションHTML生成

#### Step 4: アイテム表示ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | showPic関数での画像表示、filesプロパティでのファイル取得 |

**主要処理フロー**:
- **行18-40（showPic）**: サムネイル画像生成
- **行202-216（files）**: アイテムに紐付くファイル一覧取得

### プログラム呼び出し階層図

```
default.asp（ページ表示）
    │
    ├─ process_catalog.asp（インクルード）
    │      │
    │      ├─ selectedPage.catalog（cls_catalogオブジェクト取得）
    │      │      └─ catalog.fields("public")（公開フィールド取得）
    │      │      └─ catalog.fields("public,search")（検索フィールド取得）
    │      │      └─ catalog.fileTypes（ファイルタイプ取得）
    │      │
    │      ├─ cls_itemSearch（検索オブジェクト）
    │      │      └─ getRequestValues()（リクエスト値取得）
    │      │      └─ resultItems（検索結果取得）
    │      │      └─ browseTable（ページナビ生成）
    │      │
    │      └─ cls_catalogItem（各アイテム）
    │             └─ showPic()（画像表示）
    │             └─ files（ファイル一覧）
    │
    └─ treatConstants()（定数処理）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

検索条件             cls_itemSearch
(sTitle,フィールド値)  ───▶  .getRequestValues()  ───▶  inputFields/dateFields
     │                        │
     │                        ▼
     │               .fixedSQL()（SQL生成）
     │                        │
     │                        ▼
     │               .resultItems()（DB検索）
     │                        │
     │                        ▼
     │               cls_catalogItem（各アイテム）
     │                        │
     │                        ▼
     └──────────────▶  HTML生成（pageCatalog）  ───▶  画面出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_catalog.asp | `asp/process_catalog.asp` | ソース | カタログ表示メイン処理 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | カタログクラス定義 |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | カタログフィールドクラス |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | カタログアイテムクラス |
| catalogItemFile.asp | `asp/includes/catalogItemFile.asp` | ソース | アイテムファイルクラス |
| itemSearch.asp | `asp/includes/itemSearch.asp` | ソース | 検索処理クラス |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（encrypt, sanitize等） |
| insertConstants.asp | `asp/includes/insertConstants.asp` | ソース | 定数展開処理 |
