# 画面設計書 172-リストページ処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるリストページ処理画面（process_listpage.asp）の設計仕様を記述したものである。本画面はフロントエンド側でリストページ（ブログ、ニュース一覧など）のアイテムを展開・折りたたみ形式で表示するための処理を担当する。

### 本画面の処理概要

本画面は、リストページタイプのページにおいて、登録されたリストアイテムを一覧表示するための処理画面である。リストページは、ブログ記事一覧、ニュースリリース、FAQ、お知らせなど、複数のアイテムを時系列や任意の順序で表示するCMS機能であり、サイトの動的コンテンツ管理に広く利用される。

**業務上の目的・背景**：リストページ機能は、定期的に更新されるコンテンツ（ブログ、ニュース、FAQ等）を効率的に管理・表示する業務課題を解決する。サイト管理者がバックサイトで登録したリストアイテムを、展開・折りたたみ可能なUIで訪問者に提供することで、情報の整理された閲覧体験を実現する。

**画面へのアクセス方法**：サイトのページがリストページタイプとして設定されている場合、そのページにアクセスすると自動的にリストアイテム一覧が表示される。クエリストリング `item={暗号化アイテムID}` でアイテムを展開、`item=close` で全て閉じる操作が可能。

**主要な操作・処理内容**：
1. リストアイテムの取得（fastlistitems）
2. 展開/折りたたみ状態の判定（アコーディオン表示またはリスト表示）
3. 各アイテムのタイトル、日付、コンテンツ、画像の表示
4. 外部URLリンク（sLPExternalURL）の処理
5. フィード埋め込み（iFeedId）の処理
6. SEOタイトルの動的設定

**画面遷移**：
- 遷移元：サイトトップページ（default.asp）からページ選択によりアクセス
- 遷移先：同一ページ内でのアイテム展開/折りたたみ、外部URLへのリダイレクト

**権限による表示制御**：ページのオンライン状態（bOnline）およびパスワード保護設定に基づいて表示が制御される。iLPOpenByDefaultで初期展開アイテム数を設定可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 100 | リストページ表示 | 主機能 | 一覧形式ページ（ブログ等）の表示処理 |
| 13 | リストページ管理 | 補助機能 | リストアイテムデータの取得 |
| 54 | フィード作成・編集 | 補助機能 | 埋め込みフィードの表示 |

## 画面種別

一覧（アコーディオン/展開折りたたみ形式）

## URL/ルーティング

```
default.asp?iID={暗号化ページID}
default.asp?iID={暗号化ページID}&item={暗号化アイテムID}
default.asp?iID={暗号化ページID}&item=close
```

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ページID | iID | string | 必須 | 暗号化されたページID |
| アイテム指定 | item | string | - | 暗号化されたアイテムID、または"close" |

### 出力項目（リスト一覧）

| 項目名 | 説明 |
|--------|------|
| 展開/折りたたみアイコン | +/-アイコンまたはリンクアイコン |
| アイテムタイトル | 日付とタイトルの組み合わせ |
| アイテムコンテンツ | HTMLコンテンツ（sValue） |
| アイテム画像 | リストアイテム画像（存在する場合） |
| フィード内容 | 埋め込みフィード（iFeedId設定時） |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| +/-アイコン | 外部URLでない場合 | minus2.gif/plus2.gif |
| リンクアイコン | 外部URL設定時 | link.gif |
| アイテムタイトル | 常時表示 | sDateAndTitleプロパティ |
| アイテムコンテンツ | 展開状態の場合 | insertMedia処理後のHTML |
| アイテム画像 | listitemPicIMGTag存在時 | IMGタグ |
| フィードコンテンツ | iFeedId設定時 | Feed.build()結果 |

## イベント仕様

### 1-アイテムタイトルクリック（展開）

1. item={暗号化アイテムID}をURLパラメータに設定
2. ページリロード
3. 指定アイテムが展開された状態で表示
4. SEOタイトルがアイテムタイトル＋サイトタイトルに変更

### 2-アイテムタイトルクリック（折りたたみ）

1. item=closeをURLパラメータに設定
2. ページリロード
3. 全アイテムが折りたたまれた状態で表示

### 3-外部URLリンククリック

1. sLPExternalURLに遷移
2. bLPExternalOINWがtrueの場合は新しいウィンドウで開く

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | tblPage | SELECT | リストアイテムの取得（fastlistitems） |
| フィード表示 | tblFeed | SELECT | 埋め込みフィード情報取得 |

### テーブル別更新項目詳細

本画面は参照専用のため、更新処理は発生しない。

## メッセージ仕様

本画面にはユーザー向けメッセージは存在しない。

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| ページIDが無効 | トップページへリダイレクト |
| リストアイテムが0件 | 空のリストを表示 |

## 備考

- アコーディオンモード（bAccordeon）の場合は専用のgetAccordeonListを使用
- 日付非表示設定（bHideDate）がサポートされている
- 定数展開（treatConstants）が適用される
- 印刷モード（printReplies）では全アイテムが展開表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストページ機能で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのfastlistitems、listitems取得ロジック |
| 1-2 | feed.asp | `asp/includes/feed.asp` | cls_feedクラスのbuild()メソッド |

**読解のコツ**: VBScriptのDictionary（scripting.dictionary）でアイテムコレクションを管理。fastlistitemsはパフォーマンス最適化版。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_listpage.asp | `asp/process_listpage.asp` | リストページ表示の全体フロー |

**主要処理フロー**:
1. **行2-3**: pageListPage初期化、fastlistitems取得
2. **行5-10**: フォーム連携フラグ判定（pageHasForm）
3. **行12-81**: 通常モード（非アコーディオン）での各アイテム処理
4. **行82-87**: アコーディオンモード判定と処理
5. **行85-86**: 定数展開、プレースホルダ置換

#### Step 3: 展開/折りたたみロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_listpage.asp | `asp/process_listpage.asp` | 行36,43の条件分岐による展開判定 |

**展開条件**（行36,43）:
- printReplies=true（印刷モード）
- pageCondition=true（フォームPOSTでitem一致）
- LPCounter < iLPOpenByDefault（初期展開数以内）
- Request.QueryString("item")=encryptedListkey（URL指定）
- bOpenOnload=true かつ item未指定（全展開モード）

#### Step 4: 外部URL処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | process_listpage.asp | `asp/process_listpage.asp` | 行17,29-34,45-50の外部URL分岐 |

**主要処理フロー**:
- **行17**: isLPEU判定（外部URLが有効かどうか）
- **行29-34**: 外部URL時のリンクアイコンとtarget属性設定
- **行45-50**: 展開時の外部URLリンク生成

### プログラム呼び出し階層図

```
default.asp（ページ表示）
    │
    ├─ process_listpage.asp（インクルード）
    │      │
    │      ├─ selectedPage.fastlistitems（リストアイテム取得）
    │      │      └─ cls_page.fastlistitems（Dictionary）
    │      │
    │      ├─ 各リストアイテムの処理ループ
    │      │      ├─ selectedListItem.sDateAndTitle（タイトル取得）
    │      │      ├─ selectedListItem.listitemPicIMGTag（画像タグ）
    │      │      ├─ selectedListItem.page.insertMedia()（メディア挿入）
    │      │      └─ selectedListItem.Feed.build()（フィード表示）
    │      │
    │      ├─ アコーディオンモード分岐
    │      │      └─ selectedPage.getAccordeonList（アコーディオンHTML）
    │      │
    │      └─ treatConstants()（定数展開）
    │
    └─ 画面出力（pageListPage変数）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ         process_listpage.asp
(iID, item)     ───▶  fastlistitems取得       ───▶  listitems Dictionary
     │                        │
     │                        ▼
     │               展開/折りたたみ判定
     │               (LPCounter, item, bOpenOnload)
     │                        │
     │                        ▼
     │               各アイテムHTML生成
     │               (タイトル、コンテンツ、画像)
     │                        │
     │                        ▼
     └──────────────▶  treatConstants()      ───▶  pageListPage
                             │
                             ▼
                      プレースホルダ置換
                      ({#QSLP1#} → plus2.gif)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_listpage.asp | `asp/process_listpage.asp` | ソース | リストページ表示メイン処理 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| feed.asp | `asp/includes/feed.asp` | ソース | フィードクラス定義 |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（encrypt, convertBool等） |
| insertConstants.asp | `asp/includes/insertConstants.asp` | ソース | 定数展開処理 |
| plus2.gif | `fixedImages/plus2.gif` | 画像 | 折りたたみアイコン |
| minus2.gif | `fixedImages/minus2.gif` | 画像 | 展開アイコン |
| link.gif | `fixedImages/link.gif` | 画像 | 外部リンクアイコン |
