# 画面設計書 173-アイテム表示処理

## 概要

本ドキュメントは、QuickerSite CMSにおけるアイテム表示処理画面（process_showitem.asp）の設計仕様を記述したものである。本画面はフロントエンド側でカタログアイテムの詳細を表示するための処理を担当する。

### 本画面の処理概要

本画面は、カタログ機能においてURLパラメータで指定されたアイテムの詳細情報を表示するための処理画面である。カタログ一覧から個別アイテムを選択した際に、そのアイテムの完全な情報（タイトル、カスタムフィールド、画像、添付ファイル等）をテンプレートベースで表示する。

**業務上の目的・背景**：カタログ機能では、アイテム一覧から詳細ページへの遷移が必要である。本処理は、アイテムの詳細情報をカスタマイズ可能なテンプレート（sItemView）に基づいて表示することで、製品詳細ページや商品ページの柔軟な表示を実現する。

**画面へのアクセス方法**：カタログ一覧ページからアイテムをクリック、またはURLパラメータ `iItemID={暗号化アイテムID}` を指定してアクセスする。pageActionパラメータによりアイテム表示モードが決定される。

**主要な操作・処理内容**：
1. cls_catalogItemオブジェクトの生成と初期化
2. sFicheITEMVIEWプロパティによるテンプレートベース表示
3. SEOタイトルの動的設定（アイテムタイトル + カタログ名 + サイトタイトル）
4. ページタイトルの設定

**画面遷移**：
- 遷移元：カタログ処理画面（process_catalog.asp）、直接URL指定
- 遷移先：カタログ一覧への戻り、関連フォームへの遷移

**権限による表示制御**：カタログのオンライン状態、アイテムのオンライン期間に基づいて表示が制御される。無効なアイテムへのアクセスはトップページへリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 99 | ページ表示 | 主機能 | アイテム詳細ページの表示処理 |
| 48 | カタログアイテム管理 | 補助機能 | アイテム情報の取得 |
| 101 | カタログ表示 | 補助機能 | カタログ情報との連携 |

## 画面種別

詳細

## URL/ルーティング

```
default.asp?pageAction=showitem&iItemID={暗号化アイテムID}
```

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| アイテムID | iItemID | string | 必須 | 暗号化されたカタログアイテムID |
| ページアクション | pageAction | string | 必須 | "showitem"固定 |

### 出力項目（アイテム詳細）

| 項目名 | 説明 |
|--------|------|
| pageBody | テンプレートベースのアイテム詳細HTML |
| pageTitle | アイテムタイトル |
| sSEOTitle | SEO用タイトル（アイテム | カタログ | サイト） |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| アイテムタイトル | 常時表示 | {ITEMTITLE}プレースホルダ |
| アイテム日付 | 常時表示 | {ITEMDATE}プレースホルダ |
| アイテム画像 | 常時表示 | {ITEMPICTURE}プレースホルダ |
| 暗号化ID | 常時表示 | {ITEMENCID}プレースホルダ |
| カスタムフィールド | フィールド定義に基づく | {フィールド名}プレースホルダ |
| ファイルリンク | ファイルタイプ定義に基づく | {ファイルタイプ名}プレースホルダ |

## イベント仕様

### 1-ページロード

1. cls_catalogItemオブジェクト生成
2. リクエストパラメータからiItemIDを復号化
3. アイテム情報をデータベースから取得
4. sFicheITEMVIEWでテンプレート適用
5. pageBodyにHTML出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | tblCatalogItem | SELECT | アイテム基本情報取得 |
| ページ表示 | tbCatalogItemFields | SELECT | アイテムフィールド値取得 |
| ページ表示 | tblCatalogField | SELECT | フィールド定義取得 |
| ページ表示 | tblCatalogItemFiles | SELECT | 添付ファイル取得 |
| ページ表示 | tblCatalog | SELECT | カタログ定義取得 |

### テーブル別更新項目詳細

本画面は参照専用のため、更新処理は発生しない。

## メッセージ仕様

本画面にはユーザー向けメッセージは存在しない。

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| アイテムIDが無効 | default.aspへリダイレクト |
| カタログがオフライン | default.aspへリダイレクト |
| アイテムのbForm=false | default.aspへリダイレクト |
| 顧客ID不一致 | default.aspへリダイレクト |

## 備考

- cls_catalogItemのClass_Initializeでリクエストパラメータからアイテムを自動読み込み
- sFicheITEMVIEWはcatalog.sItemViewテンプレートに基づいて生成
- 定数展開（treatConstants）がテンプレート内で適用される
- SEOタイトルはsSeoTitleプロパティで自動生成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アイテム表示で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | cls_catalogItemクラスの全体構造 |
| 1-2 | catalog.asp | `asp/includes/catalog.asp` | cls_catalogクラス、sItemViewプロパティ |

**読解のコツ**: cls_catalogItemのClass_InitializeでRequest("iItemID")を復号化してpick()を呼び出す自動初期化に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_showitem.asp | `asp/process_showitem.asp` | アイテム表示の全体フロー（7行のみ） |

**主要処理フロー**:
1. **行2-3**: showItemオブジェクト生成（cls_catalogItem）
2. **行4**: sFicheITEMVIEWでテンプレートベース表示を取得
3. **行5**: pageTitleにアイテムタイトルを設定
4. **行6**: sSEOTitleにSEO用タイトルを設定
5. **行7**: showItemオブジェクト解放

#### Step 3: テンプレート展開ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | sFicheITEMVIEW関数（行275-310） |

**主要処理フロー**:
- **行276**: catalog.sItemViewテンプレート取得
- **行277-280**: 基本プレースホルダ置換（ITEMTITLE, ITEMDATE, ITEMPICTURE, ITEMENCID）
- **行281**: 定数展開（treatConstants）
- **行283-296**: カスタムフィールドのプレースホルダ置換
- **行298-308**: ファイルタイプのプレースホルダ置換

#### Step 4: セキュリティチェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | catalogItem.asp | `asp/includes/catalogItem.asp` | checkOnline関数（行371-384） |

**主要処理フロー**:
- **行372-374**: iIdが空の場合リダイレクト
- **行375-377**: 顧客ID不一致の場合リダイレクト
- **行378-380**: bForm=falseの場合リダイレクト
- **行381-383**: カタログがオフラインの場合リダイレクト

### プログラム呼び出し階層図

```
default.asp（ページ表示）
    │
    ├─ process_showitem.asp（インクルード）
    │      │
    │      └─ new cls_catalogItem（オブジェクト生成）
    │             │
    │             ├─ Class_Initialize（自動初期化）
    │             │      └─ pick(decrypt(request("iItemID")))
    │             │             └─ DBからアイテム情報取得
    │             │
    │             ├─ sFicheITEMVIEW（テンプレート展開）
    │             │      ├─ catalog.sItemView（テンプレート取得）
    │             │      ├─ replace()（プレースホルダ置換）
    │             │      ├─ treatConstants()（定数展開）
    │             │      └─ catalog.fields("public")（フィールド取得）
    │             │
    │             └─ sSeoTitle（SEOタイトル生成）
    │
    └─ 画面出力（pageBody, pageTitle, sSEOTitle）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iItemID              cls_catalogItem
(暗号化)      ───▶  Class_Initialize         ───▶  アイテムオブジェクト
     │               (decrypt, pick)
     │                        │
     │                        ▼
     │               sFicheITEMVIEW
     │               (テンプレート展開)
     │                        │
     │                        ├─ catalog.sItemView
     │                        ├─ {ITEMTITLE} → sTitle
     │                        ├─ {ITEMDATE} → dDate
     │                        ├─ {フィールド名} → fields(id)
     │                        └─ treatConstants()
     │                        │
     │                        ▼
     └──────────────▶  pageBody              ───▶  画面出力
                      pageTitle
                      sSEOTitle
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_showitem.asp | `asp/process_showitem.asp` | ソース | アイテム表示メイン処理 |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | カタログアイテムクラス |
| catalog.asp | `asp/includes/catalog.asp` | ソース | カタログクラス（テンプレート定義） |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | フィールド定義クラス |
| catalogItemFile.asp | `asp/includes/catalogItemFile.asp` | ソース | ファイル管理クラス |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（decrypt, convertEuroDate等） |
| insertConstants.asp | `asp/includes/insertConstants.asp` | ソース | 定数展開処理 |
