# 画面設計書 174-投稿表示処理

## 概要

本ドキュメントは、QuickerSite CMSにおける投稿表示処理画面（process_showpost.asp）の設計仕様を記述したものである。本画面はフロントエンド側でフォーラム/テーマの投稿（トピック・返信）を表示するための処理を担当する。

### 本画面の処理概要

本画面は、フォーラム/テーマ機能においてURLパラメータで指定された投稿の詳細を表示するための処理画面である。フォーラムのトピックや返信の内容、投稿者情報、添付ファイルなどを統一されたフォーマットで表示し、サイト訪問者がコミュニティコンテンツを閲覧できるようにする。

**業務上の目的・背景**：フォーラム/テーマ機能は、サイト訪問者同士のコミュニケーションやQ&A、ディスカッションを実現するための業務機能である。本処理は、投稿の詳細表示を提供することで、特定の投稿へのディープリンクやSNS共有、検索エンジンからのアクセスに対応する。

**画面へのアクセス方法**：フォーラムのトピック一覧から投稿をクリック、またはURLパラメータ `iPostID={暗号化投稿ID}` を指定してアクセスする。pageActionパラメータにより投稿表示モードが決定される。

**主要な操作・処理内容**：
1. cls_postオブジェクトの生成と初期化
2. buildShortPost()メソッドによる投稿表示HTML生成
3. SEOタイトルの動的設定（投稿タイトル）
4. ページタイトルの設定

**画面遷移**：
- 遷移元：テーマ/フォーラム一覧画面、検索結果、外部リンク
- 遷移先：テーマ一覧への戻り、返信投稿フォーム

**権限による表示制御**：テーマの検索タイプ（iSearchType）、イントラネット認証状態、投稿の検証状態（bNeedsToBeValidated）に基づいて表示が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 99 | ページ表示 | 主機能 | 投稿詳細ページの表示処理 |
| 89 | テーマ/フォーラム一覧 | 補助機能 | テーマ情報との連携 |
| 90 | テーマ/フォーラム作成・編集 | 補助機能 | 投稿設定の参照 |

## 画面種別

詳細

## URL/ルーティング

```
default.asp?pageAction=showpost&iPostID={暗号化投稿ID}
```

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 投稿ID | iPostID | string | 必須 | 暗号化された投稿ID |
| ページアクション | pageAction | string | 必須 | "showpost"固定 |

### 出力項目（投稿詳細）

| 項目名 | 説明 |
|--------|------|
| pageBody | 投稿詳細HTML（buildShortPost結果） |
| pageTitle | 投稿タイトル（sSubject） |
| sSEOTitle | SEO用タイトル（pageTitle） |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| 投稿タイトル | 常時表示 | QS_theme_subject DIV |
| 投稿本文 | 常時表示 | QS_theme_body DIV（HTMLまたはプレーンテキスト） |
| 投稿者情報 | 常時表示 | contact.sClickNickName |
| 投稿日時 | 常時表示 | formatTimeStamp(dUpdatedTS) |
| 添付ファイル | sFilename存在時 | ダウンロードリンク |
| 返信一覧 | bAllowComments=trueかつ返信存在時 | ネストされたリスト |
| アバター | customer.bUseAvatars=true時 | 画像 |

## イベント仕様

### 1-ページロード

1. cls_postオブジェクト生成
2. リクエストパラメータからiPostIDを復号化
3. 投稿情報をデータベースから取得
4. セキュリティチェック（iSearchType、認証状態、検証状態）
5. buildShortPost()で表示HTML生成
6. pageBodyにHTML出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | tblPost | SELECT | 投稿基本情報取得 |
| ページ表示 | tblTheme | SELECT | テーマ設定取得 |
| ページ表示 | tblContact | SELECT | 投稿者情報取得 |

### テーブル別更新項目詳細

本画面は参照専用のため、更新処理は発生しない。

## メッセージ仕様

本画面にはユーザー向けメッセージは存在しない。

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| テーマのiSearchType=0 | ホームページへリダイレクト |
| テーマのiSearchType=2かつ未認証 | ホームページへリダイレクト |
| bNeedsToBeValidated=true | ホームページへリダイレクト |

## 備考

- cls_postのClass_InitializeでリクエストパラメータからiPostIDを自動読み込み
- タイトル内の"["は"|R|R|R|"に置換（テンプレートプレースホルダとの競合回避）
- buildShortPost()はbuildPost()の簡略版で、返信フォームを含まない
- アバター表示はcustomer.bUseAvatarsで制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

投稿表示で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | post.asp | `asp/includes/post.asp` | cls_postクラスの全体構造、プロパティ |
| 1-2 | theme.asp | `asp/includes/theme.asp` | cls_themeクラス、iSearchType設定 |
| 1-3 | contact.asp | `asp/includes/contact.asp` | cls_contactクラス、sClickNickName |

**読解のコツ**: cls_postのprivateプロパティp_themeはキャッシュ用。theme()関数で遅延読み込み。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_showpost.asp | `asp/process_showpost.asp` | 投稿表示の全体フロー（6行のみ） |

**主要処理フロー**:
1. **行2-3**: showPostオブジェクト生成（cls_post）
2. **行4**: buildShortPost()で表示HTML生成
3. **行5**: pageTitleに投稿タイトル設定（特殊文字置換あり）
4. **行6**: sSEOTitleにpageTitleを設定

#### Step 3: buildShortPost関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | post.asp | `asp/includes/post.asp` | buildShortPost関数（行273-355） |

**主要処理フロー**:
- **行276-282**: セキュリティチェック（iSearchType、認証、検証状態）
- **行283-296**: 投稿タイトル部分のHTML生成
- **行297-307**: 投稿本文部分のHTML生成（bAllowHTMLで分岐）
- **行308**: 添付ファイルリンク生成
- **行309-343**: フッター（日時、投稿者）と返信一覧生成
- **行354**: 特殊文字置換（"[" → "|R|R|R|"）

#### Step 4: セキュリティチェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | post.asp | `asp/includes/post.asp` | buildShortPost内のセキュリティチェック（行276-282） |

**主要処理フロー**:
- **行276-277**: iSearchType=0（非公開）でリダイレクト
- **行278-279**: iSearchType=2（イントラネット限定）かつ未認証でリダイレクト
- **行280-281**: bNeedsToBeValidated=true（未承認）でリダイレクト

### プログラム呼び出し階層図

```
default.asp（ページ表示）
    │
    ├─ process_showpost.asp（インクルード）
    │      │
    │      └─ new cls_post（オブジェクト生成）
    │             │
    │             ├─ Class_Initialize（自動初期化）
    │             │      └─ pick(decrypt(request("iPostID")))
    │             │             └─ DBから投稿情報取得
    │             │
    │             ├─ buildShortPost()（表示HTML生成）
    │             │      ├─ セキュリティチェック
    │             │      │      ├─ theme.iSearchType判定
    │             │      │      ├─ logon.authenticatedIntranet判定
    │             │      │      └─ bNeedsToBeValidated判定
    │             │      │
    │             │      ├─ 投稿タイトル・本文生成
    │             │      │      ├─ contact.sClickNickName
    │             │      │      ├─ sFileLink（添付ファイル）
    │             │      │      └─ addSmilies/linkUrls
    │             │      │
    │             │      └─ 返信一覧生成
    │             │             └─ replies()
    │             │
    │             └─ sSubject（タイトル取得）
    │
    └─ 画面出力（pageBody, pageTitle, sSEOTitle）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iPostID              cls_post
(暗号化)      ───▶  Class_Initialize         ───▶  投稿オブジェクト
     │               (decrypt, pick)
     │                        │
     │                        ▼
     │               セキュリティチェック
     │               (iSearchType, 認証, 検証)
     │                        │
     │                        ▼
     │               buildShortPost()
     │                        │
     │                        ├─ タイトル生成
     │                        ├─ 本文生成（HTML/プレーン）
     │                        ├─ 添付ファイルリンク
     │                        └─ 返信一覧
     │                        │
     │                        ▼
     └──────────────▶  pageBody              ───▶  画面出力
                      pageTitle
                      sSEOTitle
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_showpost.asp | `asp/process_showpost.asp` | ソース | 投稿表示メイン処理 |
| post.asp | `asp/includes/post.asp` | ソース | 投稿クラス定義 |
| theme.asp | `asp/includes/theme.asp` | ソース | テーマクラス定義 |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先/ユーザークラス |
| logonEdit.asp | `asp/includes/logonEdit.asp` | ソース | ログオン管理クラス |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（addSmilies, linkUrls等） |
