# 画面設計書 175-ページ編集（FS）

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントサイドページ編集画面（fs_editPage.asp）の設計仕様を記述したものである。本画面はフロントエンド側（公開サイト側）から権限を持つユーザーがページ内容を直接編集するためのインライン編集機能を提供する。

### 本画面の処理概要

本画面は、サイトにログインした権限ユーザーが、バックサイト管理画面に移動することなく、公開サイト側から直接ページのタイトルやコンテンツを編集できるインライン編集機能を提供する。これにより、コンテンツ更新の効率が大幅に向上する。

**業務上の目的・背景**：CMSでのコンテンツ更新は、従来バックサイト管理画面への遷移が必要であった。フロントサイド編集（FS）機能は、この手間を削減し、「見たまま編集」を実現する。特に頻繁にコンテンツを更新する運用担当者の作業効率を向上させる。

**画面へのアクセス方法**：公開サイトにイントラネット認証でログインした状態で、編集権限を持つページの編集リンクをクリックするとポップアップまたは別ウィンドウで表示される。

**主要な操作・処理内容**：
1. ユーザーの編集権限チェック（getTper/getBper）
2. タイトル編集（getTper権限時）
3. コンテンツ編集（getBper権限時、WYSIWYGエディタ使用）
4. 外部URL設定（sExternalURL設定時）
5. 承認待ち機能（sNotifValidate設定時）
6. 保存処理とフィードバック表示

**画面遷移**：
- 遷移元：公開サイトの各ページ（インライン編集リンク）
- 遷移先：同一画面内で保存完了、または権限エラー時にnoaccess.htm

**権限による表示制御**：getTper（タイトル編集権限）、getBper（本文編集権限）のいずれかまたは両方を持つユーザーのみがアクセス可能。権限がない場合はnoaccess.htmへリダイレクト。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | フロントサイドからのインラインページ編集 |
| 117 | CSRF対策 | 補助機能 | セキュリティトークンによるリクエスト検証 |

## 画面種別

編集（ポップアップ/インライン）

## URL/ルーティング

```
asp/fs_editPage.asp?iId={暗号化ページID}
```

## 入出力項目

### 入力項目（フォーム）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ページID | iId | hidden | 必須 | 暗号化されたページID |
| ポストバック | postback | hidden | 必須 | true固定 |
| セキュリティトークン | QSSEC | hidden | 必須 | CSRFトークン |
| タイトル | sTitle | text | getTper権限時 | ページタイトル（最大100文字） |
| 外部URLプレフィックス | sExternalURLPrefix | select | getBper権限時 | http://、https://など |
| 外部URL | sExternalURL | text | getBper権限時 | リダイレクト先URL |
| 新規ウィンドウで開く | bOpenInNewWindow | checkbox | getBper権限時 | true/false |
| コンテンツ | sValue | textarea | getBper権限時 | WYSIWYGエディタ |

### 出力項目（フィードバック）

| 項目名 | 説明 |
|--------|------|
| 保存完了メッセージ | fb_saveOK |
| エラーメッセージ | 各種エラー |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| タイトル入力欄 | getTper権限あり | textbox |
| 外部URL設定 | getBper権限ありかつsExternalURLあり | select + textbox + checkbox |
| WYSIWYGエディタ | getBper権限ありかつsExternalURLなしかつコンテナでない | FCKEditor/CKEditor |
| 保存ボタン | 常時表示 | submit |
| 必須項目説明 | 常時表示 | (*) mandatory |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークン検証（checkCSRF）
2. getTper権限がある場合
   - sNotifValidate設定時：sTitleToBeValidatedに保存
   - 通常時：sTitleに保存
3. getBper権限がある場合
   - sNotifValidate設定時：sValueToBeValidatedに保存
   - 通常時：sValueに保存
   - 外部URL関連項目を保存
4. selectedPage.Save()実行
5. 成功時：fb_saveOKメッセージ表示
6. sNotifValidate設定時：管理者に承認依頼メール送信

### 2-承認待ちワークフロー（sNotifValidate設定時）

1. タイトル/本文を「承認待ち」フィールドに保存
2. 編集者情報（iUpdatedBy, dUpdatedOn）を記録
3. 管理者に通知メール送信
4. 画面表示は「承認待ち」の値を優先表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblPage | UPDATE | ページ情報更新 |
| 承認待ち保存 | tblPage | UPDATE | 承認待ちフィールド更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sTitle | フォーム入力値 | getTper権限時 |
| UPDATE | sTitleToBeValidated | フォーム入力値 | sNotifValidate設定時 |
| UPDATE | sValue | フォーム入力値 | getBper権限時 |
| UPDATE | sValueToBeValidated | フォーム入力値 | sNotifValidate設定時 |
| UPDATE | sExternalURLPrefix | フォーム入力値 | getBper権限時 |
| UPDATE | sExternalURL | フォーム入力値 | getBper権限時 |
| UPDATE | bOpenInNewWindow | フォーム入力値 | getBper権限時 |
| UPDATE | iUpdatedBy | logon.contact.iId | 承認待ち時 |
| UPDATE | dUpdatedOn | now() | 承認待ち時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存完了メッセージ |
| title | ラベル | getTper権限時 | "タイトル" |
| externalurl | ラベル | 外部URL設定時 | "外部URL" |
| openinnewwindow | ラベル | 外部URL設定時 | "新しいウィンドウで開く" |
| mandatory | ラベル | 常時 | "必須" |
| save | ラベル | 常時 | "保存" |

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| getTperもgetBperもなし | noaccess.htmへリダイレクト |
| CSRFトークン不一致 | エラー（checkCSRFで処理） |
| 保存失敗 | エラーメッセージ表示 |

## 備考

- WYSIWYGエディタはcreateFCKInstance関数で生成
- 承認待ちワークフローはcustomer.sNotifValidate設定時のみ有効
- 画面はonload="javascript:window.focus();"でフォーカス取得
- コンテナページ（bContainerPage=true）の場合はWYSIWYGエディタ非表示
- ユーザーファイルフォルダは自動作成（createUserFilesFolder）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フロントサイド編集で使用される権限構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | getTper、getBper権限Dictionary |
| 1-2 | logonEdit.asp | `asp/includes/logonEdit.asp` | logonクラス、contact取得 |
| 1-3 | page.asp | `asp/includes/page.asp` | cls_pageクラス、Save()メソッド |

**読解のコツ**: getTper/getBperはDictionaryで、ページIDをキーとして権限有無を管理。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fs_editPage.asp | `asp/fs_editPage.asp` | フロントサイド編集の全体フロー |

**主要処理フロー**:
1. **行1**: begin.aspインクルード（認証、ページオブジェクト初期化）
2. **行4-8**: フラグ初期化（pagetoemail, editPage, EPSuccess等）
3. **行11-13**: 権限Dictionary取得、ユーザーファイルフォルダ作成
4. **行15-54**: POSTバック処理（保存ロジック）
5. **行55-59**: 承認待ち値の優先表示処理
6. **行60-67**: フォーム表示（権限に応じた入力欄）
7. **行68**: 権限チェック後のリダイレクト

#### Step 3: 保存ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fs_editPage.asp | `asp/fs_editPage.asp` | 行15-54の保存処理 |

**主要処理フロー**:
- **行16**: CSRFチェック
- **行17-22**: getTper権限時のタイトル保存（承認待ち分岐）
- **行24-33**: getBper権限時のコンテンツ・外部URL保存
- **行34-53**: Save()実行、承認待ち時のメール送信

#### Step 4: 権限チェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | contact.asp | `asp/includes/contact.asp` | getTper、getBperプロパティ |

**主要処理フロー**:
- getTperP.exists(selectedPage.iId): タイトル編集権限チェック
- getBperP.exists(selectedPage.iId): 本文編集権限チェック

### プログラム呼び出し階層図

```
fs_editPage.asp
    │
    ├─ begin.asp（インクルード）
    │      ├─ cls_logonEdit（ログオン管理）
    │      ├─ cls_page（ページオブジェクト）
    │      └─ cls_customer（顧客設定）
    │
    ├─ 権限チェック
    │      ├─ logon.contact.getTper（タイトル権限Dictionary）
    │      └─ logon.contact.getBper（本文権限Dictionary）
    │
    ├─ POSTバック処理（保存）
    │      ├─ checkCSRF()（CSRF検証）
    │      ├─ selectedPage.sTitle/sTitleToBeValidated設定
    │      ├─ selectedPage.sValue/sValueToBeValidated設定
    │      ├─ selectedPage.Save()
    │      └─ cls_mail_message（承認待ち通知メール）
    │
    ├─ フォーム表示
    │      ├─ タイトル入力欄（getTper時）
    │      ├─ 外部URL設定（getBper時、sExternalURLあり）
    │      ├─ createFCKInstance（WYSIWYGエディタ）
    │      └─ 保存ボタン
    │
    └─ 権限なし時リダイレクト
           └─ Response.Redirect("asp/noaccess.htm")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          権限チェック
(sTitle, sValue)  ───▶  getTperP.exists()        ───▶  権限あり/なし
     │                  getBperP.exists()
     │                        │
     │                        ▼
     │               承認待ち判定
     │               (sNotifValidate)
     │                        │
     │            ┌───────────┴───────────┐
     │            ▼                       ▼
     │      通常保存                 承認待ち保存
     │      sTitle/sValue          sTitleToBeValidated
     │                             sValueToBeValidated
     │                                    │
     │                                    ▼
     │                             通知メール送信
     │                        │
     │                        ▼
     └──────────────▶  selectedPage.Save()  ───▶  DB更新
                             │
                             ▼
                      message.Add("fb_saveOK")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs_editPage.asp | `asp/fs_editPage.asp` | ソース | フロントサイドページ編集メイン |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード集約 |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先/権限管理クラス |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| logonEdit.asp | `asp/includes/logonEdit.asp` | ソース | ログオン管理クラス |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | WYSIWYGエディタ生成 |
| commonheader.asp | `asp/includes/commonheader.asp` | ソース | 共通ヘッダー |
| noaccess.htm | `asp/noaccess.htm` | HTML | 権限エラーページ |
