# 画面設計書 176-リストページ編集（FS）

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントサイドリストページ編集画面（fs_editListPage.asp）の設計仕様を記述したものである。本画面はフロントエンド側からリストページの設定（タイトル、ソート順、表示オプション等）を編集するための機能を提供する。

### 本画面の処理概要

本画面は、サイトにログインした権限ユーザーが、リストページ（ブログ、ニュース一覧等）の設定をフロントサイドから直接編集できる機能を提供する。リストページ固有の設定（アイテムのソート順、初期展開状態、RSS配信設定等）を管理者画面に移動せず変更可能。

**業務上の目的・背景**：リストページは動的コンテンツの管理に使用され、その表示設定（ソート順、展開状態等）を頻繁に変更するニーズがある。フロントサイド編集機能により、実際の表示を確認しながら設定を調整でき、運用効率が向上する。

**画面へのアクセス方法**：公開サイトにイントラネット認証でログインした状態で、リストページタイプのページの編集リンクをクリックするとポップアップまたは別ウィンドウで表示される。

**主要な操作・処理内容**：
1. ユーザーの編集権限チェック（getTper/getBper）
2. タイトル編集（getTper権限時）
3. リストページ設定編集（getBper権限時）
   - ソート順（sOrderBY）
   - 全アイテム展開（bOpenOnload）
   - 初期展開アイテム数（iLPOpenByDefault）
   - RSS配信（bPushRSS）
   - コンテンツ（sValue）
4. 保存処理とフィードバック表示

**画面遷移**：
- 遷移元：公開サイトのリストページ（インライン編集リンク）
- 遷移先：同一画面内で保存完了、または権限エラー時にnoaccess.htm

**権限による表示制御**：getTper（タイトル編集権限）、getBper（リストページ設定編集権限）のいずれかまたは両方を持つユーザーのみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | リストページ管理 | 主機能 | フロントサイドからのリストページ編集 |
| 117 | CSRF対策 | 補助機能 | セキュリティトークンによるリクエスト検証 |

## 画面種別

編集（ポップアップ/インライン）

## URL/ルーティング

```
asp/fs_editListPage.asp?iId={暗号化ページID}
```

## 入出力項目

### 入力項目（フォーム）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ページID | iId | hidden | 必須 | 暗号化されたページID |
| ポストバック | postback | hidden | 必須 | true固定 |
| セキュリティトークン | QSSEC | hidden | 必須 | CSRFトークン |
| タイトル | sTitle | text | getTper権限時 | ページタイトル（最大100文字） |
| ソート順 | sOrderBY | select | getBper権限時 | アイテムソート順 |
| 全アイテム展開 | bOpenOnload | checkbox | getBper権限時 | 初期表示で全アイテム展開 |
| 初期展開数 | iLPOpenByDefault | select | getBper権限時 | 初期展開するアイテム数（0-20） |
| RSS配信 | bPushRSS | checkbox | getBper権限時 | RSSフィード配信有効化 |
| コンテンツ | sValue | textarea | getBper権限時 | WYSIWYGエディタ |

### 出力項目（フィードバック）

| 項目名 | 説明 |
|--------|------|
| 保存完了メッセージ | fb_saveOK |
| エラーメッセージ | 各種エラー |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| タイトル入力欄 | getTper権限あり | textbox |
| ソート順選択 | getBper権限あり | select（orderByList） |
| 全アイテム展開チェック | getBper権限あり | checkbox |
| 初期展開数選択 | getBper権限ありかつbOpenOnload=false | select（0-20） |
| RSS配信チェック | getBper権限あり | checkbox |
| WYSIWYGエディタ | getBper権限あり | FCKEditor/CKEditor |
| 保存ボタン | 常時表示 | submit |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークン検証（checkCSRF）
2. getTper権限がある場合：sTitleを保存
3. getBper権限がある場合
   - sOrderBYを保存
   - bOpenOnloadを保存
   - iLPOpenByDefaultを保存
   - bPushRSSを保存
   - sValueを保存
4. selectedPage.Save()実行
5. 成功時：fb_saveOKメッセージ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblPage | UPDATE | リストページ情報更新 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sTitle | フォーム入力値 | getTper権限時 |
| UPDATE | sOrderBY | フォーム入力値 | getBper権限時 |
| UPDATE | bOpenOnload | フォーム入力値 | getBper権限時 |
| UPDATE | iLPOpenByDefault | フォーム入力値 | getBper権限時 |
| UPDATE | bPushRSS | フォーム入力値 | getBper権限時 |
| UPDATE | sValue | フォーム入力値 | getBper権限時 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存完了メッセージ |
| title | ラベル | getTper権限時 | "タイトル" |
| sortitemsby | ラベル | getBper権限時 | "ソート順" |
| openitems | ラベル | getBper権限時 | "アイテム展開" |
| ilpopenbydefault | ラベル | getBper権限時 | "初期展開数" |
| mandatory | ラベル | 常時 | "必須" |
| save | ラベル | 常時 | "保存" |

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| getTperもgetBperもなし | noaccess.htmへリダイレクト |
| CSRFトークン不一致 | エラー（checkCSRFで処理） |
| 保存失敗 | エラーメッセージ表示 |

## 備考

- ソート順選択肢はcls_orderByListクラスで定義
- 初期展開数は0-20の範囲でnumberList関数で生成
- bOpenOnload=trueの場合、iLPOpenByDefault設定欄は非表示
- bPushRSS=trueでリストアイテムがRSSフィードに含まれる
- WYSIWYGエディタはリストページのヘッダーコンテンツ用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストページ編集で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのリストページ関連プロパティ |
| 1-2 | orderBYlist.asp | `asp/includes/orderBYlist.asp` | cls_orderByListクラス、ソート順選択肢 |
| 1-3 | contact.asp | `asp/includes/contact.asp` | getTper、getBper権限Dictionary |

**読解のコツ**: リストページ固有のプロパティ（sOrderBY, bOpenOnload, iLPOpenByDefault, bPushRSS）に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fs_editListPage.asp | `asp/fs_editListPage.asp` | フロントサイドリストページ編集の全体フロー |

**主要処理フロー**:
1. **行1**: begin.aspインクルード
2. **行4-8**: フラグ初期化
3. **行11-13**: 権限Dictionary取得、ユーザーファイルフォルダ作成
4. **行15-33**: POSTバック処理（保存ロジック）
5. **行34-35**: orderByListオブジェクト生成
6. **行35-38**: フォーム表示（権限に応じた入力欄）
7. **行39**: 権限なし時リダイレクト

#### Step 3: 保存ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fs_editListPage.asp | `asp/fs_editListPage.asp` | 行15-33の保存処理 |

**主要処理フロー**:
- **行16**: CSRFチェック
- **行17-19**: getTper権限時のタイトル保存
- **行20-26**: getBper権限時のリストページ設定保存
- **行27-32**: Save()実行、フィードバック

#### Step 4: フォーム表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fs_editListPage.asp | `asp/fs_editListPage.asp` | 行35-38のフォーム生成 |

**主要処理フロー**:
- **行35-36**: タイトル入力欄（getTper権限時）
- **行37**: リストページ設定（getBper権限時）
  - ソート順選択: orderByList.showSelected
  - 全展開チェックボックス: bOpenOnload
  - 初期展開数選択: numberList(0,20,1,...)
  - RSS配信チェックボックス: bPushRSS
  - WYSIWYGエディタ: createFCKInstance

### プログラム呼び出し階層図

```
fs_editListPage.asp
    │
    ├─ begin.asp（インクルード）
    │      ├─ cls_logonEdit（ログオン管理）
    │      ├─ cls_page（ページオブジェクト）
    │      └─ cls_customer（顧客設定）
    │
    ├─ 権限チェック
    │      ├─ logon.contact.getTper（タイトル権限）
    │      └─ logon.contact.getBper（設定権限）
    │
    ├─ cls_orderByList（ソート順選択肢）
    │
    ├─ POSTバック処理（保存）
    │      ├─ checkCSRF()（CSRF検証）
    │      ├─ sTitle設定
    │      ├─ sOrderBY/bOpenOnload/iLPOpenByDefault/bPushRSS設定
    │      ├─ sValue設定
    │      └─ selectedPage.Save()
    │
    ├─ フォーム表示
    │      ├─ タイトル入力欄
    │      ├─ ソート順選択
    │      ├─ 全展開チェック
    │      ├─ 初期展開数選択（numberList）
    │      ├─ RSS配信チェック
    │      └─ createFCKInstance（WYSIWYGエディタ）
    │
    └─ 権限なし時リダイレクト
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          権限チェック
(sTitle,            getTperP.exists()        ───▶  権限あり/なし
 sOrderBY,          getBperP.exists()
 bOpenOnload,             │
 iLPOpenByDefault,        ▼
 bPushRSS,          プロパティ設定
 sValue)            selectedPage.xxx = ...
     │                        │
     │                        ▼
     └──────────────▶  selectedPage.Save()  ───▶  DB更新
                             │
                             ▼
                      message.Add("fb_saveOK")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs_editListPage.asp | `asp/fs_editListPage.asp` | ソース | フロントサイドリストページ編集メイン |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード集約 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| orderBYlist.asp | `asp/includes/orderBYlist.asp` | ソース | ソート順選択肢クラス |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先/権限管理クラス |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | WYSIWYGエディタ生成 |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（numberList等） |
| commonheader.asp | `asp/includes/commonheader.asp` | ソース | 共通ヘッダー |
