# 画面設計書 177-リストアイテム編集（FS）

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントサイドリストアイテム編集画面（fs_editListItem.asp）の設計仕様を記述したものである。本画面はフロントエンド側からリストページ内の個別アイテム（ブログ記事、ニュース等）を編集・作成・削除するための機能を提供する。

### 本画面の処理概要

本画面は、サイトにログインした権限ユーザーが、リストページ内の個別アイテムをフロントサイドから直接編集・作成・削除できる機能を提供する。新規アイテムの追加、既存アイテムのタイトル・日付・コンテンツ・外部URLの編集、およびアイテムの削除が可能。

**業務上の目的・背景**：リストページのアイテム（ブログ記事、ニュース等）は頻繁に追加・編集される。フロントサイド編集機能により、公開サイトを確認しながらコンテンツを管理でき、運用担当者の作業効率が大幅に向上する。

**画面へのアクセス方法**：リストアイテム一覧画面（fs_editListItems.asp）から「新規追加」または既存アイテムのリンクをクリックしてアクセス。

**主要な操作・処理内容**：
1. ユーザーの編集権限チェック（getLper）
2. アイテムタイトル編集（必須）
3. 日付設定（dPage、dOnlineFrom、dOnlineUntill）
4. ユーザーフレンドリーURL設定（bUserFriendlyURL有効時）
5. 外部URL/新規ウィンドウ設定
6. コンテンツ編集（WYSIWYGエディタ）
7. 保存処理
8. 削除処理

**画面遷移**：
- 遷移元：リストアイテム一覧画面（fs_editListItems.asp）
- 遷移先：保存/削除成功時にリストアイテム一覧画面へリダイレクト、権限エラー時にnoaccess.htm

**権限による表示制御**：getLper（リストページ権限）を持つユーザーのみがアクセス可能。権限がない場合はnoaccess.htmへリダイレクト。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | リストページ管理 | 主機能 | フロントサイドからのリストアイテム編集 |
| 117 | CSRF対策 | 補助機能 | セキュリティトークンによるリクエスト検証 |

## 画面種別

登録/編集

## URL/ルーティング

```
asp/fs_editListItem.asp?iId={暗号化アイテムID}
asp/fs_editListItem.asp?iListPageID={暗号化リストページID}（新規作成時）
```

## 入出力項目

### 入力項目（フォーム）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| アイテムID | iId | hidden | 必須 | 暗号化されたアイテムID |
| リストページID | iListPageID | hidden | 必須 | 暗号化されたリストページID |
| アクション | btnaction | hidden | 必須 | save_listitem固定 |
| セキュリティトークン | QSSEC | hidden | 必須 | CSRFトークン |
| タイトル | sTitle | text | 必須 | アイテムタイトル（最大255文字） |
| 日付 | dPage | text | - | アイテム日付（DatePicker） |
| 公開開始日 | dOnlineFrom | text | - | 公開開始日（DatePicker） |
| 公開終了日 | dOnlineUntill | text | - | 公開終了日（DatePicker） |
| ユーザーフレンドリーURL | sUserFriendlyURL | text | - | SEO対応URL（最大49文字） |
| 外部URL | sLPExternalURL | text | - | リダイレクト先URL |
| 新規ウィンドウ | bLPExternalOINW | checkbox | - | true/false |
| コンテンツ | sValue | textarea | - | WYSIWYGエディタ |
| 削除アクション | actionBtn | submit | - | delete値で削除実行 |

### 出力項目（フィードバック）

| 項目名 | 説明 |
|--------|------|
| 保存成功 | リストアイテム一覧へリダイレクト |
| エラーメッセージ | 各種エラー |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| リスト名 | 常時表示 | listPage.sTitle（太字） |
| タイトル入力欄 | 常時表示 | textbox（required） |
| 日付入力欄 | 常時表示 | DatePicker |
| 公開期間入力欄 | 常時表示 | DatePicker x 2 |
| ユーザーフレンドリーURL入力欄 | bUserFriendlyURL=true | textbox |
| 外部URL入力欄 | 条件付き | textbox + checkbox |
| WYSIWYGエディタ | 条件付き | FCKEditor/CKEditor |
| 保存ボタン | 常時表示 | submit |
| リセットボタン | 常時表示 | reset |
| 削除ボタン | iId存在時 | submit（確認ダイアログ付き） |

## イベント仕様

### 1-保存ボタン押下

1. CSRFトークン検証（フォーム内）
2. フォーム入力値をselectedPageプロパティに設定
3. 固定値設定（bLossePagina=false, bOnline=false）
4. selectedPage.save()実行
5. 成功時：fs_editListItems.aspへリダイレクト

### 2-削除ボタン押下

1. JavaScript確認ダイアログ表示
2. 確認時：
   - bDeleted=true
   - parentPage.removeRang()でランキング削除
   - iRang=0, bOnline=false, bHomepage=false
   - deleteListItems()で子アイテム削除
3. selectedPage.save()実行
4. fs_editListItems.aspへリダイレクト

### 3-リセットボタン押下

1. フォームを初期値にリセット

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存（新規） | tblPage | INSERT | リストアイテム新規作成 |
| 保存（更新） | tblPage | UPDATE | リストアイテム更新 |
| 削除 | tblPage | UPDATE | bDeleted=true、関連情報クリア |

### テーブル別更新項目詳細

#### tblPage（保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sTitle | フォーム入力値 | 必須 |
| INSERT/UPDATE | dPage | フォーム入力値（日付変換） | |
| INSERT/UPDATE | dOnlineFrom | フォーム入力値（日付変換） | |
| INSERT/UPDATE | dOnlineUntill | フォーム入力値（日付変換） | |
| INSERT/UPDATE | sLPExternalURL | フォーム入力値 | |
| INSERT/UPDATE | bLPExternalOINW | フォーム入力値 | |
| INSERT/UPDATE | sValue | フォーム入力値 | |
| INSERT/UPDATE | sUserFriendlyURL | フォーム入力値 | |
| INSERT/UPDATE | iListPageID | リストページID | |
| INSERT/UPDATE | bLossePagina | false固定 | |
| INSERT/UPDATE | bOnline | false固定 | |

#### tblPage（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bDeleted | true | |
| UPDATE | iRang | 0 | |
| UPDATE | bOnline | false | |
| UPDATE | bHomepage | false | |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|--------------|
| expllistitem | 説明 | 常時 | リストアイテム編集の説明 |
| list | ラベル | 常時 | "リスト" |
| title | ラベル | 常時 | "タイトル" |
| item | ラベル | 常時 | "アイテム" |
| date | ラベル | 常時 | "日付" |
| online | ラベル | 常時 | "オンライン" |
| from | ラベル | 常時 | "から" |
| untill | ラベル | 常時 | "まで" |
| userfriendlyurl | ラベル | bUserFriendlyURL時 | "ユーザーフレンドリーURL" |
| externalurl | ラベル | 外部URL時 | "外部URL" |
| openinnewwindow | ラベル | 外部URL時 | "新規ウィンドウで開く" |
| externalurlLP | 説明 | 外部URL未設定時 | 外部URL説明 |
| mandatory | ラベル | 常時 | "必須" |
| save | ラベル | 常時 | "保存" |
| reset | ラベル | 常時 | "リセット" |
| delete | ラベル | iId存在時 | "削除" |
| areyousure | 確認 | 削除時 | "本当に削除しますか？" |

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| getLper権限なし | noaccess.htmへリダイレクト |
| 保存失敗 | エラーメッセージ表示 |

## 備考

- 日付入力はJQDatePicker使用
- 外部URL表示条件は複雑（sLPExternalURL、iFeedID、sValueの組み合わせ）
- bLossePaginaとbOnlineはフロントサイド編集では常にfalse
- ユーザーフレンドリーURLはcustomer.bUserFriendlyURL設定時のみ表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストアイテム編集で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのリストアイテム関連プロパティ |
| 1-2 | contact.asp | `asp/includes/contact.asp` | getLper権限Dictionary |

**読解のコツ**: リストアイテムはtblPageの一種で、iListPageIDで親リストページに紐付く。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fs_editListItem.asp | `asp/fs_editListItem.asp` | フロントサイドリストアイテム編集の全体フロー |

**主要処理フロー**:
1. **行1**: begin.aspインクルード
2. **行4-18**: フラグ初期化、権限チェック、iListPageID設定
3. **行19**: 権限なし時リダイレクト
4. **行21-43**: POSTバック処理（保存/削除ロジック）
5. **行44-61**: フォーム表示

#### Step 3: 保存ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fs_editListItem.asp | `asp/fs_editListItem.asp` | 行21-43の保存/削除処理 |

**主要処理フロー**:
- **行21**: btnaction判定（save_listitem）
- **行22-32**: プロパティ設定
- **行33-40**: 削除処理分岐（actionBtn=delete）
- **行41-43**: Save()実行、リダイレクト

#### Step 4: 表示条件を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fs_editListItem.asp | `asp/fs_editListItem.asp` | 行52-61の表示条件分岐 |

**主要処理フロー**:
- **行53-57**: ユーザーフレンドリーURL表示条件（customer.bUserFriendlyURL）
- **行60**: 外部URL表示条件（複合条件）
- **行61**: WYSIWYGエディタ表示条件

### プログラム呼び出し階層図

```
fs_editListItem.asp
    │
    ├─ begin.asp（インクルード）
    │      ├─ cls_logonEdit（ログオン管理）
    │      ├─ cls_page（ページオブジェクト）
    │      └─ cls_customer（顧客設定）
    │
    ├─ 権限チェック
    │      └─ logon.contact.getLper（リストページ権限）
    │
    ├─ POSTバック処理
    │      ├─ プロパティ設定
    │      │      ├─ sTitle, dPage, dOnlineFrom, dOnlineUntill
    │      │      ├─ sLPExternalURL, bLPExternalOINW
    │      │      ├─ sValue, sUserFriendlyURL
    │      │      └─ iListPageID, bLossePagina, bOnline
    │      │
    │      ├─ 削除処理（actionBtn=delete）
    │      │      ├─ bDeleted=true
    │      │      ├─ parentPage.removeRang()
    │      │      └─ deleteListItems()
    │      │
    │      └─ selectedPage.save()
    │
    ├─ フォーム表示
    │      ├─ タイトル入力欄
    │      ├─ 日付入力欄（JQDatePicker x 3）
    │      ├─ ユーザーフレンドリーURL（条件付き）
    │      ├─ 外部URL設定（条件付き）
    │      ├─ WYSIWYGエディタ（条件付き）
    │      └─ ボタン群（保存/リセット/削除）
    │
    └─ リダイレクト
           └─ fs_editListItems.asp
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力          権限チェック
(sTitle, dPage,     getLperP.exists()        ───▶  権限あり/なし
 sValue, etc.)            │
     │                    ▼
     │              プロパティ設定
     │              selectedPage.xxx = ...
     │                    │
     │              ┌─────┴─────┐
     │              ▼           ▼
     │         通常保存      削除処理
     │         save()       bDeleted=true
     │              │       removeRang()
     │              │           │
     │              └─────┬─────┘
     │                    ▼
     └──────────────▶  selectedPage.save()  ───▶  DB更新
                             │
                             ▼
                      Response.Redirect
                      (fs_editListItems.asp)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs_editListItem.asp | `asp/fs_editListItem.asp` | ソース | フロントサイドリストアイテム編集メイン |
| fs_editListItems.asp | `asp/fs_editListItems.asp` | ソース | リストアイテム一覧画面 |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード集約 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義 |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先/権限管理クラス |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | WYSIWYGエディタ生成 |
| javascript.asp | `asp/includes/javascript.asp` | ソース | JQDatePicker等 |
| commonheader.asp | `asp/includes/commonheader.asp` | ソース | 共通ヘッダー |
