# 画面設計書 178-リストアイテム一覧（FS）

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントサイドリストアイテム一覧画面（fs_editListItems.asp）の設計仕様を記述したものである。本画面はリストページに所属するリストアイテムの一覧表示と管理操作へのナビゲーションを提供するフロントサイド編集機能である。

### 本画面の処理概要

本画面は、サイトにログインした権限ユーザーが、リストページに登録されている全てのリストアイテムを一覧表示し、各アイテムの編集・プレビュー・画像設定への導線を提供する。オンライン/オフラインのステータスも視覚的に表示される。

**業務上の目的・背景**：リストページ（ブログ、ニュース一覧、製品カタログ等）の運用では、複数のアイテムを効率的に管理するニーズがある。本画面によりフロントサイドから直接アイテム一覧を確認し、編集対象を選択したり、新規アイテムを追加したりすることが可能。

**画面へのアクセス方法**：公開サイトにイントラネット認証でログインした状態で、リストページのリスト管理リンクをクリックするとポップアップで表示される。また、リストアイテム編集画面からの保存成功時にリダイレクトされる。

**主要な操作・処理内容**：
1. ユーザーのリスト編集権限チェック（getLper）
2. リストページのリストアイテム一覧取得（listitems）
3. 各アイテムの表示（タイトル、オンライン/オフライン状態）
4. 新規アイテム追加ボタン表示
5. 各アイテムの編集リンク、プレビューリンク、画像設定リンク表示

**画面遷移**：
- 遷移元：公開サイトのリストページ、リストアイテム編集画面（保存成功時）、リストアイテム画像画面（保存/削除時）
- 遷移先：リストアイテム編集画面（fs_editListItem.asp）、プレビュー（default.asp）、リストアイテム画像画面（fs_editListItemPic.asp）

**権限による表示制御**：getLper（リスト編集権限）を持つユーザーのみがアクセス可能。bListItemPic設定により画像設定リンクの表示/非表示が制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | リストページ管理 | 主機能 | リストアイテム一覧表示・管理 |
| 117 | CSRF対策 | 補助機能 | 新規追加時のリクエスト検証 |

## 画面種別

一覧（ポップアップ）

## URL/ルーティング

```
asp/fs_editListItems.asp?iId={暗号化ページID}
```

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ページID | iId | query | 必須 | 暗号化されたリストページID |

### 出力項目（フォーム - 新規追加）

| 項目名 | 物理名 | データ型 | 説明 |
|--------|--------|----------|------|
| リストページID | iListPageID | hidden | 暗号化されたリストページID |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| リストページタイトル | 常時表示 | テキスト（太字） |
| 新規アイテム追加ボタン | 常時表示 | submitボタン |
| アイテム一覧 | listitems.count>0 | リスト（ul/li） |
| アイテムタイトル | 常時表示 | リンク（編集画面へ） |
| オフライン表示 | statusString=l("offline") | イタリック体 + "Offline:" |
| プレビューリンク | statusString<>l("offline") | リンク（新規ウィンドウ） |
| 画像設定リンク | customer.bListItemPic=true | リンク（画像編集画面へ） |

## イベント仕様

### 1-新規アイテム追加ボタン押下

1. fs_editListItem.aspへPOST送信
2. iListPageID（暗号化）を送信
3. リストアイテム編集画面で新規作成モード起動

### 2-アイテムタイトルリンククリック

1. fs_editListItem.asp?iId={暗号化アイテムID}へ遷移
2. 対象アイテムの編集画面表示

### 3-プレビューリンククリック

1. default.asp?iId={暗号化リストページID}&item={暗号化アイテムID}へ遷移
2. 新規ウィンドウでプレビュー表示
3. アンカー（#{暗号化アイテムID}）で対象アイテムへスクロール

### 4-画像設定リンククリック

1. fs_editListItemPic.asp?iId={暗号化アイテムID}へ遷移
2. リストアイテム画像編集画面表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | tblPage | SELECT | リストアイテム取得 |

### テーブル別更新項目詳細

#### tblPage（読み取りのみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|----------|------|
| SELECT | sTitle | iListPageID=selectedPage.iId | アイテムタイトル表示用 |
| SELECT | bOnline/bDeleted | 同上 | ステータス判定用 |
| SELECT | iListPageID | 同上 | プレビューURL構築用 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|--------------|
| managelist | ラベル | 常時 | "リスト管理" |
| addnewitem | ラベル | 常時 | "新規アイテム追加" |
| modifylistitem | ラベル | 常時 | "アイテム編集" |
| offline | ラベル | オフライン時 | "Offline" |
| preview | ラベル | オンライン時 | "プレビュー" |

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| getLper権限なし | noaccess.htmへリダイレクト |
| リストアイテムなし | 空の一覧表示（新規追加ボタンのみ） |

## 備考

- listitems(false)でオフラインアイテムも含めて取得
- オフラインアイテムはイタリック体で表示し、プレビューリンクは非表示
- bListItemPic設定はcustomerオブジェクトから取得（顧客レベルの設定）
- 暗号化にはencrypt関数を使用（セキュリティ対策）
- cleanUPASP関数で終了処理（リソース解放）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストアイテム一覧で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのlistitemsプロパティ |
| 1-2 | contact.asp | `asp/includes/contact.asp` | getLper権限Dictionary |
| 1-3 | customer.asp | `asp/includes/customer.asp` | bListItemPic設定 |

**読解のコツ**: listitemsプロパティがDictionaryを返し、キーがiId、値がcls_pageオブジェクトであることに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fs_editListItems.asp | `asp/fs_editListItems.asp` | フロントサイドリストアイテム一覧の全体フロー |

**主要処理フロー**:
1. **行1**: begin.aspインクルード
2. **行2-5**: フラグ初期化、getLper権限Dictionary取得
3. **行7**: 権限チェック（なければnoaccess.htmへ）
4. **行13-14**: listitemsコレクション取得
5. **行16-21**: テーブルヘッダー、新規追加フォーム
6. **行24-47**: アイテム一覧ループ表示

#### Step 3: アイテム一覧表示ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fs_editListItems.asp | `asp/fs_editListItems.asp` | 行24-47のループ処理 |

**主要処理フロー**:
- **行27-45**: For Each item in listitemsでアイテムを列挙
- **行29-33**: オフライン/オンラインで表示スタイル分岐
- **行35-37**: オンラインの場合のみプレビューリンク表示
- **行39-41**: bListItemPic設定時に画像設定リンク表示

### プログラム呼び出し階層図

```
fs_editListItems.asp
    │
    ├─ begin.asp（インクルード）
    │      ├─ cls_logonEdit（ログオン管理）
    │      ├─ cls_page（ページオブジェクト）
    │      └─ cls_customer（顧客設定）
    │
    ├─ 権限チェック
    │      └─ logon.contact.getLper（リスト権限）
    │
    ├─ データ取得
    │      └─ selectedPage.listitems(false)
    │             └─ Dictionaryオブジェクト返却
    │
    ├─ 一覧表示
    │      ├─ 新規追加フォーム
    │      │      └─ POST → fs_editListItem.asp
    │      │
    │      └─ For Each item in listitems
    │             ├─ statusString判定
    │             ├─ タイトルリンク（編集画面へ）
    │             ├─ プレビューリンク（オンライン時）
    │             └─ 画像設定リンク（bListItemPic時）
    │
    └─ cleanUPASP（終了処理）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ          権限チェック
(iId)                  getLperP.exists()        ───▶  アクセス可/不可
    │                        │
    │                        ▼
    │                  selectedPage.listitems(false)
    │                        │
    │                        ▼
    │                  For Each アイテム      ───▶  HTML一覧表示
    │                        │
    │                        ├─ statusString判定
    │                        ├─ タイトルリンク生成
    │                        ├─ プレビューリンク生成
    │                        └─ 画像設定リンク生成
    │
    └──────────────▶  fs_editListItem.asp    ───▶  新規追加/編集
                             │
                             ▼
                      fs_editListItemPic.asp  ───▶  画像設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs_editListItems.asp | `asp/fs_editListItems.asp` | ソース | フロントサイドリストアイテム一覧メイン |
| fs_editListItem.asp | `asp/fs_editListItem.asp` | ソース | リストアイテム編集（遷移先） |
| fs_editListItemPic.asp | `asp/fs_editListItemPic.asp` | ソース | リストアイテム画像（遷移先） |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード集約 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義（listitems） |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先/権限管理クラス |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定（bListItemPic） |
| commonheader.asp | `asp/includes/commonheader.asp` | ソース | 共通ヘッダー |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（encrypt等） |
