# 画面設計書 179-リストアイテム画像（FS）

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントサイドリストアイテム画像画面（fs_editListItemPic.asp）の設計仕様を記述したものである。本画面はリストアイテムに画像をアップロードし、表示位置（配置）を設定するためのフロントサイド編集機能である。

### 本画面の処理概要

本画面は、サイトにログインした権限ユーザーが、リストアイテムに添付する画像をアップロードし、表示位置（左寄せ/右寄せ/全幅/カスタムCSS）を設定する機能を提供する。ファイルアップロードにはFreeASPUploadコンポーネントを使用し、JPG/GIF/PNG形式のみ許可。

**業務上の目的・背景**：リストアイテム（ブログ記事、ニュース、製品情報等）に視覚的なコンテンツを追加することで、ユーザーエクスペリエンスを向上させる。画像の配置オプションにより、デザインの柔軟性を確保している。

**画面へのアクセス方法**：公開サイトにイントラネット認証でログインした状態で、リストアイテム一覧画面の「Set/Edit picture」リンクをクリックするとポップアップで表示される。

**主要な操作・処理内容**：
1. ユーザーのリスト編集権限チェック（getLper）
2. 画像未設定時：アップロードフォーム表示
3. 画像アップロード処理（ファイル検証、リネーム、保存）
4. 画像設定済み時：プレビューと配置オプション表示
5. 配置変更保存、画像削除機能

**画面遷移**：
- 遷移元：リストアイテム一覧画面（fs_editListItems.asp）
- 遷移先（保存/削除成功時）：リストアイテム一覧画面

**権限による表示制御**：getLper（リスト編集権限）を持つユーザーのみがアクセス可能。画像の有無により表示内容が切り替わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | リストページ管理 | 主機能 | リストアイテム画像管理 |
| 117 | CSRF対策 | 補助機能 | アップロード/配置変更時のリクエスト検証 |
| 42 | 画像処理 | 補助機能 | サムネイル生成（showthumb.aspx） |

## 画面種別

編集（ポップアップ）

## URL/ルーティング

```
asp/fs_editListItemPic.asp?iId={暗号化アイテムID}
```

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| アイテムID | iId | query | 必須 | 暗号化されたリストアイテムID |

### 入力項目（アップロードフォーム - 画像未設定時）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| セキュリティトークン | QSSEC | hidden | 必須 | CSRFトークン |
| アイテムID | iId | hidden | 必須 | 暗号化されたアイテムID |
| 画像ファイル | picture | file | 必須 | JPG/GIF/PNG形式 |

### 入力項目（配置設定フォーム - 画像設定済み時）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| セキュリティトークン | QSSEC | hidden | 必須 | CSRFトークン |
| アイテムID | iId | hidden | 必須 | 暗号化されたアイテムID |
| 配置設定 | sLPIC | radio | 必須 | al/fp/ar/CC |
| 保存ボタン | btnAction | submit | - | 配置保存 |
| 削除ボタン | delAction | submit | - | 画像削除 |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| 戻るリンク | 常時表示 | ボタンリンク（一覧へ） |
| アップロードフォーム | sItemPicture未設定時 | ファイル選択 + アップロードボタン |
| プレビュー画像 | sItemPicture設定時 | サムネイル（最大270px） |
| 左寄せラジオ | sItemPicture設定時 | radio（al） |
| 全幅ラジオ | sItemPicture設定時 | radio（fp）※デフォルト |
| 右寄せラジオ | sItemPicture設定時 | radio（ar） |
| カスタムCSSラジオ | sItemPicture設定時 | radio（CC） |
| 保存ボタン | sItemPicture設定時 | submit |
| 削除ボタン | sItemPicture設定時 | submit（確認ダイアログ付き） |
| エラーメッセージ | アップロードエラー時 | 赤字テキスト |

## イベント仕様

### 1-ファイル選択変更時（JavaScript）

1. アップロードボタンテキストを「please wait...」に変更
2. フォームを自動送信

### 2-アップロードボタン押下

1. FreeASPUpload.Saveでファイル保存
2. checkCSRF_Upload(Upload.form("QSSEC"))でCSRF検証
3. ファイル拡張子検証（png/jpg/gif/jpegのみ許可）
4. 許可外拡張子の場合：ファイル削除、エラーメッセージ設定
5. 許可拡張子の場合：
   - ファイルをpage.iId.{拡張子}にリネーム
   - page.sItemPicture=拡張子を設定
   - page.sLPIC="fp"（全幅）をデフォルト設定
   - page.save()で保存
   - 同画面にリダイレクト

### 3-配置保存ボタン押下

1. page.sLPIC=request.form("sLPIC")で配置設定
2. page.save()で保存
3. リストアイテム一覧画面（fs_editListItems.asp）にリダイレクト

### 4-画像削除ボタン押下

1. JavaScriptで確認ダイアログ表示
2. 確認OKの場合：page.deleteListItemImage()実行
3. リストアイテム一覧画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップロード成功 | tblPage | UPDATE | 画像情報設定 |
| 配置変更 | tblPage | UPDATE | 配置設定変更 |
| 画像削除 | tblPage | UPDATE | 画像情報クリア |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sItemPicture | ファイル拡張子 | アップロード時 |
| UPDATE | sLPIC | "fp"（デフォルト） | アップロード時 |
| UPDATE | sLPIC | フォーム入力値 | 配置変更時 |
| UPDATE | sItemPicture | NULL | 削除時（deleteListItemImage） |
| UPDATE | sLPIC | NULL | 削除時（推定） |

### ファイルシステム操作

| 操作 | 対象 | 説明 |
|-----|------|------|
| CREATE | listitemimages/{iId}.{ext} | 画像アップロード時 |
| DELETE | listitemimages/{iId}.{ext} | 画像削除時（deleteListItemImage内） |
| CREATE | listitemimagesフォルダ | 初回アクセス時（存在しない場合） |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|--------------|
| back | ラベル | 常時 | "戻る" |
| upload | ラベル | 画像未設定時 | "アップロード" |
| - | エラー | ファイル形式不正時 | "Only JPG/GIF/PNG files please." |
| - | 確認 | 削除ボタン押下時 | "Are you sure to delete the picture?" |

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| getLper権限なし | noaccess.htmへリダイレクト |
| 不正なファイル形式 | エラーメッセージ表示、ファイル削除 |
| listitemimagesフォルダ未存在 | 自動作成 |

## 備考

- 画像格納先：{userfiles}/listitemimages/{iId}.{拡張子}
- サムネイル生成：showthumb.aspxで最大270px表示
- 配置オプション（sLPIC）：
  - al：左寄せ（50%幅）
  - fp：全幅（100%幅）- デフォルト
  - ar：右寄せ（50%幅）
  - CC：カスタムCSS（ListItemPictureCSSクラス適用）
- FreeASPUploadコンポーネントでマルチパートフォームを処理
- ファイルはページID.拡張子でリネームされ、元ファイル名は保持されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストアイテム画像で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスのsItemPicture、sLPICプロパティ |
| 1-2 | page.asp | `asp/includes/page.asp` | deleteListItemImageメソッド |
| 1-3 | freeASPUpload.asp | `asp/includes/freeASPUpload.asp` | FreeASPUploadクラス |

**読解のコツ**: sItemPictureには拡張子のみ格納され、ファイル名はiIdから生成されることに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fs_editListItemPic.asp | `asp/fs_editListItemPic.asp` | 画像管理の全体フロー |

**主要処理フロー**:
1. **行1-7**: begin.aspインクルード、フラグ設定、ページ取得
2. **行9-15**: listitemimagesフォルダ作成（FSO）
3. **行22-32**: アップロード処理開始（isLeeg(page.iId)時）
4. **行34-42**: 権限チェック、iListPageID設定
5. **行44-97**: 画像アップロード/設定保存/削除のビジネスロジック
6. **行100-146**: 画面表示（アップロードフォーム or 配置設定フォーム）

#### Step 3: アップロードロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fs_editListItemPic.asp | `asp/fs_editListItemPic.asp` | 行44-78のアップロード処理 |

**主要処理フロー**:
- **行46**: UploadedFiles.keysでアップロードファイル取得
- **行52-78**: ファイル検証、リネーム、保存のループ
- **行56-63**: 拡張子チェック（png/jpg/gif/jpeg）
- **行66-76**: リネーム、sItemPicture/sLPIC設定、save、リダイレクト

#### Step 4: 配置変更/削除ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fs_editListItemPic.asp | `asp/fs_editListItemPic.asp` | 行84-96の保存/削除処理 |

**主要処理フロー**:
- **行86-90**: btnAction（保存）時のsLPIC設定とリダイレクト
- **行92-95**: delAction（削除）時のdeleteListItemImage呼び出し

### プログラム呼び出し階層図

```
fs_editListItemPic.asp
    │
    ├─ begin.asp（インクルード）
    │      ├─ cls_logonEdit（ログオン管理）
    │      ├─ cls_page（ページオブジェクト）
    │      └─ FreeASPUpload（アップロード処理）
    │
    ├─ FSO操作
    │      └─ listitemimagesフォルダ作成
    │
    ├─ 権限チェック
    │      └─ getLperP.exists(iLPID)
    │
    ├─ 画像未設定時（アップロード処理）
    │      ├─ FreeASPUpload.Save()
    │      ├─ checkCSRF_Upload()
    │      ├─ GetFileExtension()
    │      ├─ UploadedFiles.rename()
    │      └─ page.save()
    │
    ├─ 画像設定済み時
    │      ├─ btnAction（保存）
    │      │      ├─ sLPIC設定
    │      │      └─ page.save()
    │      │
    │      └─ delAction（削除）
    │             └─ page.deleteListItemImage()
    │
    └─ 表示
           ├─ アップロードフォーム（未設定時）
           └─ 配置設定フォーム（設定済み時）
                  ├─ サムネイル表示（showthumb.aspx）
                  └─ ラジオボタン（al/fp/ar/CC）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ          page.pick()
(iId)                       │
    │                       ▼
    │                  権限チェック
    │                  getLperP.exists()        ───▶  アクセス可/不可
    │                       │
    │                       ▼
    │               ┌──────────────────┐
    │               │sItemPicture判定 │
    │               └──────┬───────────┘
    │                       │
    ├──[未設定]────────▶  アップロード処理
    │                       │
    │                       ├─ FreeASPUpload.Save()
    │                       ├─ 拡張子チェック
    │                       ├─ ファイルリネーム
    │                       └─ page.save()     ───▶  ファイル保存 + DB更新
    │
    └──[設定済み]──────▶  配置変更/削除
                            │
                            ├─ btnAction
                            │     └─ sLPIC設定 ───▶  DB更新
                            │
                            └─ delAction
                                  └─ deleteListItemImage() ───▶  ファイル削除 + DB更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs_editListItemPic.asp | `asp/fs_editListItemPic.asp` | ソース | リストアイテム画像メイン |
| fs_editListItems.asp | `asp/fs_editListItems.asp` | ソース | リストアイテム一覧（遷移先） |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード集約 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス定義（sItemPicture等） |
| freeASPUpload.asp | `asp/includes/freeASPUpload.asp` | ソース | ファイルアップロードクラス |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先/権限管理クラス |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（encrypt, GetFileExtension等） |
| commonheader.asp | `asp/includes/commonheader.asp` | ソース | 共通ヘッダー |
| showthumb.aspx | `showthumb.aspx` | ソース | サムネイル生成ASPX |
