# 画面設計書 18-全体パスワード適用

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）における「全体パスワード適用」画面の設計仕様を定義するものである。

### 本画面の処理概要

全体パスワード適用画面は、サイト全体にパスワード保護を設定するための画面である。サイト全体パスワード（sTotalPW）を設定することで、サイト内の全ページの閲覧に認証が必要になる。また、バックサイトの管理者パスワードも変更可能である。

**業務上の目的・背景**：
開発中のサイトや社内限定サイトなど、サイト全体を非公開にしたい場合がある。本画面は、サイト全体に一括でパスワード保護を設定する機能を提供する。また、バックサイト管理者のパスワード変更機能も併せて提供することで、セキュリティ設定を一元管理できる。

**画面へのアクセス方法**：
1. バックサイトにログイン後、設定メニューからセキュリティ設定へアクセス
2. バックサイトヘッダーのセットアップメニュー → セキュリティから遷移

**主要な操作・処理内容**：
1. サイト全体パスワードの入力（15文字以内）
2. サイト全体パスワードの保存
3. サイト全体パスワードの削除
4. バックサイト管理者パスワードの変更（セカンドアドミンの場合）

**画面遷移**：
- 遷移元: バックサイトヘッダーのセットアップメニュー
- 遷移先: 同一画面（保存後も同じ画面に留まる）
- リンク: セカンド管理者設定画面（bs_secondAdmin.asp）

**権限による表示制御**：
- secondAdmin.bPagesPWがfalseの場合、画面へのアクセスが拒否される
- セカンドアドミン（logon.currentPW != customer.secondAdmin.sPassword）の場合、バックサイトパスワード変更フォームを表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | パスワード変更 | 主機能 | サイト全体へのパスワード保護・変更 |

## 画面種別

設定画面

## URL/ルーティング

```
asp/bs_applyTotalPW.asp
```

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| sTotalPW | 入力（text） | String | No | サイト全体パスワード（15文字以内） |
| btnaction | 入力（submit） | String | Yes | アクション種別 |
| adminPassword | 入力（password） | String | No | バックサイト新パスワード |
| adminPasswordConfirm | 入力（password） | String | No | バックサイトパスワード確認 |
| QS_secCodeHidden | 入力（hidden） | String | Yes | CSRF対策トークン |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| サイト全体パスワード入力欄 | 入力フィールド | 8文字幅、最大15文字 |
| 保存ボタン | ボタン | confirm()付きでパスワード保存 |
| 削除ボタン | ボタン | confirm()付きでパスワード削除（設定済みの場合のみ） |
| セカンドアドミンリンク | リンク | bs_secondAdmin.aspへのリンク |
| バックサイトパスワード入力欄 | パスワード入力 | セカンドアドミン時のみ表示 |
| バックサイトパスワード確認欄 | パスワード入力 | セカンドアドミン時のみ表示 |

## イベント仕様

### 1-サイト全体パスワード保存ボタン押下（save_pw_total）

1. JavaScript confirm()で確認ダイアログ表示
2. OKでフォームをPOST送信
3. btnaction=l("save_pw_total")でbs_process.aspの処理が実行
4. checkCSRF()でCSRFトークン検証
5. customer.applyTotalPW(sTotalPW)でサイト全体パスワードを設定
6. 成功時、message.Add("fb_saveOK")でメッセージ設定

### 2-サイト全体パスワード削除ボタン押下（delete_pw_total）

1. JavaScript confirm()で確認ダイアログ表示
2. OKでフォームをPOST送信
3. btnaction=l("delete_pw_total")でbs_process.aspの処理が実行
4. checkCSRF()でCSRFトークン検証
5. customer.removeTotalPW()でサイト全体パスワードを削除
6. 成功時、message.Add("fb_saveOK")でメッセージ設定

### 3-バックサイトパスワード保存ボタン押下（cSaveAdminPW）

1. フォームをPOST送信
2. btnaction=cSaveAdminPWでbs_process.aspの処理が実行
3. checkCSRF()でCSRFトークン検証
4. パスワードと確認パスワードの一致チェック
5. 不一致の場合、message.AddError("pwnomatch")でエラー
6. 一致の場合、customer.saveAdminPW()で保存
7. 成功時、message.Add("fb_saveOK")でメッセージ設定

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 全体パスワード保存 | tblCustomer | UPDATE | サイト全体パスワードを設定 |
| 全体パスワード保存 | tblPage | UPDATE | 全ページにパスワードを適用 |
| 全体パスワード削除 | tblCustomer | UPDATE | サイト全体パスワードをクリア |
| 管理者パスワード保存 | tblCustomer | UPDATE | バックサイトパスワードを更新 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sTotalPW | request.form("sTotalPW") | サイト全体パスワード |
| UPDATE | sTotalPW | "" | 削除時は空文字 |
| UPDATE | adminPassword | request.form("adminPassword") | バックサイトパスワード |

#### tblPage（全体パスワード適用時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPw | sTotalPW値 | 全ページに一括適用 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| fb_saveOK | 成功 | 保存成功時 | 保存が完了しました |
| pwnomatch | エラー | パスワード不一致 | パスワードが一致しません |
| areyousure | 確認 | 保存/削除ボタン押下時 | 本当に実行しますか？ |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | logon.hasaccess(secondAdmin.bPagesPW)でアクセス拒否 |
| 未認証アクセス | bs_security.aspによりログイン画面にリダイレクト |
| パスワード不一致 | エラーメッセージ表示、保存中止 |
| CSRFトークン不正 | checkCSRF()でエラー処理 |

## 備考

- サイト全体パスワードを設定すると、個別ページのパスワード設定は無効化される
- セカンドアドミン（副管理者）はバックサイトパスワードを変更可能
- メインアドミンの場合、バックサイトパスワード変更フォームは非表示
- confirm()によるJavaScript確認ダイアログで誤操作を防止
- セカンドアドミン設定画面（bs_secondAdmin.asp）へのリンクを提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面構成を理解する

全体パスワード適用画面の表示内容を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_applyTotalPW.asp | `asp/bs_applyTotalPW.asp` | 画面構成、2つのフォーム、条件分岐 |

**読解のコツ**: customer.sTotalPWの有無とlogon.currentPWの判定による条件分岐に注目。

#### Step 2: パスワード保存・削除処理を理解する

サイト全体パスワードの処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_process.asp | `asp/bs_process.asp` | save_pw_total/delete_pw_total処理（行157-166） |

**主要処理フロー**:
1. **行157-161**: delete_pw_totalケース - removeTotalPW()呼び出し
2. **行162-166**: save_pw_totalケース - applyTotalPW()呼び出し

#### Step 3: 管理者パスワード変更処理を理解する

バックサイトパスワードの変更処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | cSaveAdminPWケース（行176-184） |

**主要処理フロー**:
1. **行177-178**: パスワード一致チェック
2. **行179-180**: customer.saveAdminPW()呼び出し
3. **行182-183**: 不一致時のエラーメッセージ

### プログラム呼び出し階層図

```
bs_applyTotalPW.asp
    │
    ├─ begin.asp（セッション・DB初期化）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess(secondAdmin.bPagesPW)
    │
    ├─ bs_process.asp（共通処理）
    │
    ├─ [サイト全体パスワードフォーム]
    │      │
    │      ├─ [save_pw_total]
    │      │      ├─ checkCSRF()
    │      │      └─ customer.applyTotalPW()
    │      │             └─ 全ページにパスワード適用
    │      │
    │      └─ [delete_pw_total]
    │             ├─ checkCSRF()
    │             └─ customer.removeTotalPW()
    │
    └─ [バックサイトパスワードフォーム]（セカンドアドミン時）
           │
           └─ [cSaveAdminPW]
                  ├─ checkCSRF()
                  ├─ パスワード一致チェック
                  └─ customer.saveAdminPW()
```

### データフロー図

```
[入力]                      [処理]                      [出力]

customer.sTotalPW ──────────▶ 条件判定 ────────────────▶ 削除ボタン表示/非表示
                                  │
sTotalPW入力 ───────────────────▶ request.form()
                                  │
                            ┌─────┴─────┐
                            │           │
                      [save_pw_total] [delete_pw_total]
                            │           │
                            ▼           ▼
              customer.applyTotalPW() customer.removeTotalPW()
                            │           │
                            ▼           ▼
                      tblCustomer UPDATE + tblPage UPDATE
                                  │
                                  ▼
                            message.Add("fb_saveOK")

---

logon.currentPW ────────────▶ 条件判定 ────────────────▶ 管理者PW変更フォーム表示
                                  │
adminPassword入力 ──────────────▶ request.form()
adminPasswordConfirm入力 ───────▶ request.form()
                                  │
                            一致チェック
                                  │
                            ┌─────┴─────┐
                            │           │
                        [一致]       [不一致]
                            │           │
                            ▼           ▼
            customer.saveAdminPW()  message.AddError("pwnomatch")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_applyTotalPW.asp | `asp/bs_applyTotalPW.asp` | ソース | メイン画面処理 |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 保存・削除処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| bs_secondAdmin.asp | `asp/bs_secondAdmin.asp` | リンク先 | セカンドアドミン設定 |
