# 画面設計書 180-メール連絡先（FS）

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントサイドメール連絡先画面（fs_mailcontact.asp）の設計仕様を記述したものである。本画面はログインユーザーが他のユーザーにプライベートメッセージを送信するためのフロントサイド機能である。

### 本画面の処理概要

本画面は、サイトにイントラネット認証でログインしたユーザーが、他の連絡先（ユーザー）にプライベートメッセージを送信する機能を提供する。CAPTCHAによるボット対策、CC送信オプション、入力値のバリデーションを備えている。

**業務上の目的・背景**：CMSサイト内でユーザー間のコミュニケーションを可能にするため、メール機能を提供。フォーラムやブログのコメント欄とは別に、プライベートな連絡手段として利用される。送信者のメールアドレスを公開せずに連絡できるメリットがある。

**画面へのアクセス方法**：公開サイトにイントラネット認証でログインした状態で、ユーザープロフィールやコンタクトリストから「メッセージ送信」リンクをクリックするとポップアップで表示される。URLパラメータiContactIDで送信先を指定。

**主要な操作・処理内容**：
1. イントラネット認証チェック
2. 送信先ユーザーのメール受信許可チェック（bGetEmailsFromSite）
3. メッセージ入力フォーム表示
4. CAPTCHAバリデーション
5. メール送信（cls_mail_message使用）
6. CC送信（オプション）
7. 送信完了メッセージ表示

**画面遷移**：
- 遷移元：ユーザープロフィール、コンタクトリスト、フォーラム投稿者リンク等
- 遷移先：同画面（送信完了メッセージ表示）

**権限による表示制御**：イントラネット認証済みユーザーのみアクセス可能。送信先ユーザーがbGetEmailsFromSite=trueの場合のみ送信可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | メール送信 | 主機能 | プライベートメッセージ送信 |
| 93 | CAPTCHA | 補助機能 | ボット対策検証 |
| 117 | CSRF対策 | 補助機能 | セキュリティトークン（暗黙的） |

## 画面種別

入力・送信（ポップアップ）

## URL/ルーティング

```
asp/fs_mailcontact.asp?iContactID={暗号化連絡先ID}
asp/fs_mailcontact.asp?mailsent=true&iContactID={暗号化連絡先ID}（送信完了時）
```

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 連絡先ID | iContactID | query | 必須 | 暗号化された送信先連絡先ID |
| 送信完了フラグ | mailsent | query | - | 送信完了時"true" |

### 入力項目（フォーム）

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ポストバック | postback | hidden | 必須 | true固定 |
| 連絡先ID | iContactID | hidden | 必須 | 暗号化された送信先ID |
| メッセージ本文 | body | textarea | 必須 | メッセージ内容（60列x7行） |
| CC送信 | cc | checkbox | - | 送信者にコピー送信（デフォルトON） |
| CAPTCHA | captcha | text | 必須 | 4文字のCAPTCHA入力 |

## 表示項目

| 項目名 | 表示条件 | フォーマット |
|--------|----------|--------------|
| 送信完了メッセージ | mailsent=true | テキスト |
| 送信フォーム | mailsent未設定 | フォーム |
| 送信者情報 | 常時表示 | ログインユーザーのニックネーム+メール |
| 送信先情報 | 常時表示 | 連絡先のニックネーム |
| CAPTCHA画像 | 常時表示 | 画像（captcha.asp） |
| 必須マーク | 常時表示 | (*) |
| 送信ボタン | 常時表示 | submit |
| エラーメッセージ | バリデーションエラー時 | message.showAlert() |

## イベント仕様

### 1-送信ボタン押下

1. postback=trueでPOST処理分岐
2. CAPTCHAバリデーション
   - session("CAPTCHA")とRequest.Form("CAPTCHA")の最初4文字を大文字小文字無視で比較
   - 不一致時：err_captchaエラー追加
3. メッセージ本文バリデーション
   - 空の場合：err_mandatoryエラー追加
4. バリデーション成功時：
   - cls_mail_messageオブジェクト生成
   - receiver=contact.sEmail（送信先）
   - receiverName=contact.sNickName（送信先）
   - subject="Private message from " + 送信者ニックネーム + " (" + customer.surl + ")"
   - body=linkURLS(Request.Form("body"))（URL自動リンク化）
   - fromemail=logon.contact.sEmail（送信者）
   - fromname=logon.contact.sNickName（送信者）
   - myMail.send実行
5. CC送信チェック時：
   - receiver=logon.contact.sEmail
   - receiverName=logon.contact.sNickName
   - myMail.send実行（2回目）
6. 送信成功：同画面にmailsent=trueでリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblContact | SELECT | 送信先連絡先情報取得 |

### テーブル別更新項目詳細

#### tblContact（読み取りのみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|----------|------|
| SELECT | sEmail | iId=decrypt(iContactID) | 送信先メールアドレス |
| SELECT | sNickName | 同上 | 送信先表示名 |
| SELECT | bGetEmailsFromSite | 同上 | メール受信許可フラグ |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|----------|--------------|
| fb_mailsent | 成功 | mailsent=true | メール送信完了メッセージ |
| sendprivatemessage | ラベル | 常時 | "プライベートメッセージを[NICKNAME]に送信" |
| from | ラベル | 常時 | "送信者" |
| to | ラベル | 常時 | "宛先" |
| yourmessage | ラベル | 常時 | "メッセージ" |
| sendacopyto | ラベル | 常時 | "コピーを送信" |
| captcha | ラベル | 常時 | "CAPTCHA" |
| mandatory | ラベル | 常時 | "必須" |
| send | ラベル | 常時 | "送信" |
| err_captcha | エラー | CAPTCHA不一致時 | CAPTCHAエラーメッセージ |
| err_mandatory | エラー | 必須項目未入力時 | 必須入力エラーメッセージ |

## 例外処理

| 例外条件 | 処理 |
|---------|------|
| イントラネット未認証 | Response.End（処理終了） |
| bGetEmailsFromSite=false | Response.End（処理終了） |
| CAPTCHA不一致 | err_captchaエラー表示 |
| メッセージ本文空 | err_mandatoryエラー表示 |

## 備考

- CAPTCHAは画像（captcha.asp）とセッション変数で実装
- CAPTCHA比較は最初の4文字のみ、大文字小文字無視
- メッセージ本文はlinkURLS関数でURL自動リンク化
- CC送信はデフォルトでチェックON
- メール件名にはcustomer.surl（サイトURL）が含まれる
- sanitize関数で入力値のサニタイズ処理
- cPopup.dumpJS()でポップアップ用JavaScript出力

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メール連絡先で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | cls_contactクラス、bGetEmailsFromSiteプロパティ |
| 1-2 | mail_message.asp | `asp/includes/mail_message.asp` | cls_mail_messageクラス |
| 1-3 | logon.asp | `asp/includes/logon.asp` | logon.contact（ログインユーザー情報） |

**読解のコツ**: bGetEmailsFromSiteがtrueの連絡先のみメッセージ受信可能であることに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fs_mailcontact.asp | `asp/fs_mailcontact.asp` | メール送信の全体フロー |

**主要処理フロー**:
1. **行1**: begin.aspインクルード
2. **行4-5**: cls_contactオブジェクト生成
3. **行6**: イントラネット認証チェック
4. **行7**: bGetEmailsFromSiteチェック
5. **行8-31**: POSTバック処理（バリデーション+送信）
6. **行32**: 画面表示（送信完了 or フォーム）

#### Step 3: バリデーションとメール送信を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fs_mailcontact.asp | `asp/fs_mailcontact.asp` | 行8-31のPOST処理 |

**主要処理フロー**:
- **行9-10**: CAPTCHAバリデーション（session比較）
- **行11-12**: 本文必須チェック
- **行14-22**: cls_mail_message設定とsend実行
- **行24-28**: CC送信処理
- **行30**: 送信成功時リダイレクト

#### Step 4: フォーム表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fs_mailcontact.asp | `asp/fs_mailcontact.asp` | 行32のフォーム表示 |

**主要処理フロー**:
- mailsent=trueの場合：送信完了メッセージ表示
- それ以外：送信フォーム表示
  - 送信者情報（logon.contact）
  - 送信先情報（contact）
  - メッセージ入力欄（textarea）
  - CCチェックボックス
  - CAPTCHA画像と入力欄

### プログラム呼び出し階層図

```
fs_mailcontact.asp
    │
    ├─ begin.asp（インクルード）
    │      ├─ cls_logonEdit（ログオン管理）
    │      ├─ cls_contact（連絡先クラス）
    │      └─ cls_mail_message（メール送信クラス）
    │
    ├─ 認証チェック
    │      ├─ logon.authenticatedIntranet
    │      └─ contact.bGetEmailsFromSite
    │
    ├─ POSTバック処理
    │      ├─ CAPTCHAバリデーション
    │      │      └─ session("CAPTCHA") vs Request.Form("CAPTCHA")
    │      │
    │      ├─ 必須チェック
    │      │      └─ isLeeg(Request.Form("body"))
    │      │
    │      ├─ メール送信
    │      │      ├─ cls_mail_message生成
    │      │      ├─ receiver/subject/body設定
    │      │      ├─ linkURLS()（URL自動リンク化）
    │      │      └─ myMail.send()
    │      │
    │      └─ CC送信（オプション）
    │             └─ myMail.send()（送信者宛）
    │
    ├─ 表示
    │      ├─ 送信完了メッセージ（mailsent=true時）
    │      └─ 送信フォーム
    │             ├─ 送信者/送信先情報
    │             ├─ メッセージ入力欄
    │             ├─ CCチェックボックス
    │             └─ CAPTCHA画像+入力欄
    │
    └─ message.showAlert()（エラー表示）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ          contact.pick()
(iContactID)                │
    │                       ▼
    │                  認証チェック
    │                  authenticatedIntranet     ───▶  認証可/不可
    │                  bGetEmailsFromSite
    │                       │
    │                       ▼
フォーム入力          CAPTCHAバリデーション
(body, captcha)       session("CAPTCHA")         ───▶  エラー or 成功
    │                       │
    │                       ▼
    │                  必須チェック
    │                  isLeeg(body)              ───▶  エラー or 成功
    │                       │
    │                       ▼
    │                  cls_mail_message
    │                  ├─ receiver設定
    │                  ├─ subject設定
    │                  ├─ body設定（linkURLS）
    │                  └─ send()                ───▶  メール送信
    │                       │
    │                       ▼
CC送信オプション      CC送信
(cc=true)             myMail.send()              ───▶  CC送信
    │                       │
    │                       ▼
    └──────────────▶  リダイレクト              ───▶  mailsent=true
                      (送信完了)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fs_mailcontact.asp | `asp/fs_mailcontact.asp` | ソース | メール連絡先メイン |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード集約 |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先クラス定義 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| logon.asp | `asp/includes/logon.asp` | ソース | ログオン管理クラス |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（linkURLS, sanitize等） |
| commonheader.asp | `asp/includes/commonheader.asp` | ソース | 共通ヘッダー |
| message.asp | `asp/includes/message.asp` | ソース | メッセージ表示クラス |
