# 画面設計書 181-リストページ変換

## 概要

本ドキュメントは、QuickerSite CMSにおける「リストページ変換」機能の画面設計書です。コンテンツページをリストページ形式に変換するためのリンク表示機能を提供します。

### 本画面の処理概要

この画面は、既存のコンテンツページ（通常のページやコンテナページ）をリストページに変換するための機能を提供するインクルードファイルです。リストページは複数のアイテムを一覧形式で表示するページタイプであり、ブログやニュース、FAQ等の用途に適しています。

**業務上の目的・背景**：サイト運営において、当初は通常のコンテンツページとして作成したページを、後からリスト形式（一覧形式）に変更したいケースが発生します。例えば、単一のお知らせページを複数のお知らせを管理するリストページに変更したい場合などです。この機能により、ページを削除・再作成することなく、スムーズにページタイプを変換できます。

**画面へのアクセス方法**：この機能は単独の画面ではなく、以下の編集画面にインクルードされて表示されます。
- コンテンツ付きアイテム編集画面（bs_editItem.asp）
- 外部URL編集画面（bs_editExternalURL.asp）
編集画面の下部に「リストページに変換」リンクとして表示されます。

**主要な操作・処理内容**：
1. リンクをクリックすると、リストページ編集画面（bs_editList.asp）に遷移する
2. 遷移時にページIDが暗号化されて渡される
3. 遷移先でページタイプがリストページに変更される

**画面遷移**：
- 遷移元：bs_editItem.asp、bs_editExternalURL.asp
- 遷移先：bs_editList.asp（リストページ編集画面）

**権限による表示制御**：
- ページIDが数値として有効であること（isNumeriek(page.iId)）
- secondAdmin.bPageBody権限がtrueであること（ページ本文編集権限）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | コンテンツページをリストページに変換 |
| 13 | リストページ管理 | 遷移先機能 | 変換後のリストページ設定 |

## 画面種別

インクルードファイル（変換リンク表示）

## URL/ルーティング

```
asp/bs_convertToListpage.asp（インクルードファイル）
遷移先: asp/bs_editList.asp?iID={暗号化されたページID}
```

## 入出力項目

### 入力パラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| page.iId | Integer | 必須 | 変換対象ページのID（pageオブジェクトから取得） |

### 出力

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換リンク | HTML | リストページ編集画面へのリンク |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 変換リンク | isNumeriek(page.iId) AND secondAdmin.bPageBody | 「リストページに変換」リンクを中央揃えで表示 |

## イベント仕様

### 1-リンククリック

**処理フロー**:
1. ユーザーが「リストページに変換」リンクをクリック
2. bs_editList.aspに遷移（iIDパラメータに暗号化されたページIDを付与）
3. bs_editList.aspでページがリストページとして再読み込みされる
4. リストページ固有の設定項目（ソート順、アコーディオン設定等）が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リンククリック | tblPage | UPDATE | 遷移先でページタイプが変更される |

### テーブル別更新項目詳細

#### tblPage（遷移先での更新）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | fixedType | sb_list (リストページタイプ) | ページタイプをリストに変更 |
| UPDATE | updatedTS | 現在日時 | 更新タイムスタンプ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| converttolistpage | リンクテキスト | 多言語ラベルから取得 | 常時（表示条件を満たす場合） |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| ページIDが無効 | リンクが表示されない |
| 権限不足 | リンクが表示されない |

## 備考

- この機能はインクルードファイルとして実装されており、単独では動作しない
- 変換処理自体は遷移先のbs_editList.aspで行われる
- リストページに変換後、元のコンテンツは保持される
- 変換後はリストアイテムを追加して一覧コンテンツを構築できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページオブジェクトとセカンドアドミン権限の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | pageオブジェクトのiIdプロパティと各種フラグ |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | secondAdmin.bPageBody権限の定義 |

**読解のコツ**: VBScriptのクラス定義（Class...End Class）内でPublicプロパティを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるインクルードファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_convertToListpage.asp | `asp/bs_convertToListpage.asp` | 条件判定とリンク生成ロジック |

**主要処理フロー**:
1. **2行目**: 条件判定（isNumeriek(page.iId) and secondAdmin.bPageBody）
2. **2行目**: リンクHTML生成（encrypt関数でiIDを暗号化）
3. **2行目**: 多言語対応（l("converttolistpage")でラベル取得）

#### Step 3: 呼び出し元を理解する

このファイルをインクルードしている画面を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editItem.asp | `asp/bs_editItem.asp` | コンテンツ付きアイテム編集画面 |
| 3-2 | bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | 外部URL編集画面 |

**主要処理フロー**:
- **bs_editItem.asp 16行目**: `<!-- #include file="bs_convertToListpage.asp"-->`でインクルード

#### Step 4: 遷移先を理解する

リンク先のリストページ編集画面を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_editList.asp | `asp/bs_editList.asp` | リストページ編集画面のメイン処理 |
| 4-2 | bs_processPage.asp | `asp/bs_processPage.asp` | ページ保存処理 |

### プログラム呼び出し階層図

```
bs_editItem.asp / bs_editExternalURL.asp
    │
    ├─ bs_security.asp (認証確認)
    │      └─ secondAdmin権限チェック
    │
    ├─ bs_process.asp (ページオブジェクト取得)
    │      └─ page.pick(decrypt(request("iId")))
    │
    └─ bs_convertToListpage.asp (インクルード)
           │
           └─ [クリック] ──▶ bs_editList.asp
                                  └─ リストページとして保存
```

### データフロー図

```
[入力]               [処理]                    [出力]

page.iId ───────▶ isNumeriek()判定 ───────▶ リンク表示/非表示
                       │
secondAdmin ────▶ bPageBody権限確認
                       │
l("converttolistpage") ▶ 多言語ラベル取得 ───▶ リンクテキスト
                       │
encrypt(page.iID) ──▶ ID暗号化 ────────────▶ 遷移URL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_convertToListpage.asp | `asp/bs_convertToListpage.asp` | ソース | 変換リンク表示（本ファイル） |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | インクルード元（コンテンツ編集） |
| bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | ソース | インクルード元（外部URL編集） |
| bs_editList.asp | `asp/bs_editList.asp` | ソース | 遷移先（リストページ編集） |
| page.asp | `asp/includes/page.asp` | ソース | ページオブジェクト定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限オブジェクト定義 |
| encryption.asp | `asp/includes/encryption.asp` | ソース | 暗号化関数定義 |
| language.asp | `asp/includes/language.asp` | ソース | 多言語対応関数 |
