# 画面設計書 184-コンテンツ付き変換

## 概要

本ドキュメントは、QuickerSite CMSにおける「コンテンツ付き変換」機能の画面設計書です。既存のページをコンテンツ付きアイテム（通常のコンテンツページ）に変換するためのリンク表示機能を提供します。

### 本画面の処理概要

この画面は、既存のコンテナページや外部URLページを、コンテンツ付きアイテム（通常のコンテンツページ）に変換するための機能を提供するインクルードファイルです。コンテンツ付きアイテムは、WYSIWYGエディタで編集可能な本文コンテンツを持つ標準的なページタイプです。

**業務上の目的・背景**：サイト構造の見直しにより、階層構造を持つコンテナページを単一のコンテンツページに変更したい場合や、外部へのリダイレクトページを自サイト内のコンテンツページに変更したい場合があります。この機能により、ページを削除・再作成することなく、通常のコンテンツページに変換できます。これにより、ページのURLやメニュー内の位置を維持しながら、ページタイプのみを変更することができます。

**画面へのアクセス方法**：この機能は単独の画面ではなく、以下の編集画面にインクルードされて表示されます。
- コンテナ編集画面（bs_editContainer.asp）
- 外部URL編集画面（bs_editExternalURL.asp）
編集画面の下部に「コンテンツ付きアイテムに変換」リンクとして表示されます。

**主要な操作・処理内容**：
1. リンクをクリックすると、コンテンツ付きアイテム編集画面（bs_editItem.asp）に遷移する
2. 遷移時にページIDが暗号化されて渡される
3. 遷移先でページタイプがコンテンツ付きアイテムに変更される

**画面遷移**：
- 遷移元：bs_editContainer.asp、bs_editExternalURL.asp
- 遷移先：bs_editItem.asp（コンテンツ付きアイテム編集画面）

**権限による表示制御**：
- ページIDが数値として有効であること（isNumeriek(page.iID)）
- ページがホームページではないこと（not page.bHomepage）
- secondAdmin.bPageBody権限がtrueであること（ページ本文編集権限）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | アイテムをコンテンツ付きに変換 |

## 画面種別

インクルードファイル（変換リンク表示）

## URL/ルーティング

```
asp/bs_convertToItemWithContent.asp（インクルードファイル）
遷移先: asp/bs_editItem.asp?iId={暗号化されたページID}
```

## 入出力項目

### 入力パラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| page.iID | Integer | 必須 | 変換対象ページのID（pageオブジェクトから取得） |
| page.bHomepage | Boolean | 必須 | ホームページフラグ（trueの場合は変換不可） |

### 出力

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換リンク | HTML | コンテンツ付きアイテム編集画面へのリンク |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 変換リンク | isNumeriek(page.iID) AND NOT page.bHomepage AND secondAdmin.bPageBody | 「コンテンツ付きアイテムに変換」リンクを中央揃えで表示 |

## イベント仕様

### 1-リンククリック

**処理フロー**:
1. ユーザーが「コンテンツ付きアイテムに変換」リンクをクリック
2. bs_editItem.aspに遷移（iIdパラメータに暗号化されたページIDを付与）
3. bs_editItem.aspでページがコンテンツ付きアイテムとして再読み込みされる
4. コンテンツ編集用のWYSIWYGエディタが表示される
5. 各種設定項目（メタタグ、テンプレート、カタログ連携等）が編集可能になる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リンククリック | tblPage | UPDATE | 遷移先でページタイプが変更される |

### テーブル別更新項目詳細

#### tblPage（遷移先での更新）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | fixedType | sb_item (コンテンツ付きアイテムタイプ) | ページタイプをコンテンツ付きに変更 |
| UPDATE | bContainerPage | false | コンテナフラグをOFF |
| UPDATE | sValue | 既存値または空 | 本文コンテンツ |
| UPDATE | updatedTS | 現在日時 | 更新タイムスタンプ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| convertToItemWithContent | リンクテキスト | 多言語ラベルから取得 | 常時（表示条件を満たす場合） |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| ページIDが無効 | リンクが表示されない |
| ホームページの場合 | リンクが表示されない |
| 権限不足 | リンクが表示されない |

## 備考

- ホームページは変換対象外
- この機能はインクルードファイルとして実装されており、単独では動作しない
- 変換処理自体は遷移先のbs_editItem.aspで行われる
- コンテナからの変換時、配下の子ページは親が変わることなく維持される（階層構造は保持）
- 外部URLからの変換時、リダイレクト設定はクリアされ、通常のコンテンツページとして動作する
- 変換後はWYSIWYGエディタで本文を編集可能になる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページオブジェクトとページタイプの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | pageオブジェクトのfixedType、sValueプロパティ |
| 1-2 | fixedTypeList.asp | `asp/includes/fixedTypeList.asp` | ページタイプ定数（sb_item等）の定義 |
| 1-3 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | secondAdmin.bPageBody権限の定義 |

**読解のコツ**: fixedTypeはページの種類を示す定数であり、sb_item、sb_container、sb_externalURL等の値を取る。

#### Step 2: エントリーポイントを理解する

処理の起点となるインクルードファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_convertToItemWithContent.asp | `asp/bs_convertToItemWithContent.asp` | 条件判定とリンク生成ロジック |

**主要処理フロー**:
1. **2行目**: 条件判定（isNumeriek(page.iID) and not page.bHomepage and secondAdmin.bPageBody）
2. **2行目**: リンクHTML生成（encrypt関数でiIdを暗号化）
3. **2行目**: 多言語対応（l("convertToItemWithContent")でラベル取得）

#### Step 3: 呼び出し元を理解する

このファイルをインクルードしている画面を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editContainer.asp | `asp/bs_editContainer.asp` | コンテナ編集画面 |
| 3-2 | bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | 外部URL編集画面 |

**主要処理フロー**:
- **bs_editContainer.asp 4行目**: `<!-- #include file="bs_convertToItemWithContent.asp"-->`でインクルード

#### Step 4: 遷移先を理解する

リンク先のコンテンツ付きアイテム編集画面を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_editItem.asp | `asp/bs_editItem.asp` | コンテンツ付きアイテム編集画面のメイン処理 |
| 4-2 | bs_processPage.asp | `asp/bs_processPage.asp` | ページ保存処理 |
| 4-3 | ckeditor.asp | `asp/includes/ckeditor.asp` | WYSIWYGエディタ |

### プログラム呼び出し階層図

```
bs_editContainer.asp / bs_editExternalURL.asp
    │
    ├─ bs_security.asp (認証確認)
    │      └─ secondAdmin権限チェック
    │
    ├─ bs_process.asp (ページオブジェクト取得)
    │      └─ page.pick(decrypt(request("iId")))
    │
    └─ bs_convertToItemWithContent.asp (インクルード)
           │
           ├─ page.bHomepage判定
           │
           └─ [クリック] ──▶ bs_editItem.asp
                                  │
                                  ├─ fixedType = sb_item で保存
                                  │
                                  └─ WYSIWYGエディタ表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

page.iID ───────▶ isNumeriek()判定 ───────▶
                       │
page.bHomepage ──▶ ホームページ判定 ───────▶ リンク表示/非表示
                       │
secondAdmin ────▶ bPageBody権限確認
                       │
l("convertToItemWithContent") ▶ 多言語ラベル取得 ▶ リンクテキスト
                       │
encrypt(page.iId) ──▶ ID暗号化 ────────────▶ 遷移URL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_convertToItemWithContent.asp | `asp/bs_convertToItemWithContent.asp` | ソース | 変換リンク表示（本ファイル） |
| bs_editContainer.asp | `asp/bs_editContainer.asp` | ソース | インクルード元（コンテナ編集） |
| bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | ソース | インクルード元（外部URL編集） |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | 遷移先（コンテンツ付きアイテム編集） |
| page.asp | `asp/includes/page.asp` | ソース | ページオブジェクト定義 |
| fixedTypeList.asp | `asp/includes/fixedTypeList.asp` | ソース | ページタイプ定数定義 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限オブジェクト定義 |
| encryption.asp | `asp/includes/encryption.asp` | ソース | 暗号化関数定義 |
| language.asp | `asp/includes/language.asp` | ソース | 多言語対応関数 |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | WYSIWYGエディタ |
