# 画面設計書 185-フリーページ変換

## 概要

本ドキュメントは、QuickerSite CMSにおける「フリーページ変換」機能の画面設計書です。既存のページをフリーページ（メニューに表示されない独立ページ）に変換するためのリンク表示機能を提供します。

### 本画面の処理概要

この画面は、既存のコンテンツ付きアイテムページをフリーページに変換するための機能を提供するインクルードファイルです。フリーページは、ナビゲーションメニューに表示されない独立したページであり、ランディングページ、特定キャンペーン用ページ、印刷用ページなどの用途に使用されます。

**業務上の目的・背景**：サイト運営において、メニュー構造に含めたくないページを作成する必要があることがあります。例えば、特定のキャンペーン専用のランディングページ、メール配信でのみリンクされるページ、印刷用に最適化されたページなどです。この機能により、既存のページをメニューから外し、直接URLでのみアクセス可能なフリーページに変換できます。

**画面へのアクセス方法**：この機能は単独の画面ではなく、コンテンツ付きアイテム編集画面（bs_editItem.asp）にインクルードされて表示されます。ただし、表示条件として`page.bCanBeConvertedToFP`プロパティがtrueである必要があります。編集画面の下部に「フリーページに変換」リンクとして表示されます。

**主要な操作・処理内容**：
1. 確認ダイアログが表示される（「本当によろしいですか？」）
2. 確認後、bs_convertToFP.aspにリダイレクトされ変換処理が実行される
3. 変換完了後、バックサイトホーム（bs_default.asp）または イントラネットホーム（bs_intranet.asp）にリダイレクトされる

**画面遷移**：
- 遷移元：bs_editItem.asp
- 遷移先：bs_convertToFP.asp -> bs_default.asp または bs_intranet.asp

**権限による表示制御**：
- page.bCanBeConvertedToFPプロパティがtrueであること

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | ページをフリーページに変換 |

## 画面種別

インクルードファイル（変換リンク表示）

## URL/ルーティング

```
asp/bs_convertToFreePage.asp（インクルードファイル）
遷移先: asp/bs_convertToFP.asp?{CSRFトークン}&btnaction=ConvertToFP&iId={暗号化されたページID}
```

## 入出力項目

### 入力パラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| page.iId | Integer | 必須 | 変換対象ページのID（pageオブジェクトから取得） |
| page.bCanBeConvertedToFP | Boolean | 必須 | フリーページ変換可能フラグ |
| QS_secCodeURL | String | 必須 | CSRFトークン（URL形式） |

### 出力

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換リンク | HTML | フリーページ変換処理へのリンク |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 変換リンク | page.bCanBeConvertedToFP = true | 「フリーページに変換」リンクを中央揃えで表示 |

## イベント仕様

### 1-リンククリック

**処理フロー**:
1. ユーザーが「フリーページに変換」リンクをクリック
2. JavaScript確認ダイアログが表示される（l("areyousure")のメッセージ）
3. ユーザーが「OK」を選択した場合、bs_convertToFP.aspに遷移
4. bs_convertToFP.aspでconvertToFP()メソッドが実行される
5. 変換成功後、ページタイプに応じたホーム画面にリダイレクト
   - イントラネットページの場合：bs_intranet.asp
   - 通常ページの場合：bs_default.asp

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リンククリック（確認後） | tblPage | UPDATE | ページがフリーページに変換される |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bLossePagina | true | フリーページフラグをON |
| UPDATE | iParentID | null | 親ページとの関連を解除 |
| UPDATE | updatedTS | 現在日時 | 更新タイムスタンプ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| converttofreepage | リンクテキスト | 多言語ラベルから取得 | 常時（表示条件を満たす場合） |
| areyousure | 確認ダイアログ | 多言語ラベルから取得（「本当によろしいですか？」） | リンククリック時 |
| err_mandatory | エラー | 多言語ラベルから取得 | 変換失敗時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| bCanBeConvertedToFPがfalse | リンクが表示されない |
| CSRF検証失敗 | 変換処理が中断される |
| 変換処理失敗 | エラーメッセージが表示される |

## 備考

- bCanBeConvertedToFPはページオブジェクトのプロパティで、変換可能かどうかを判定する
- フリーページに変換すると、メニューから消えるが、直接URLでアクセスは可能
- フリーページはbLossePaginaフラグがtrueのページとして管理される
- CSRF対策として、QS_secCodeURLトークンが必要
- 確認ダイアログにより、誤操作を防止している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページオブジェクトとフリーページの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | bLossePagina、bCanBeConvertedToFPプロパティ |

**読解のコツ**: bLossePaginaはオランダ語で「単独ページ」を意味し、フリーページを識別するフラグ。

#### Step 2: エントリーポイントを理解する

処理の起点となるインクルードファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_convertToFreePage.asp | `asp/bs_convertToFreePage.asp` | 条件判定とリンク生成ロジック |

**主要処理フロー**:
1. **2行目**: 条件判定（page.bCanBeConvertedToFP）
2. **2行目**: JavaScript確認ダイアログ（onclick="javascript:return confirm('<%=l("areyousure")%>');"）
3. **2行目**: CSRFトークン付与（QS_secCodeURL）
4. **2行目**: 多言語対応（l("converttofreepage")でラベル取得）

#### Step 3: 変換処理を理解する

実際の変換処理を行うファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_convertToFP.asp | `asp/bs_convertToFP.asp` | メイン処理ファイル |
| 3-2 | bs_process.asp | `asp/bs_process.asp` | ConvertToFPケースの処理 |

**主要処理フロー**:
- **bs_process.asp 6-16行目**: btnaction="ConvertToFP"の処理
  - checkCSRF()でCSRF検証
  - page.convertToFP()でフリーページ変換
  - 成功時：ホーム画面にリダイレクト
  - 失敗時：エラーメッセージ追加

### プログラム呼び出し階層図

```
bs_editItem.asp
    │
    └─ bs_convertToFreePage.asp (インクルード)
           │
           └─ [クリック + 確認] ──▶ bs_convertToFP.asp
                                        │
                                        ├─ bs_security.asp (認証確認)
                                        │
                                        ├─ bs_process.asp
                                        │      ├─ checkCSRF()
                                        │      └─ page.convertToFP()
                                        │
                                        └─ リダイレクト
                                               ├─ bs_intranet.asp (イントラネット)
                                               └─ bs_default.asp (通常)
```

### データフロー図

```
[入力]               [処理]                    [出力]

page.bCanBeConvertedToFP ──▶ 変換可否判定 ─▶ リンク表示/非表示
                                 │
[クリック] ──────────────────▶ 確認ダイアログ
                                 │
                           [OK選択]
                                 │
QS_secCodeURL ───────────▶ CSRF検証 ───────▶ 変換処理
                                 │
page.iId ────────────────▶ convertToFP() ──▶ bLossePagina = true
                                 │
                           [成功]
                                 │
page.bIntranet ──────────▶ 遷移先判定 ─────▶ ホーム画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_convertToFreePage.asp | `asp/bs_convertToFreePage.asp` | ソース | 変換リンク表示（本ファイル） |
| bs_convertToFP.asp | `asp/bs_convertToFP.asp` | ソース | 変換処理メイン |
| bs_process.asp | `asp/bs_process.asp` | ソース | 変換処理ロジック |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | インクルード元 |
| page.asp | `asp/includes/page.asp` | ソース | ページオブジェクト・変換メソッド |
| encryption.asp | `asp/includes/encryption.asp` | ソース | 暗号化関数定義 |
| language.asp | `asp/includes/language.asp` | ソース | 多言語対応関数 |
