# 画面設計書 186-FP変換

## 概要

本ドキュメントは、QuickerSite CMSにおける「FP変換」機能（フリーページ変換処理）の画面設計書です。実際のフリーページ変換処理を実行するバックエンド処理画面です。

### 本画面の処理概要

この画面は、フリーページ変換のバックエンド処理を実行するASPファイルです。bs_convertToFreePage.aspからのリンクを通じて呼び出され、ページオブジェクトのconvertToFP()メソッドを実行してフリーページへの変換を行います。処理完了後は適切なホーム画面にリダイレクトされます。

**業務上の目的・背景**：フリーページ変換機能（No.185）のバックエンド処理を担当します。ユーザーインターフェースとしての役割よりも、処理実行とリダイレクトを行う中継画面として機能します。セキュリティ面では、CSRF対策としてトークン検証を行い、不正なリクエストを防止します。

**画面へのアクセス方法**：この画面は直接アクセスするものではなく、bs_convertToFreePage.aspのリンクからのみアクセスされます。
- 遷移元：bs_editItem.asp -> bs_convertToFreePage.asp（リンク）
- 必須パラメータ：btnaction=ConvertToFP、iId、CSRFトークン

**主要な操作・処理内容**：
1. CSRF検証（checkCSRF()）
2. ページオブジェクトの取得（page.pick）
3. フリーページ変換処理（page.convertToFP()）
4. 結果に応じたリダイレクト

**画面遷移**：
- 遷移元：bs_convertToFreePage.asp（リンク）
- 遷移先：
  - 成功時（イントラネット）：bs_intranet.asp
  - 成功時（通常）：bs_default.asp
  - 失敗時：エラーメッセージ表示後、元の画面

**権限による表示制御**：
- バックサイトへの認証が必要（bs_security.aspによる検証）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | フリーページ変換処理 |

## 画面種別

処理画面（バックエンド処理・リダイレクト）

## URL/ルーティング

```
asp/bs_convertToFP.asp?{CSRFトークン}&btnaction=ConvertToFP&iId={暗号化されたページID}
```

## 入出力項目

### 入力パラメータ

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| btnaction | String | 必須 | アクション識別子（"ConvertToFP"） |
| iId | String | 必須 | 暗号化されたページID |
| QS_secCodeURL | String | 必須 | CSRFトークン |

### 出力

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リダイレクト | HTTP 302 | 処理完了後のリダイレクト |
| エラーメッセージ | HTML | 処理失敗時のメッセージ |

## 表示項目

この画面はUI表示を行わず、処理完了後は即座にリダイレクトされます。

## イベント仕様

### 1-ページ読み込み時（btnaction=ConvertToFP）

**処理フロー**:
1. bs_security.aspでバックサイト認証を確認
2. bs_process.aspでbtnaction値を評価
3. btnaction="ConvertToFP"の場合、以下の処理を実行：
   - checkCSRF()でCSRFトークンを検証
   - page.convertToFP()でフリーページ変換を実行
   - 変換成功時：
     - page.bIntranet=trueならbs_intranet.aspへリダイレクト
     - それ以外はbs_default.aspへリダイレクト
   - 変換失敗時：
     - message.AddError("err_mandatory")でエラー追加
4. cleanupASP()でリソースクリーンアップ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ConvertToFP | tblPage | UPDATE | ページをフリーページに変換 |

### テーブル別更新項目詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bLossePagina | true | フリーページフラグをON |
| UPDATE | iParentID | null | 親ページとの関連を解除 |
| UPDATE | iRang | null | 並び順をクリア |
| UPDATE | updatedTS | 現在日時 | 更新タイムスタンプ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_mandatory | エラー | 多言語ラベルから取得 | 変換処理失敗時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| CSRF検証失敗 | 処理中断、エラーページ表示 |
| ページIDが無効 | 変換処理が失敗しエラーメッセージ表示 |
| convertToFP()失敗 | err_mandatoryエラーが追加される |

## 備考

- この画面はUIを持たない処理専用ページ
- bs_process.aspにインクルードされる形で処理ロジックが実装されている
- 認証・認可はbs_security.aspで行われる
- 処理完了後は必ずリダイレクトが行われるため、通常はこの画面自体は表示されない
- cleanupASP()関数でASPリソースのクリーンアップが行われる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページオブジェクトとフリーページ変換の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | convertToFP()メソッドの実装 |

**読解のコツ**: convertToFP()メソッドは、bLossePaginaフラグをtrueに設定し、親ページとの関連を解除する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_convertToFP.asp | `asp/bs_convertToFP.asp` | メインファイル構造 |

**主要処理フロー**:
1. **1行目**: begin.aspインクルード（初期化処理）
2. **4行目**: bs_security.aspインクルード（認証処理）
3. **4行目**: bs_process.aspインクルード（ビジネスロジック）
4. **4行目**: message.showAlert()でメッセージ表示
5. **5行目**: cleanupASP()でクリーンアップ

#### Step 3: ビジネスロジックを理解する

ConvertToFPケースの処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | ConvertToFPケースの処理（6-16行目） |

**主要処理フロー**:
- **3行目**: page.pick(decrypt(request("iId")))でページ取得
- **5行目**: select case request("btnaction")で分岐
- **6-7行目**: case "ConvertToFP"
- **7行目**: checkCSRF()でCSRF検証
- **8行目**: page.convertToFP()で変換処理
- **9-13行目**: 結果に応じたリダイレクト
- **14-16行目**: 失敗時のエラー処理

### プログラム呼び出し階層図

```
bs_convertToFP.asp
    │
    ├─ begin.asp (初期化)
    │      └─ 各種インクルード
    │
    ├─ bs_security.asp (認証確認)
    │      ├─ セッション確認
    │      └─ secondAdmin権限設定
    │
    ├─ bs_process.asp (ビジネスロジック)
    │      │
    │      ├─ page.pick() (ページ取得)
    │      │
    │      └─ case "ConvertToFP"
    │             ├─ checkCSRF()
    │             ├─ page.convertToFP()
    │             └─ Response.Redirect()
    │
    ├─ message.showAlert() (メッセージ表示)
    │
    └─ cleanupASP() (クリーンアップ)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

btnaction ─────────▶ select case判定
                           │
                      [ConvertToFP]
                           │
CSRFトークン ────────▶ checkCSRF() ───────────▶ [検証失敗: 中断]
                           │
                      [検証成功]
                           │
iId ─────────────────▶ page.pick() ───────────▶ ページオブジェクト
                           │
                      page.convertToFP()
                           │
                      [成功/失敗]
                           │
page.bIntranet ──────▶ リダイレクト先判定 ────▶ HTTP 302
                           │
                      bs_intranet.asp
                      または
                      bs_default.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_convertToFP.asp | `asp/bs_convertToFP.asp` | ソース | メイン処理ファイル（本ファイル） |
| bs_process.asp | `asp/bs_process.asp` | ソース | ビジネスロジック（ConvertToFPケース） |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード |
| page.asp | `asp/includes/page.asp` | ソース | ページオブジェクト・convertToFP()メソッド |
| functions.asp | `asp/includes/functions.asp` | ソース | checkCSRF()、cleanupASP()関数 |
| messages.asp | `asp/includes/messages.asp` | ソース | メッセージ表示機能 |
