# 画面設計書 187-初期セットアップ

## 概要

本ドキュメントは、QuickerSite CMSにおける「初期セットアップ」画面の画面設計書です。新規サイトの初期設定を行うためのセットアップウィザード画面です。

### 本画面の処理概要

この画面は、QuickerSite CMSの新規インストール後または初期状態時に表示される初期セットアップ画面です。サイトの基本情報（組織名、URL、言語等）とバックサイト管理者のパスワードを設定します。初期状態のサンプルサイトから始めるか、空のサイトから始めるかを選択することもできます。

**業務上の目的・背景**：QuickerSite CMSの新規導入時に、サイト運営に必要な基本情報を一括で設定するための画面です。セキュリティの観点から、デフォルトパスワードのままでは本番運用できないよう、初回アクセス時にパスワード変更を強制しています。これにより、セキュリティリスクを最小化しつつ、スムーズなサイト立ち上げを支援します。

**画面へのアクセス方法**：
- デフォルトパスワードでログインしている場合、自動的にリダイレクトされる
- URL: asp/bs_initialsetup.asp
- 直接アクセスした場合、デフォルトパスワードでない場合はbs_admin.aspにリダイレクトされる

**主要な操作・処理内容**：
1. 組織名の入力（必須）
2. サイトURLの入力（必須）
3. サイトタイトルの入力
4. コピーライト情報の入力
5. 日付フォーマットの選択
6. サイト言語の選択
7. ウェブマスター名・メールアドレスの入力
8. バックサイトパスワードの設定（必須、確認入力）
9. 開始モードの選択（サンプルサイト/空サイト）
10. 保存ボタン押下で設定を適用

**画面遷移**：
- 遷移元：bs_login.asp（デフォルトパスワードでログイン時）、bs_security.asp（自動リダイレクト）
- 遷移先：bs_default.asp（設定完了後）

**権限による表示制御**：
- デフォルトパスワードでログインしている場合のみアクセス可能
- それ以外の場合はbs_admin.aspにリダイレクト

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | サイトの初期セットアップ |
| 4 | パスワード変更 | 補助機能 | 管理者パスワードの初期設定 |

## 画面種別

登録/設定画面（ウィザード形式）

## URL/ルーティング

```
asp/bs_initialsetup.asp
```

## 入出力項目

### 入力項目

| 項目名 | フィールド名 | 型 | 必須 | 最大長 | 説明 |
|--------|-------------|-----|------|--------|------|
| 組織名 | siteName | String | 必須 | 254 | サイトを運営する組織名 |
| URL | sUrl | String | 必須 | 254 | サイトのURL |
| サイトタイトル | siteTitle | String | - | 254 | サイトのタイトル |
| コピーライト | copyRight | String | - | 254 | コピーライト表記（METAタグ） |
| 日付フォーマット | sDatumFormat | Integer | - | - | 日付表示形式 |
| サイト言語 | language | Integer | - | - | サイトの言語 |
| ウェブマスター名 | webmaster | String | - | 254 | ウェブマスターの名前（METAタグauthor） |
| ウェブマスターメール | webmasterEmail | String | - | 254 | ウェブマスターのメールアドレス |
| パスワード | adminPassword | String | 必須 | 30 | バックサイトパスワード |
| パスワード確認 | adminPasswordBis | String | 必須 | 30 | パスワード確認入力 |
| 開始モード | start | String | 必須 | - | "sample"（サンプル）または"clean"（空） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 設定フォーム | HTML | 初期設定入力フォーム |
| エラーメッセージ | HTML | 入力エラー時のメッセージ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ウェルカムメッセージ | テキスト | l("thankyouforusingqs") |
| セットアップ説明 | テキスト | l("initialsetup") |
| 入力フォーム | フォーム | 各設定項目の入力欄 |
| 言語選択 | ドロップダウン | languageList.showSelected() |
| 日付フォーマット選択 | ドロップダウン | dateFormatList.showSelected() |
| 開始モード選択 | ラジオボタン | サンプル/空サイト |

## イベント仕様

### 1-保存ボタン押下（btnaction=saveSetupAdmin）

**処理フロー**:
1. 確認ダイアログ表示（l("areyousure")）
2. CSRF検証（checkCSRF()）
3. フォーム値取得（getRequestForm()）
4. 必須項目チェック
   - 開始モード（start）が未選択の場合、エラー
5. パスワード一致チェック
   - adminPasswordとadminPasswordBisが不一致の場合、エラー
6. customer.save()でサイト情報保存
7. customer.saveAdminPW()でパスワード保存
8. 開始モードが"clean"の場合
   - customer.reset()でサイトをリセット
   - 再度フォーム値取得
   - customer.save()で再保存
9. removeApplication()でアプリケーションキャッシュクリア
10. bs_default.aspにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | サイト基本情報の更新 |
| 保存ボタン押下（clean） | tblPage | DELETE/INSERT | ページのリセット・初期化 |
| 保存ボタン押下（clean） | 各種テーブル | DELETE | 関連データのリセット |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sURL | フォーム入力値 | サイトURL |
| UPDATE | siteName | フォーム入力値 | 組織名 |
| UPDATE | siteTitle | フォーム入力値 | サイトタイトル |
| UPDATE | copyRight | フォーム入力値 | コピーライト |
| UPDATE | language | フォーム入力値 | 言語ID |
| UPDATE | webmaster | フォーム入力値 | ウェブマスター名 |
| UPDATE | webmasterEmail | フォーム入力値 | メールアドレス |
| UPDATE | sDatumFormat | フォーム入力値 | 日付フォーマット |
| UPDATE | adminPassword | SHA256ハッシュ値 | 暗号化されたパスワード |
| UPDATE | dUpdatedTS | 現在日時 | 更新タイムスタンプ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| thankyouforusingqs | 情報 | QuickerSite利用のお礼メッセージ | 常時 |
| initialsetup | 情報 | 初期セットアップの説明 | 常時 |
| err_mandatory | エラー | 必須項目未入力 | 開始モード未選択時 |
| pwnomatch | エラー | パスワード不一致 | パスワードと確認が異なる場合 |
| areyousure | 確認 | 確認ダイアログ | 保存ボタン押下時 |
| mandatory | 情報 | 必須項目の説明 | 常時（フォーム下部） |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| デフォルトパスワードでない | bs_admin.aspにリダイレクト |
| 必須項目未入力 | エラーメッセージ表示、フォーム再表示 |
| パスワード不一致 | エラーメッセージ表示、フォーム再表示 |
| 保存処理失敗 | エラーメッセージ表示、フォーム再表示 |

## 備考

- この画面はデフォルトパスワード状態でのみアクセス可能
- パスワードはSHA256でハッシュ化されて保存される
- "clean"モードを選択すると、サイトの全データがリセットされる（要注意）
- 日付フォーマットと言語は専用のリストクラスから選択肢を取得
- サイトURLは自動的にサーバー変数から初期値を取得
- bUseArtLoginTemplate=trueでArtisteerスタイルのログインテンプレートを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、顧客オブジェクトの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | customerオブジェクトの各プロパティ |
| 1-2 | languageList.asp | `asp/includes/languageList.asp` | 言語選択リストの構造 |
| 1-3 | dateFormatList.asp | `asp/includes/dateFormatList.asp` | 日付フォーマットリストの構造 |

**読解のコツ**: customerオブジェクトはサイト全体の設定を管理する重要なオブジェクト。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_initialsetup.asp | `asp/bs_initialsetup.asp` | メインファイル全体 |

**主要処理フロー**:
1. **4行目**: bUseArtLoginTemplate=true設定
2. **6行目**: デフォルトパスワードチェック、違えばbs_admin.aspへリダイレクト
3. **7-16行目**: getRequestForm()でフォーム値取得
4. **17行目**: customer.resetDBConn=false設定
5. **18-38行目**: btnaction="saveSetupAdmin"の処理
6. **39-41行目**: 初期URL設定（サーバー変数から取得）
7. **42-45行目**: 言語・日付フォーマットリストの初期化
8. **45行目以降**: HTMLフォーム出力

#### Step 3: 保存処理を理解する

保存処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | save()、saveAdminPW()、reset()メソッド |

**主要処理フロー**:
- **customer.save()**: tblCustomerテーブルを更新
- **customer.saveAdminPW()**: パスワードをSHA256でハッシュ化して保存
- **customer.reset()**: サイトデータを全てリセット（"clean"モード時）

### プログラム呼び出し階層図

```
bs_initialsetup.asp
    │
    ├─ begin.asp (初期化)
    │
    ├─ bs_security.asp (認証確認)
    │      └─ デフォルトPWチェック
    │             └─ 不一致：bs_admin.aspへリダイレクト
    │
    ├─ [POST: saveSetupAdmin]
    │      ├─ checkCSRF()
    │      ├─ getRequestForm() (フォーム値取得)
    │      ├─ 必須・パスワードチェック
    │      ├─ customer.save()
    │      ├─ customer.saveAdminPW()
    │      ├─ [clean mode]
    │      │      ├─ customer.reset()
    │      │      └─ customer.save()
    │      ├─ removeApplication()
    │      └─ bs_default.aspへリダイレクト
    │
    └─ HTMLフォーム出力
           ├─ languageList.showSelected()
           └─ dateFormatList.showSelected()
```

### データフロー図

```
[入力]                    [処理]                    [出力]

Request.Form ──────▶ getRequestForm() ───────▶ customerオブジェクト
                           │
                      バリデーション
                           │
                      [成功]
                           │
customer.save() ────▶ tblCustomer UPDATE
                           │
adminPassword ──────▶ SHA256ハッシュ ────────▶ tblCustomer UPDATE
                           │
[clean mode] ──────▶ customer.reset() ────────▶ 全テーブルリセット
                           │
removeApplication() ▶ キャッシュクリア
                           │
                      bs_default.aspへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_initialsetup.asp | `asp/bs_initialsetup.asp` | ソース | メイン画面（本ファイル） |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客オブジェクト定義 |
| languageList.asp | `asp/includes/languageList.asp` | ソース | 言語リスト |
| dateFormatList.asp | `asp/includes/dateFormatList.asp` | ソース | 日付フォーマットリスト |
| sha256.asp | `asp/includes/sha256.asp` | ソース | SHA256ハッシュ関数 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化・インクルード |
| header.asp | `asp/includes/header.asp` | テンプレート | ヘッダー出力 |
| footer.asp | `asp/includes/footer.asp` | テンプレート | フッター出力 |
